/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.bastmodell.parameter;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Parameter zur Erstellung einer BastDatei.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 4
 */
public class PdBastDateiParameter extends AbstractParameterDatensatz<PdBastDateiParameter.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.ParameterDefault,
					Aspekte.ParameterSoll,
					Aspekte.ParameterVorgabe,
					Aspekte.ParameterIst,
				};
			}
	
			/**
			 * Aspekt der zur Versorgung von Defaultwerten für Parameter verwendet werden kann.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterDefault = new Aspekte("Default-Parameter-Aspekt", "asp.parameterDefault");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterSoll = new Aspekte("Soll-Parameter-Aspekt", "asp.parameterSoll");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterVorgabe = new Aspekte("Vorgabe-Parameter-Aspekt", "asp.parameterVorgabe");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterIst = new Aspekte("Ist-Parameter-Aspekt", "asp.parameterIst");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 _urlasser
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 _kfz
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 _lkw
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 _pkw
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 _lv
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 _sv
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 _pv
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 _gv
				;
				private 	Double
				 _hochrechnungsfaktor
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttProzent
				 _lkwAbweichungUnten
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttProzent
				 _lkwAbweichungOben
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttProzent
				 _pkwAbweichungUnten
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttProzent
				 _pkwAbweichungOben
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 _ersetzen
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
				 _einzelfehlerGrenze
				;
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@return der Wert von Urlasser.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 getUrlasser() {
				return _urlasser;
			}
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@param _urlasser der neue Wert von Urlasser.
			*/
			public void setUrlasser(de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
			 _urlasser) {
				this._urlasser = _urlasser;
			}
		
			/**
			Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
			<p>
			
			</p>
			
			@return der Wert von Kfz.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 getKfz() {
				return _kfz;
			}
		
			/**
			Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
			<p>
			
			</p>
			
			@param _kfz der neue Wert von Kfz.
			*/
			public void setKfz(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _kfz) {
				this._kfz = _kfz;
			}
		
			/**
			Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
			<p>
			
			</p>
			
			@return der Wert von Lkw.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 getLkw() {
				return _lkw;
			}
		
			/**
			Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
			<p>
			
			</p>
			
			@param _lkw der neue Wert von Lkw.
			*/
			public void setLkw(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _lkw) {
				this._lkw = _lkw;
			}
		
			/**
			Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
			<p>
			
			</p>
			
			@return der Wert von Pkw.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 getPkw() {
				return _pkw;
			}
		
			/**
			Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
			<p>
			
			</p>
			
			@param _pkw der neue Wert von Pkw.
			*/
			public void setPkw(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _pkw) {
				this._pkw = _pkw;
			}
		
			/**
			Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
			<p>
			
			</p>
			
			@return der Wert von Lv.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 getLv() {
				return _lv;
			}
		
			/**
			Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
			<p>
			
			</p>
			
			@param _lv der neue Wert von Lv.
			*/
			public void setLv(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _lv) {
				this._lv = _lv;
			}
		
			/**
			Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
			<p>
			
			</p>
			
			@return der Wert von Sv.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 getSv() {
				return _sv;
			}
		
			/**
			Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
			<p>
			
			</p>
			
			@param _sv der neue Wert von Sv.
			*/
			public void setSv(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _sv) {
				this._sv = _sv;
			}
		
			/**
			Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
			<p>
			
			</p>
			
			@return der Wert von Pv.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 getPv() {
				return _pv;
			}
		
			/**
			Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
			<p>
			
			</p>
			
			@param _pv der neue Wert von Pv.
			*/
			public void setPv(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _pv) {
				this._pv = _pv;
			}
		
			/**
			Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
			<p>
			
			</p>
			
			@return der Wert von Gv.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 getGv() {
				return _gv;
			}
		
			/**
			Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
			<p>
			
			</p>
			
			@param _gv der neue Wert von Gv.
			*/
			public void setGv(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _gv) {
				this._gv = _gv;
			}
		
			/**
			Attribut zur Darstellung von Faktoren mit einer Fließkommazahl.
			<p>
			
			</p>
			
			@return der Wert von Hochrechnungsfaktor.
			*/
				public 	Double
				 getHochrechnungsfaktor() {
				return _hochrechnungsfaktor;
			}
		
			/**
			Attribut zur Darstellung von Faktoren mit einer Fließkommazahl.
			<p>
			
			</p>
			
			@param _hochrechnungsfaktor der neue Wert von Hochrechnungsfaktor.
			*/
			public void setHochrechnungsfaktor(	Double
			 _hochrechnungsfaktor) {
				this._hochrechnungsfaktor = _hochrechnungsfaktor;
			}
		
			/**
			Prozentwert.
			<p>
			
			</p>
			
			@return der Wert von LkwAbweichungUnten.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttProzent
				 getLkwAbweichungUnten() {
				return _lkwAbweichungUnten;
			}
		
			/**
			Prozentwert.
			<p>
			
			</p>
			
			@param _lkwAbweichungUnten der neue Wert von LkwAbweichungUnten.
			*/
			public void setLkwAbweichungUnten(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttProzent
			 _lkwAbweichungUnten) {
				this._lkwAbweichungUnten = _lkwAbweichungUnten;
			}
		
			/**
			Prozentwert.
			<p>
			
			</p>
			
			@return der Wert von LkwAbweichungOben.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttProzent
				 getLkwAbweichungOben() {
				return _lkwAbweichungOben;
			}
		
			/**
			Prozentwert.
			<p>
			
			</p>
			
			@param _lkwAbweichungOben der neue Wert von LkwAbweichungOben.
			*/
			public void setLkwAbweichungOben(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttProzent
			 _lkwAbweichungOben) {
				this._lkwAbweichungOben = _lkwAbweichungOben;
			}
		
			/**
			Prozentwert.
			<p>
			
			</p>
			
			@return der Wert von PkwAbweichungUnten.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttProzent
				 getPkwAbweichungUnten() {
				return _pkwAbweichungUnten;
			}
		
			/**
			Prozentwert.
			<p>
			
			</p>
			
			@param _pkwAbweichungUnten der neue Wert von PkwAbweichungUnten.
			*/
			public void setPkwAbweichungUnten(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttProzent
			 _pkwAbweichungUnten) {
				this._pkwAbweichungUnten = _pkwAbweichungUnten;
			}
		
			/**
			Prozentwert.
			<p>
			
			</p>
			
			@return der Wert von PkwAbweichungOben.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttProzent
				 getPkwAbweichungOben() {
				return _pkwAbweichungOben;
			}
		
			/**
			Prozentwert.
			<p>
			
			</p>
			
			@param _pkwAbweichungOben der neue Wert von PkwAbweichungOben.
			*/
			public void setPkwAbweichungOben(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttProzent
			 _pkwAbweichungOben) {
				this._pkwAbweichungOben = _pkwAbweichungOben;
			}
		
			/**
			Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
			<p>
			
			</p>
			
			@return der Wert von Ersetzen.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 getErsetzen() {
				return _ersetzen;
			}
		
			/**
			Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
			<p>
			
			</p>
			
			@param _ersetzen der neue Wert von Ersetzen.
			*/
			public void setErsetzen(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _ersetzen) {
				this._ersetzen = _ersetzen;
			}
		
			/**
			Beliebige ganze Zahl im Bereich -2^63 bis (2^63)-1.
			<p>
			
			</p>
			
			@return der Wert von EinzelfehlerGrenze.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
				 getEinzelfehlerGrenze() {
				return _einzelfehlerGrenze;
			}
		
			/**
			Beliebige ganze Zahl im Bereich -2^63 bis (2^63)-1.
			<p>
			
			</p>
			
			@param _einzelfehlerGrenze der neue Wert von EinzelfehlerGrenze.
			*/
			public void setEinzelfehlerGrenze(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			 _einzelfehlerGrenze) {
				this._einzelfehlerGrenze = _einzelfehlerGrenze;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().bean2Atl(datum.getItem("Urlasser"), factory);
					// GanzzahlAttributTyp
					if (getKfz() != null) {
		                if (getKfz().isZustand()) {
		                    datum.getUnscaledValue("Kfz").setText(getKfz().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Kfz").set(getKfz().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getLkw() != null) {
		                if (getLkw().isZustand()) {
		                    datum.getUnscaledValue("Lkw").setText(getLkw().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Lkw").set(getLkw().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getPkw() != null) {
		                if (getPkw().isZustand()) {
		                    datum.getUnscaledValue("Pkw").setText(getPkw().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Pkw").set(getPkw().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getLv() != null) {
		                if (getLv().isZustand()) {
		                    datum.getUnscaledValue("Lv").setText(getLv().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Lv").set(getLv().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getSv() != null) {
		                if (getSv().isZustand()) {
		                    datum.getUnscaledValue("Sv").setText(getSv().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Sv").set(getSv().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getPv() != null) {
		                if (getPv().isZustand()) {
		                    datum.getUnscaledValue("Pv").setText(getPv().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Pv").set(getPv().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getGv() != null) {
		                if (getGv().isZustand()) {
		                    datum.getUnscaledValue("Gv").setText(getGv().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Gv").set(getGv().getValue());
		                }
					}
					// KommazahlAttributTyp
					if (getHochrechnungsfaktor() != null) {
						datum.getUnscaledValue("Hochrechnungsfaktor").set(getHochrechnungsfaktor());
					}
					// GanzzahlAttributTyp
					if (getLkwAbweichungUnten() != null) {
		                if (getLkwAbweichungUnten().isZustand()) {
		                    datum.getUnscaledValue("LkwAbweichungUnten").setText(getLkwAbweichungUnten().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("LkwAbweichungUnten").set(getLkwAbweichungUnten().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getLkwAbweichungOben() != null) {
		                if (getLkwAbweichungOben().isZustand()) {
		                    datum.getUnscaledValue("LkwAbweichungOben").setText(getLkwAbweichungOben().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("LkwAbweichungOben").set(getLkwAbweichungOben().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getPkwAbweichungUnten() != null) {
		                if (getPkwAbweichungUnten().isZustand()) {
		                    datum.getUnscaledValue("PkwAbweichungUnten").setText(getPkwAbweichungUnten().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("PkwAbweichungUnten").set(getPkwAbweichungUnten().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getPkwAbweichungOben() != null) {
		                if (getPkwAbweichungOben().isZustand()) {
		                    datum.getUnscaledValue("PkwAbweichungOben").setText(getPkwAbweichungOben().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("PkwAbweichungOben").set(getPkwAbweichungOben().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getErsetzen() != null) {
		                if (getErsetzen().isZustand()) {
		                    datum.getUnscaledValue("Ersetzen").setText(getErsetzen().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Ersetzen").set(getErsetzen().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getEinzelfehlerGrenze() != null) {
		                if (getEinzelfehlerGrenze().isZustand()) {
		                    datum.getUnscaledValue("EinzelfehlerGrenze").setText(getEinzelfehlerGrenze().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("EinzelfehlerGrenze").set(getEinzelfehlerGrenze().getValue());
		                }
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().atl2Bean(daten.getItem("Urlasser"), factory);
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("Kfz").isState()) {
								setKfz(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
								.getZustand(daten.getScaledValue("Kfz").getText()));
							} else {
							setKfz(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							(daten.
								getUnscaledValue
							("Kfz").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("Lkw").isState()) {
								setLkw(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
								.getZustand(daten.getScaledValue("Lkw").getText()));
							} else {
							setLkw(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							(daten.
								getUnscaledValue
							("Lkw").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("Pkw").isState()) {
								setPkw(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
								.getZustand(daten.getScaledValue("Pkw").getText()));
							} else {
							setPkw(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							(daten.
								getUnscaledValue
							("Pkw").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("Lv").isState()) {
								setLv(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
								.getZustand(daten.getScaledValue("Lv").getText()));
							} else {
							setLv(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							(daten.
								getUnscaledValue
							("Lv").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("Sv").isState()) {
								setSv(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
								.getZustand(daten.getScaledValue("Sv").getText()));
							} else {
							setSv(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							(daten.
								getUnscaledValue
							("Sv").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("Pv").isState()) {
								setPv(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
								.getZustand(daten.getScaledValue("Pv").getText()));
							} else {
							setPv(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							(daten.
								getUnscaledValue
							("Pv").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("Gv").isState()) {
								setGv(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
								.getZustand(daten.getScaledValue("Gv").getText()));
							} else {
							setGv(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							(daten.
								getUnscaledValue
							("Gv").
									byteValue
							()));
							}
					// KommazahlAttributTyp
						setHochrechnungsfaktor(daten.getUnscaledValue("Hochrechnungsfaktor").
							doubleValue()
						);
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("LkwAbweichungUnten").isState()) {
								setLkwAbweichungUnten(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttProzent
								.getZustand(daten.getScaledValue("LkwAbweichungUnten").getText()));
							} else {
							setLkwAbweichungUnten(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttProzent
							(daten.
								getUnscaledValue
							("LkwAbweichungUnten").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("LkwAbweichungOben").isState()) {
								setLkwAbweichungOben(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttProzent
								.getZustand(daten.getScaledValue("LkwAbweichungOben").getText()));
							} else {
							setLkwAbweichungOben(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttProzent
							(daten.
								getUnscaledValue
							("LkwAbweichungOben").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("PkwAbweichungUnten").isState()) {
								setPkwAbweichungUnten(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttProzent
								.getZustand(daten.getScaledValue("PkwAbweichungUnten").getText()));
							} else {
							setPkwAbweichungUnten(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttProzent
							(daten.
								getUnscaledValue
							("PkwAbweichungUnten").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("PkwAbweichungOben").isState()) {
								setPkwAbweichungOben(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttProzent
								.getZustand(daten.getScaledValue("PkwAbweichungOben").getText()));
							} else {
							setPkwAbweichungOben(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttProzent
							(daten.
								getUnscaledValue
							("PkwAbweichungOben").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("Ersetzen").isState()) {
								setErsetzen(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
								.getZustand(daten.getScaledValue("Ersetzen").getText()));
							} else {
							setErsetzen(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							(daten.
								getUnscaledValue
							("Ersetzen").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							setEinzelfehlerGrenze(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
							(daten.
								getUnscaledValue
							("EinzelfehlerGrenze").
									longValue
							()));
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon._urlasser = getUrlasser().clone();
							klon.setKfz(getKfz());
							klon.setLkw(getLkw());
							klon.setPkw(getPkw());
							klon.setLv(getLv());
							klon.setSv(getSv());
							klon.setPv(getPv());
							klon.setGv(getGv());
							klon.setHochrechnungsfaktor(getHochrechnungsfaktor());
							klon.setLkwAbweichungUnten(getLkwAbweichungUnten());
							klon.setLkwAbweichungOben(getLkwAbweichungOben());
							klon.setPkwAbweichungUnten(getPkwAbweichungUnten());
							klon.setPkwAbweichungOben(getPkwAbweichungOben());
							klon.setErsetzen(getErsetzen());
							klon.setEinzelfehlerGrenze(getEinzelfehlerGrenze());
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.bastDateiParameter";

	/**
	 * Initialisiert den Parameterdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public PdBastDateiParameter(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 

}
