/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.bastmodell.parameter;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Parameter zur Vermailung von Bastdateien.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class PdBcBastDateiMailParameter extends AbstractParameterDatensatz<PdBcBastDateiMailParameter.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.ParameterDefault,
					Aspekte.ParameterSoll,
					Aspekte.ParameterVorgabe,
					Aspekte.ParameterIst,
				};
			}
	
			/**
			 * Aspekt der zur Versorgung von Defaultwerten für Parameter verwendet werden kann.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterDefault = new Aspekte("Default-Parameter-Aspekt", "asp.parameterDefault");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterSoll = new Aspekte("Soll-Parameter-Aspekt", "asp.parameterSoll");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterVorgabe = new Aspekte("Vorgabe-Parameter-Aspekt", "asp.parameterVorgabe");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterIst = new Aspekte("Ist-Parameter-Aspekt", "asp.parameterIst");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 _urlasser
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				()
				;
				private String
				 _receiveDirectory
				= new String
				()
				;
				private String
				 _receiveSubject
				= new String
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
				 _intervall
				;
				private String
				 _nachReceiver
				= new String
				()
				;
				private String
				 _nachSubject
				= new String
				()
				;
				private String
				 _nachBody
				= new String
				()
				;
				private Feld<String
				> _bastReceiver = new Feld<String
				>(0, true);
				private String
				 _bastSubject
				= new String
				()
				;
				private String
				 _bastBody
				= new String
				()
				;
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@return der Wert von Urlasser.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 getUrlasser() {
				return _urlasser;
			}
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@param _urlasser der neue Wert von Urlasser.
			*/
			public void setUrlasser(de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
			 _urlasser) {
				this._urlasser = _urlasser;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@return der Wert von ReceiveDirectory.
			*/
				public String
				 getReceiveDirectory() {
				return _receiveDirectory;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@param _receiveDirectory der neue Wert von ReceiveDirectory.
			*/
			public void setReceiveDirectory(String
			 _receiveDirectory) {
				if (_receiveDirectory.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._receiveDirectory = _receiveDirectory;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@return der Wert von ReceiveSubject.
			*/
				public String
				 getReceiveSubject() {
				return _receiveSubject;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@param _receiveSubject der neue Wert von ReceiveSubject.
			*/
			public void setReceiveSubject(String
			 _receiveSubject) {
				if (_receiveSubject.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._receiveSubject = _receiveSubject;
			}
		
			/**
			Beliebige ganze Zahl im Bereich -2^63 bis (2^63)-1.
			<p>
			
			</p>
			
			@return der Wert von Intervall.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
				 getIntervall() {
				return _intervall;
			}
		
			/**
			Beliebige ganze Zahl im Bereich -2^63 bis (2^63)-1.
			<p>
			
			</p>
			
			@param _intervall der neue Wert von Intervall.
			*/
			public void setIntervall(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			 _intervall) {
				this._intervall = _intervall;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@return der Wert von NachReceiver.
			*/
				public String
				 getNachReceiver() {
				return _nachReceiver;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@param _nachReceiver der neue Wert von NachReceiver.
			*/
			public void setNachReceiver(String
			 _nachReceiver) {
				if (_nachReceiver.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._nachReceiver = _nachReceiver;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@return der Wert von NachSubject.
			*/
				public String
				 getNachSubject() {
				return _nachSubject;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@param _nachSubject der neue Wert von NachSubject.
			*/
			public void setNachSubject(String
			 _nachSubject) {
				if (_nachSubject.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._nachSubject = _nachSubject;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@return der Wert von NachBody.
			*/
				public String
				 getNachBody() {
				return _nachBody;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@param _nachBody der neue Wert von NachBody.
			*/
			public void setNachBody(String
			 _nachBody) {
				if (_nachBody.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._nachBody = _nachBody;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@return der Wert von BastReceiver.
			*/
				public Feld<String
				> getBastReceiver() {
				return _bastReceiver;
			}
		
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@return der Wert von BastSubject.
			*/
				public String
				 getBastSubject() {
				return _bastSubject;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@param _bastSubject der neue Wert von BastSubject.
			*/
			public void setBastSubject(String
			 _bastSubject) {
				if (_bastSubject.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._bastSubject = _bastSubject;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@return der Wert von BastBody.
			*/
				public String
				 getBastBody() {
				return _bastBody;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@param _bastBody der neue Wert von BastBody.
			*/
			public void setBastBody(String
			 _bastBody) {
				if (_bastBody.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._bastBody = _bastBody;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().bean2Atl(datum.getItem("Urlasser"), factory);
					// ZeichenkettenAttributTyp
					if (getReceiveDirectory() != null) {
						datum.getTextValue("ReceiveDirectory").setText(getReceiveDirectory());
					}
					// ZeichenkettenAttributTyp
					if (getReceiveSubject() != null) {
						datum.getTextValue("ReceiveSubject").setText(getReceiveSubject());
					}
					// GanzzahlAttributTyp
					if (getIntervall() != null) {
		                if (getIntervall().isZustand()) {
		                    datum.getUnscaledValue("Intervall").setText(getIntervall().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Intervall").set(getIntervall().getValue());
		                }
					}
					// ZeichenkettenAttributTyp
					if (getNachReceiver() != null) {
						datum.getTextValue("NachReceiver").setText(getNachReceiver());
					}
					// ZeichenkettenAttributTyp
					if (getNachSubject() != null) {
						datum.getTextValue("NachSubject").setText(getNachSubject());
					}
					// ZeichenkettenAttributTyp
					if (getNachBody() != null) {
						datum.getTextValue("NachBody").setText(getNachBody());
					}
					// ZeichenkettenAttributTyp
					if (getBastReceiver() != null) {
						final Data.TextArray arrayBastReceiver = datum.getTextArray("BastReceiver");
						arrayBastReceiver.setLength(getBastReceiver().size());
						for (int i = 0; i < arrayBastReceiver.getLength(); ++i) {
							arrayBastReceiver.getTextValue(i).setText(getBastReceiver().get(i));
						}
					}
					// ZeichenkettenAttributTyp
					if (getBastSubject() != null) {
						datum.getTextValue("BastSubject").setText(getBastSubject());
					}
					// ZeichenkettenAttributTyp
					if (getBastBody() != null) {
						datum.getTextValue("BastBody").setText(getBastBody());
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().atl2Bean(daten.getItem("Urlasser"), factory);
					// ZeichenkettenAttributTyp
						setReceiveDirectory(daten.getTextValue("ReceiveDirectory").getText());
					// ZeichenkettenAttributTyp
						setReceiveSubject(daten.getTextValue("ReceiveSubject").getText());
					// GanzzahlAttributTyp
							setIntervall(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
							(daten.
								getUnscaledValue
							("Intervall").
									longValue
							()));
					// ZeichenkettenAttributTyp
						setNachReceiver(daten.getTextValue("NachReceiver").getText());
					// ZeichenkettenAttributTyp
						setNachSubject(daten.getTextValue("NachSubject").getText());
					// ZeichenkettenAttributTyp
						setNachBody(daten.getTextValue("NachBody").getText());
					// ZeichenkettenAttributTyp
						final Data.TextArray arrayBastReceiver = daten.getTextArray("BastReceiver");
						for (int i = 0; i < arrayBastReceiver.getLength(); ++i) {
							getBastReceiver().add(arrayBastReceiver.getText(i));
						}
					// ZeichenkettenAttributTyp
						setBastSubject(daten.getTextValue("BastSubject").getText());
					// ZeichenkettenAttributTyp
						setBastBody(daten.getTextValue("BastBody").getText());
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon._urlasser = getUrlasser().clone();
							klon.setReceiveDirectory(getReceiveDirectory());
							klon.setReceiveSubject(getReceiveSubject());
							klon.setIntervall(getIntervall());
							klon.setNachReceiver(getNachReceiver());
							klon.setNachSubject(getNachSubject());
							klon.setNachBody(getNachBody());
						klon._bastReceiver = getBastReceiver().clone();
							klon.setBastSubject(getBastSubject());
							klon.setBastBody(getBastBody());
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.bcBastDateiMailParameter";

	/**
	 * Initialisiert den Parameterdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public PdBcBastDateiMailParameter(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 

}
