/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.bitctrlallgemein.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Definiert eine PBM-Datei.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 2
 */
public class AtlPortableBitMap implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private de.bsvrz.sys.funclib.bitctrl.modell.bitctrlallgemein.attribute.AtlAusmasse
			 _ausmasse
			= new de.bsvrz.sys.funclib.bitctrl.modell.bitctrlallgemein.attribute.AtlAusmasse
			()
			;
			private Feld<String
			> _maske = new Feld<String
			>(0, true);
	
		/**
		Beschreibt die Ausmaße eines Objekts mit Breite und Höhe.
		<p>
		
		</p>
		
		@return der Wert von Ausmasse.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.bitctrlallgemein.attribute.AtlAusmasse
			 getAusmasse() {
			return _ausmasse;
		}
	
		/**
		Beschreibt die Ausmaße eines Objekts mit Breite und Höhe.
		<p>
		
		</p>
		
		@param _ausmasse der neue Wert von Ausmasse.
		*/
		public void setAusmasse(de.bsvrz.sys.funclib.bitctrl.modell.bitctrlallgemein.attribute.AtlAusmasse
		 _ausmasse) {
			this._ausmasse = _ausmasse;
		}
	
		/**
		Definiert die Bitmaske des Bildes als Folge von 0 und 1.
		<p>
		Die Definition darf keine anderen Zeichen als 0 und 1
							enthalten. Eventuell enthaltene Leerzeichen
							werden ignoriert. Jedes
							Feldelement sollte genau einer Zeile der Maske entsprechen, so
							lassen sich Daten mit
							generischen Tools wie dem GTM besser lesen.
							Siehe auch http:&#47;&#47;netpbm.sourceforge.net&#47;doc&#47;pbm.html
		</p>
		
		@return der Wert von Maske.
		*/
			public Feld<String
			> getMaske() {
			return _maske;
		}
	
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// AttributListenDefinition
					getAusmasse().bean2Atl(datum.getItem("Ausmaße"), factory);
				// ZeichenkettenAttributTyp
				if (getMaske() != null) {
					final Data.TextArray arrayMaske = datum.getTextArray("Maske");
					arrayMaske.setLength(getMaske().size());
					for (int i = 0; i < arrayMaske.getLength(); ++i) {
						arrayMaske.getTextValue(i).setText(getMaske().get(i));
					}
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// AttributListenDefinition
					getAusmasse().atl2Bean(daten.getItem("Ausmaße"), factory);
				// ZeichenkettenAttributTyp
					final Data.TextArray arrayMaske = daten.getTextArray("Maske");
					for (int i = 0; i < arrayMaske.getLength(); ++i) {
						getMaske().add(arrayMaske.getText(i));
					}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlPortableBitMap clone() {
		AtlPortableBitMap klon = new AtlPortableBitMap();
		
						klon._ausmasse = getAusmasse().clone();
					klon._maske = getMaske().clone();
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
