/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.bitctrlappmanagement.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Datenstruktur, die einen Eintrag einer
					Managed Application
					innerhalb der aktuellen Liste des Application
					Manager beschreibt.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlManagedApplicationAktuelleListe implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private 	de.bsvrz.sys.funclib.bitctrl.modell.bitctrlappmanagement.objekte.BcManagedApplication
			 _anwendung
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.bitctrlappmanagement.attribute.AttBcManagedApplicationKommandoTyp
			 _kommandoTyp
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.bitctrlappmanagement.attribute.AttBcManagedApplicationAntwortTyp
			 _antwortTyp
			;
			private String
			 _nachricht
			= new String
			()
			;
			private 	Zeitstempel
			 _zeit
			;
	
		/**
		Referenz auf eine managed Application.
		<p>
		
		</p>
		
		@return der Wert von Anwendung.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.bitctrlappmanagement.objekte.BcManagedApplication
			 getAnwendung() {
			return _anwendung;
		}
	
		/**
		Referenz auf eine managed Application.
		<p>
		
		</p>
		
		@param _anwendung der neue Wert von Anwendung.
		*/
		public void setAnwendung(	de.bsvrz.sys.funclib.bitctrl.modell.bitctrlappmanagement.objekte.BcManagedApplication
		 _anwendung) {
			this._anwendung = _anwendung;
		}
	
		/**
		Typ eines Kommandos an eine managed Application.
		<p>
		
		</p>
		
		@return der Wert von KommandoTyp.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.bitctrlappmanagement.attribute.AttBcManagedApplicationKommandoTyp
			 getKommandoTyp() {
			return _kommandoTyp;
		}
	
		/**
		Typ eines Kommandos an eine managed Application.
		<p>
		
		</p>
		
		@param _kommandoTyp der neue Wert von KommandoTyp.
		*/
		public void setKommandoTyp(de.bsvrz.sys.funclib.bitctrl.modell.bitctrlappmanagement.attribute.AttBcManagedApplicationKommandoTyp
		 _kommandoTyp) {
			this._kommandoTyp = _kommandoTyp;
		}
	
		/**
		Typ einer Antwort von einer managed Application.
		<p>
		
		</p>
		
		@return der Wert von AntwortTyp.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.bitctrlappmanagement.attribute.AttBcManagedApplicationAntwortTyp
			 getAntwortTyp() {
			return _antwortTyp;
		}
	
		/**
		Typ einer Antwort von einer managed Application.
		<p>
		
		</p>
		
		@param _antwortTyp der neue Wert von AntwortTyp.
		*/
		public void setAntwortTyp(de.bsvrz.sys.funclib.bitctrl.modell.bitctrlappmanagement.attribute.AttBcManagedApplicationAntwortTyp
		 _antwortTyp) {
			this._antwortTyp = _antwortTyp;
		}
	
		/**
		Attribut zur Speicherung eines Textes.
		<p>
		
		</p>
		
		@return der Wert von Nachricht.
		*/
			public String
			 getNachricht() {
			return _nachricht;
		}
	
		/**
		Attribut zur Speicherung eines Textes.
		<p>
		
		</p>
		
		@param _nachricht der neue Wert von Nachricht.
		*/
		public void setNachricht(String
		 _nachricht) {
			if (_nachricht.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._nachricht = _nachricht;
		}
	
		/**
		Zeit im aktuellen Kontext (Simulationszeit oder Systemzeit).
		<p>
		
		</p>
		
		@return der Wert von Zeit.
		*/
			public 	Zeitstempel
			 getZeit() {
			return _zeit;
		}
	
		/**
		Zeit im aktuellen Kontext (Simulationszeit oder Systemzeit).
		<p>
		
		</p>
		
		@param _zeit der neue Wert von Zeit.
		*/
		public void setZeit(	Zeitstempel
		 _zeit) {
			this._zeit = _zeit;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Object soAnwendung = getAnwendung();
					final SystemObject tmpAnwendung;
						if (soAnwendung instanceof SystemObject) {
							tmpAnwendung = (SystemObject)soAnwendung;
						} else if(soAnwendung instanceof SystemObjekt){
							tmpAnwendung = ((SystemObjekt)soAnwendung).getSystemObject();
						} else{
							tmpAnwendung = null;
						}
					datum.getReferenceValue("Anwendung").setSystemObject(tmpAnwendung);
				// GanzzahlAttributTyp
				if (getKommandoTyp() != null) {
	                if (getKommandoTyp().isZustand()) {
	                    datum.getUnscaledValue("KommandoTyp").setText(getKommandoTyp().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("KommandoTyp").set(getKommandoTyp().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getAntwortTyp() != null) {
	                if (getAntwortTyp().isZustand()) {
	                    datum.getUnscaledValue("AntwortTyp").setText(getAntwortTyp().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("AntwortTyp").set(getAntwortTyp().getValue());
	                }
				}
				// ZeichenkettenAttributTyp
				if (getNachricht() != null) {
					datum.getTextValue("Nachricht").setText(getNachricht());
				}
				// ZeitstempelAttributTyp
					datum.getTimeValue("Zeit").setMillis(getZeit().getTime());
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final long idAnwendung = daten.getReferenceValue("Anwendung").getId();
					final SystemObjekt tmpAnwendung;
					if (idAnwendung == 0) {
						tmpAnwendung = null;
					} else {
						final SystemObject soAnwendung = factory.getDav().getDataModel().getObject(idAnwendung);
						if (soAnwendung == null) {
								tmpAnwendung = new de.bsvrz.sys.funclib.bitctrl.modell.bitctrlappmanagement.objekte.impl.BcManagedApplicationUngueltig(idAnwendung);
						} else {
							tmpAnwendung = factory.getModellobjekt(soAnwendung);
						}
					}
					setAnwendung((	de.bsvrz.sys.funclib.bitctrl.modell.bitctrlappmanagement.objekte.BcManagedApplication
					) tmpAnwendung);
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("KommandoTyp").isState()) {
							setKommandoTyp(de.bsvrz.sys.funclib.bitctrl.modell.bitctrlappmanagement.attribute.AttBcManagedApplicationKommandoTyp
							.getZustand(daten.getScaledValue("KommandoTyp").getText()));
						} else {
						setKommandoTyp(new de.bsvrz.sys.funclib.bitctrl.modell.bitctrlappmanagement.attribute.AttBcManagedApplicationKommandoTyp
						(daten.
							getUnscaledValue
						("KommandoTyp").
								byteValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("AntwortTyp").isState()) {
							setAntwortTyp(de.bsvrz.sys.funclib.bitctrl.modell.bitctrlappmanagement.attribute.AttBcManagedApplicationAntwortTyp
							.getZustand(daten.getScaledValue("AntwortTyp").getText()));
						} else {
						setAntwortTyp(new de.bsvrz.sys.funclib.bitctrl.modell.bitctrlappmanagement.attribute.AttBcManagedApplicationAntwortTyp
						(daten.
							getUnscaledValue
						("AntwortTyp").
								byteValue
						()));
						}
				// ZeichenkettenAttributTyp
					setNachricht(daten.getTextValue("Nachricht").getText());
				// ZeitstempelAttributTyp
					setZeit(new
						Zeitstempel
						(daten.getTimeValue("Zeit").getMillis()));
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlManagedApplicationAktuelleListe clone() {
		AtlManagedApplicationAktuelleListe klon = new AtlManagedApplicationAktuelleListe();
		
						klon.setAnwendung(getAnwendung());
						klon.setKommandoTyp(getKommandoTyp());
						klon.setAntwortTyp(getAntwortTyp());
						klon.setNachricht(getNachricht());
						klon.setZeit(getZeit());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
