/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.bitctrlappmanagement.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Datenstruktur, die einen Eintrag einer
					Managed Application
					innerhalb des Application Manager beschreibt.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlManagedApplicationTabellenEintrag implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private 	de.bsvrz.sys.funclib.bitctrl.modell.bitctrlappmanagement.objekte.BcManagedApplication
			 _anwendung
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _ueberwachen
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.bitctrlappmanagement.attribute.AtlManagedApplicationFehlerReaktion
			 _reaktionen
			= new de.bsvrz.sys.funclib.bitctrl.modell.bitctrlappmanagement.attribute.AtlManagedApplicationFehlerReaktion
			()
			;
	
		/**
		Referenz auf eine managed Application.
		<p>
		
		</p>
		
		@return der Wert von Anwendung.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.bitctrlappmanagement.objekte.BcManagedApplication
			 getAnwendung() {
			return _anwendung;
		}
	
		/**
		Referenz auf eine managed Application.
		<p>
		
		</p>
		
		@param _anwendung der neue Wert von Anwendung.
		*/
		public void setAnwendung(	de.bsvrz.sys.funclib.bitctrl.modell.bitctrlappmanagement.objekte.BcManagedApplication
		 _anwendung) {
			this._anwendung = _anwendung;
		}
	
		/**
		Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
		<p>
		
		</p>
		
		@return der Wert von Ueberwachen.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 getUeberwachen() {
			return _ueberwachen;
		}
	
		/**
		Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
		<p>
		
		</p>
		
		@param _ueberwachen der neue Wert von Ueberwachen.
		*/
		public void setUeberwachen(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
		 _ueberwachen) {
			this._ueberwachen = _ueberwachen;
		}
	
		/**
		Datenstruktur, die die allgemeine Reaktion
							des Application
							Managers auf einen Fehler in einer überwachten
							Anwendung beschreibt.
		<p>
		
		</p>
		
		@return der Wert von Reaktionen.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.bitctrlappmanagement.attribute.AtlManagedApplicationFehlerReaktion
			 getReaktionen() {
			return _reaktionen;
		}
	
		/**
		Datenstruktur, die die allgemeine Reaktion
							des Application
							Managers auf einen Fehler in einer überwachten
							Anwendung beschreibt.
		<p>
		
		</p>
		
		@param _reaktionen der neue Wert von Reaktionen.
		*/
		public void setReaktionen(de.bsvrz.sys.funclib.bitctrl.modell.bitctrlappmanagement.attribute.AtlManagedApplicationFehlerReaktion
		 _reaktionen) {
			this._reaktionen = _reaktionen;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Object soAnwendung = getAnwendung();
					final SystemObject tmpAnwendung;
						if (soAnwendung instanceof SystemObject) {
							tmpAnwendung = (SystemObject)soAnwendung;
						} else if(soAnwendung instanceof SystemObjekt){
							tmpAnwendung = ((SystemObjekt)soAnwendung).getSystemObject();
						} else{
							tmpAnwendung = null;
						}
					datum.getReferenceValue("Anwendung").setSystemObject(tmpAnwendung);
				// GanzzahlAttributTyp
				if (getUeberwachen() != null) {
	                if (getUeberwachen().isZustand()) {
	                    datum.getUnscaledValue("Überwachen").setText(getUeberwachen().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Überwachen").set(getUeberwachen().getValue());
	                }
				}
				// AttributListenDefinition
					getReaktionen().bean2Atl(datum.getItem("Reaktionen"), factory);
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final long idAnwendung = daten.getReferenceValue("Anwendung").getId();
					final SystemObjekt tmpAnwendung;
					if (idAnwendung == 0) {
						tmpAnwendung = null;
					} else {
						final SystemObject soAnwendung = factory.getDav().getDataModel().getObject(idAnwendung);
						if (soAnwendung == null) {
								tmpAnwendung = new de.bsvrz.sys.funclib.bitctrl.modell.bitctrlappmanagement.objekte.impl.BcManagedApplicationUngueltig(idAnwendung);
						} else {
							tmpAnwendung = factory.getModellobjekt(soAnwendung);
						}
					}
					setAnwendung((	de.bsvrz.sys.funclib.bitctrl.modell.bitctrlappmanagement.objekte.BcManagedApplication
					) tmpAnwendung);
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Überwachen").isState()) {
							setUeberwachen(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							.getZustand(daten.getScaledValue("Überwachen").getText()));
						} else {
						setUeberwachen(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
						(daten.
							getUnscaledValue
						("Überwachen").
								byteValue
						()));
						}
				// AttributListenDefinition
					getReaktionen().atl2Bean(daten.getItem("Reaktionen"), factory);
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlManagedApplicationTabellenEintrag clone() {
		AtlManagedApplicationTabellenEintrag klon = new AtlManagedApplicationTabellenEintrag();
		
						klon.setAnwendung(getAnwendung());
						klon.setUeberwachen(getUeberwachen());
						klon._reaktionen = getReaktionen().clone();
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
