/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.bitctrlbasic.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Abweichungstoleranzen in Prozent.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlBcProzentBereich implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttProzent
			 _oben
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttProzent
			 _unten
			;
	
		/**
		Abweichungstoleranz nach oben.
		<p>
		
		</p>
		
		@return der Wert von Oben.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttProzent
			 getOben() {
			return _oben;
		}
	
		/**
		Abweichungstoleranz nach oben.
		<p>
		
		</p>
		
		@param _oben der neue Wert von Oben.
		*/
		public void setOben(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttProzent
		 _oben) {
			this._oben = _oben;
		}
	
		/**
		Abweichungstoleranz nach oben.
		<p>
		
		</p>
		
		@return der Wert von Unten.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttProzent
			 getUnten() {
			return _unten;
		}
	
		/**
		Abweichungstoleranz nach oben.
		<p>
		
		</p>
		
		@param _unten der neue Wert von Unten.
		*/
		public void setUnten(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttProzent
		 _unten) {
			this._unten = _unten;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// GanzzahlAttributTyp
				if (getOben() != null) {
	                if (getOben().isZustand()) {
	                    datum.getUnscaledValue("Oben").setText(getOben().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Oben").set(getOben().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getUnten() != null) {
	                if (getUnten().isZustand()) {
	                    datum.getUnscaledValue("Unten").setText(getUnten().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Unten").set(getUnten().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Oben").isState()) {
							setOben(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttProzent
							.getZustand(daten.getScaledValue("Oben").getText()));
						} else {
						setOben(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttProzent
						(daten.
							getUnscaledValue
						("Oben").
								byteValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Unten").isState()) {
							setUnten(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttProzent
							.getZustand(daten.getScaledValue("Unten").getText()));
						} else {
						setUnten(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttProzent
						(daten.
							getUnscaledValue
						("Unten").
								byteValue
						()));
						}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlBcProzentBereich clone() {
		AtlBcProzentBereich klon = new AtlBcProzentBereich();
		
						klon.setOben(getOben());
						klon.setUnten(getUnten());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
