/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.bitctrlbasic.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Beschreibt einen individuellen (atomaren) Datenpunkt an
					einem Datensatz.
<p>
Der Datensatz wird über
					Typ&#47;Objekt&#47;Attributgruppe&#47;Aspekt wie gewohnt identifiziert. Das
					individuelle Attribut innerhalb des Datensatzes wird über eine
					Namenskonvention gefunden, indem der Attributname (also das
					Argument zu Data.getItem()) als Text definiert wird. Um ineinander
					verschachtelte Attributlisten rekursiv zu durchsuchen, wird als
					Trennzeichen der Punkt (.) vereinbart. Felder werden über ihren
					Index angesprochen, z.B.
					ParameterSatz.0.Datenspezifikation.1.Objekte.7
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 3
 */
public class AtlDatenpunkt implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private 	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Typ
			 _typ
			;
			private 	Object
			 _objekt
			;
			private 	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Attributgruppe
			 _attributgruppe
			;
			private 	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Aspekt
			 _aspekt
			;
			private String
			 _pfad
			= new String
			()
			;
	
		/**
		Attribut zur Referenzierung von Objekttypen.
		<p>
		
		</p>
		
		@return der Wert von Typ.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Typ
			 getTyp() {
			return _typ;
		}
	
		/**
		Attribut zur Referenzierung von Objekttypen.
		<p>
		
		</p>
		
		@param _typ der neue Wert von Typ.
		*/
		public void setTyp(	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Typ
		 _typ) {
			this._typ = _typ;
		}
	
		/**
		Attribut zur Referenzierung von beliebigen Objekten.
		<p>
		
		</p>
		
		@return der Wert von Objekt.
		*/
			public 	Object
			 getObjekt() {
			return _objekt;
		}
	
		/**
		Attribut zur Referenzierung von beliebigen Objekten.
		<p>
		
		</p>
		
		@param _objekt der neue Wert von Objekt.
		*/
		public void setObjekt(	Object
		 _objekt) {
			this._objekt = _objekt;
		}
	
		/**
		Attribut zur Referenzierung des Objekttyps: typ.attributgruppe.
		<p>
		
		</p>
		
		@return der Wert von Attributgruppe.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Attributgruppe
			 getAttributgruppe() {
			return _attributgruppe;
		}
	
		/**
		Attribut zur Referenzierung des Objekttyps: typ.attributgruppe.
		<p>
		
		</p>
		
		@param _attributgruppe der neue Wert von Attributgruppe.
		*/
		public void setAttributgruppe(	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Attributgruppe
		 _attributgruppe) {
			this._attributgruppe = _attributgruppe;
		}
	
		/**
		Attribut zur Referenzierung von Aspekten.
		<p>
		
		</p>
		
		@return der Wert von Aspekt.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Aspekt
			 getAspekt() {
			return _aspekt;
		}
	
		/**
		Attribut zur Referenzierung von Aspekten.
		<p>
		
		</p>
		
		@param _aspekt der neue Wert von Aspekt.
		*/
		public void setAspekt(	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Aspekt
		 _aspekt) {
			this._aspekt = _aspekt;
		}
	
		/**
		Attribut zur Speicherung eines Textes.
		<p>
		
		</p>
		
		@return der Wert von Pfad.
		*/
			public String
			 getPfad() {
			return _pfad;
		}
	
		/**
		Attribut zur Speicherung eines Textes.
		<p>
		
		</p>
		
		@param _pfad der neue Wert von Pfad.
		*/
		public void setPfad(String
		 _pfad) {
			if (_pfad.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._pfad = _pfad;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Object soTyp = getTyp();
					final SystemObject tmpTyp;
						if (soTyp instanceof SystemObject) {
							tmpTyp = (SystemObject)soTyp;
						} else if(soTyp instanceof SystemObjekt){
							tmpTyp = ((SystemObjekt)soTyp).getSystemObject();
						} else{
							tmpTyp = null;
						}
					datum.getReferenceValue("Typ").setSystemObject(tmpTyp);
				// ObjektReferenzAttributTyp
					final Object soObjekt = getObjekt();
					final SystemObject tmpObjekt;
						if (soObjekt instanceof SystemObject) {
							tmpObjekt = (SystemObject)soObjekt;
						} else if(soObjekt instanceof SystemObjekt){
							tmpObjekt = ((SystemObjekt)soObjekt).getSystemObject();
						} else{
							tmpObjekt = null;
						}
					datum.getReferenceValue("Objekt").setSystemObject(tmpObjekt);
				// ObjektReferenzAttributTyp
					final Object soAttributgruppe = getAttributgruppe();
					final SystemObject tmpAttributgruppe;
						if (soAttributgruppe instanceof SystemObject) {
							tmpAttributgruppe = (SystemObject)soAttributgruppe;
						} else if(soAttributgruppe instanceof SystemObjekt){
							tmpAttributgruppe = ((SystemObjekt)soAttributgruppe).getSystemObject();
						} else{
							tmpAttributgruppe = null;
						}
					datum.getReferenceValue("Attributgruppe").setSystemObject(tmpAttributgruppe);
				// ObjektReferenzAttributTyp
					final Object soAspekt = getAspekt();
					final SystemObject tmpAspekt;
						if (soAspekt instanceof SystemObject) {
							tmpAspekt = (SystemObject)soAspekt;
						} else if(soAspekt instanceof SystemObjekt){
							tmpAspekt = ((SystemObjekt)soAspekt).getSystemObject();
						} else{
							tmpAspekt = null;
						}
					datum.getReferenceValue("Aspekt").setSystemObject(tmpAspekt);
				// ZeichenkettenAttributTyp
				if (getPfad() != null) {
					datum.getTextValue("Pfad").setText(getPfad());
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final long idTyp = daten.getReferenceValue("Typ").getId();
					final SystemObjekt tmpTyp;
					if (idTyp == 0) {
						tmpTyp = null;
					} else {
						final SystemObject soTyp = factory.getDav().getDataModel().getObject(idTyp);
						if (soTyp == null) {
								tmpTyp = new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.TypUngueltig(idTyp);
						} else {
							tmpTyp = factory.getModellobjekt(soTyp);
						}
					}
					setTyp((	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Typ
					) tmpTyp);
				// ObjektReferenzAttributTyp
					final long idObjekt = daten.getReferenceValue("Objekt").getId();
					final SystemObjekt tmpObjekt;
					if (idObjekt == 0) {
						tmpObjekt = null;
					} else {
						final SystemObject soObjekt = factory.getDav().getDataModel().getObject(idObjekt);
						if (soObjekt == null) {
								tmpObjekt = new BaseUngueltigesSystemObjekt(idObjekt);
						} else {
							tmpObjekt = factory.getModellobjekt(soObjekt);
						}
					}
					setObjekt((	Object
					) tmpObjekt);
				// ObjektReferenzAttributTyp
					final long idAttributgruppe = daten.getReferenceValue("Attributgruppe").getId();
					final SystemObjekt tmpAttributgruppe;
					if (idAttributgruppe == 0) {
						tmpAttributgruppe = null;
					} else {
						final SystemObject soAttributgruppe = factory.getDav().getDataModel().getObject(idAttributgruppe);
						if (soAttributgruppe == null) {
								tmpAttributgruppe = new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AttributgruppeUngueltig(idAttributgruppe);
						} else {
							tmpAttributgruppe = factory.getModellobjekt(soAttributgruppe);
						}
					}
					setAttributgruppe((	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Attributgruppe
					) tmpAttributgruppe);
				// ObjektReferenzAttributTyp
					final long idAspekt = daten.getReferenceValue("Aspekt").getId();
					final SystemObjekt tmpAspekt;
					if (idAspekt == 0) {
						tmpAspekt = null;
					} else {
						final SystemObject soAspekt = factory.getDav().getDataModel().getObject(idAspekt);
						if (soAspekt == null) {
								tmpAspekt = new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektUngueltig(idAspekt);
						} else {
							tmpAspekt = factory.getModellobjekt(soAspekt);
						}
					}
					setAspekt((	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Aspekt
					) tmpAspekt);
				// ZeichenkettenAttributTyp
					setPfad(daten.getTextValue("Pfad").getText());
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlDatenpunkt clone() {
		AtlDatenpunkt klon = new AtlDatenpunkt();
		
						klon.setTyp(getTyp());
						klon.setObjekt(getObjekt());
						klon.setAttributgruppe(getAttributgruppe());
						klon.setAspekt(getAspekt());
						klon.setPfad(getPfad());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
