/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.bitctrlbasic.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Doppel-Summenliste von Datenpunkten. Sie definiert zwei
					Listen von Datenpunkten, deren aktuelle Werte jeweils addiert
					werden. Die Summe der Negativliste wird dann von der Summe der
					Positivliste abgezogen und liefert das aktuelle Ergebnis.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 3
 */
public class AtlPositivNegativListe implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.bitctrlbasic.attribute.AtlDatenpunkt
			> _positivliste = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.bitctrlbasic.attribute.AtlDatenpunkt
			>(0, true);
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.bitctrlbasic.attribute.AtlDatenpunkt
			> _negativliste = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.bitctrlbasic.attribute.AtlDatenpunkt
			>(0, true);
	
		/**
		Beschreibt einen individuellen (atomaren) Datenpunkt an
							einem Datensatz.
		<p>
		Der Datensatz wird über
							Typ&#47;Objekt&#47;Attributgruppe&#47;Aspekt wie gewohnt identifiziert. Das
							individuelle Attribut innerhalb des Datensatzes wird über eine
							Namenskonvention gefunden, indem der Attributname (also das
							Argument zu Data.getItem()) als Text definiert wird. Um ineinander
							verschachtelte Attributlisten rekursiv zu durchsuchen, wird als
							Trennzeichen der Punkt (.) vereinbart. Felder werden über ihren
							Index angesprochen, z.B.
							ParameterSatz.0.Datenspezifikation.1.Objekte.7
		</p>
		
		@return der Wert von Positivliste.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.bitctrlbasic.attribute.AtlDatenpunkt
			> getPositivliste() {
			return _positivliste;
		}
	
	
		/**
		Beschreibt einen individuellen (atomaren) Datenpunkt an
							einem Datensatz.
		<p>
		Der Datensatz wird über
							Typ&#47;Objekt&#47;Attributgruppe&#47;Aspekt wie gewohnt identifiziert. Das
							individuelle Attribut innerhalb des Datensatzes wird über eine
							Namenskonvention gefunden, indem der Attributname (also das
							Argument zu Data.getItem()) als Text definiert wird. Um ineinander
							verschachtelte Attributlisten rekursiv zu durchsuchen, wird als
							Trennzeichen der Punkt (.) vereinbart. Felder werden über ihren
							Index angesprochen, z.B.
							ParameterSatz.0.Datenspezifikation.1.Objekte.7
		</p>
		
		@return der Wert von Negativliste.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.bitctrlbasic.attribute.AtlDatenpunkt
			> getNegativliste() {
			return _negativliste;
		}
	
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// AttributListenDefinition
					final Data.Array arrayPositivliste = datum.getArray("Positivliste");
					arrayPositivliste.setLength(getPositivliste().size());
					for (int i = 0; i < arrayPositivliste.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.bitctrlbasic.attribute.AtlDatenpunkt
						 atl = getPositivliste().get(i);
						atl.bean2Atl(arrayPositivliste.getItem(i), factory);
	
					}
				// AttributListenDefinition
					final Data.Array arrayNegativliste = datum.getArray("Negativliste");
					arrayNegativliste.setLength(getNegativliste().size());
					for (int i = 0; i < arrayNegativliste.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.bitctrlbasic.attribute.AtlDatenpunkt
						 atl = getNegativliste().get(i);
						atl.bean2Atl(arrayNegativliste.getItem(i), factory);
	
					}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// AttributListenDefinition
					final Data.Array arrayPositivliste = daten.getArray("Positivliste");
					for (int i = 0; i < arrayPositivliste.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.bitctrlbasic.attribute.AtlDatenpunkt
						 atl = new de.bsvrz.sys.funclib.bitctrl.modell.bitctrlbasic.attribute.AtlDatenpunkt
						 ();
						atl.atl2Bean(arrayPositivliste.getItem(i), factory);
						getPositivliste().add(atl);
					}
				// AttributListenDefinition
					final Data.Array arrayNegativliste = daten.getArray("Negativliste");
					for (int i = 0; i < arrayNegativliste.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.bitctrlbasic.attribute.AtlDatenpunkt
						 atl = new de.bsvrz.sys.funclib.bitctrl.modell.bitctrlbasic.attribute.AtlDatenpunkt
						 ();
						atl.atl2Bean(arrayNegativliste.getItem(i), factory);
						getNegativliste().add(atl);
					}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlPositivNegativListe clone() {
		AtlPositivNegativListe klon = new AtlPositivNegativListe();
		
					klon._positivliste = getPositivliste().clone();
					klon._negativliste = getNegativliste().clone();
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
