/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.bitctrlbasic.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Attributtyp zur Definition, wie aus einer Menge von Werten
					gleichen Typs einer ausgewählt werden kann. Anwendbar für
					numerische Werte und für alle Werte, für die sich die bekannten
					Operatoren '&lt;=', '&gt;=', '=' usw. sinnvoll definieren lassen.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 2
 */
public class AttAuswahlKriterium extends Zahl<		Byte
> {
	
	private static final long serialVersionUID = 1L;
	
	
	/**
	Zur Auswahl werden weitere, nicht generisch
								beschreibbare Bedingungen verwendet.
	<p>
	
	</p>
	*/
	public static final AttAuswahlKriterium ZUSTAND_0_SPEZIAL = new AttAuswahlKriterium("Spezial", 		Byte
	.valueOf("0"));

	/**
	Der kleinste Wert (Operator '&lt;=') wird ausgewählt.
	<p>
	
	</p>
	*/
	public static final AttAuswahlKriterium ZUSTAND_1_KLEINSTER = new AttAuswahlKriterium("Kleinster", 		Byte
	.valueOf("1"));

	/**
	Der größte Wert (Operator '&gt;=') wird ausgewählt.
	<p>
	
	</p>
	*/
	public static final AttAuswahlKriterium ZUSTAND_2_GROESSTER = new AttAuswahlKriterium("Größter", 		Byte
	.valueOf("2"));

	/**
	Der Mittelwert wird ausgewählt.
	<p>
	
	</p>
	*/
	public static final AttAuswahlKriterium ZUSTAND_3_MITTELWERT = new AttAuswahlKriterium("Mittelwert", 		Byte
	.valueOf("3"));

	/**
	Der erste Wert aus einer Liste wird ausgewählt.
	<p>
	
	</p>
	*/
	public static final AttAuswahlKriterium ZUSTAND_4_ERSTER = new AttAuswahlKriterium("Erster", 		Byte
	.valueOf("4"));

	/**
	Der letzte Wert aus einer Liste wird ausgewählt.
	<p>
	
	</p>
	*/
	public static final AttAuswahlKriterium ZUSTAND_5_LETZTER = new AttAuswahlKriterium("Letzter", 		Byte
	.valueOf("5"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttAuswahlKriterium getZustand(final 		Byte
	 value) {
		for (AttAuswahlKriterium e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttAuswahlKriterium getZustand(final String value) {
		for (AttAuswahlKriterium e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttAuswahlKriterium> getZustaende() {
		List<AttAuswahlKriterium> list = new ArrayList<AttAuswahlKriterium>();
		list.add(ZUSTAND_0_SPEZIAL);
		list.add(ZUSTAND_1_KLEINSTER);
		list.add(ZUSTAND_2_GROESSTER);
		list.add(ZUSTAND_3_MITTELWERT);
		list.add(ZUSTAND_4_ERSTER);
		list.add(ZUSTAND_5_LETZTER);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut AuswahlKriterium.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttAuswahlKriterium(final 		Byte
	 value) {
		super(value);
	}
	
	private AttAuswahlKriterium(final String zustand, final 		Byte
	 value) {
		super(zustand, value);
	}
	
}
