/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.bitctrlbmv.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Definition für die Attribute der Anzeige eines Meldungstyps.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlBcBetriebsmeldungDarstellung implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AttMeldungsKlasse
			 _klasse
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			 _vordergrundfarbe
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			 _hintergrundfarbe
			;
			private String
			 _schriftart
			= new String
			()
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _fettdruck
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _kursivdruck
			;
	
		/**
		Betriebsmeldungsklasse.
		<p>
		
		</p>
		
		@return der Wert von Klasse.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AttMeldungsKlasse
			 getKlasse() {
			return _klasse;
		}
	
		/**
		Betriebsmeldungsklasse.
		<p>
		
		</p>
		
		@param _klasse der neue Wert von Klasse.
		*/
		public void setKlasse(de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AttMeldungsKlasse
		 _klasse) {
			this._klasse = _klasse;
		}
	
		/**
		Zeichenfarbe.
		<p>
		
		</p>
		
		@return der Wert von Vordergrundfarbe.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			 getVordergrundfarbe() {
			return _vordergrundfarbe;
		}
	
		/**
		Zeichenfarbe.
		<p>
		
		</p>
		
		@param _vordergrundfarbe der neue Wert von Vordergrundfarbe.
		*/
		public void setVordergrundfarbe(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
		 _vordergrundfarbe) {
			this._vordergrundfarbe = _vordergrundfarbe;
		}
	
		/**
		Hintergrundfarbe.
		<p>
		
		</p>
		
		@return der Wert von Hintergrundfarbe.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			 getHintergrundfarbe() {
			return _hintergrundfarbe;
		}
	
		/**
		Hintergrundfarbe.
		<p>
		
		</p>
		
		@param _hintergrundfarbe der neue Wert von Hintergrundfarbe.
		*/
		public void setHintergrundfarbe(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
		 _hintergrundfarbe) {
			this._hintergrundfarbe = _hintergrundfarbe;
		}
	
		/**
		Schriftart.
		<p>
		
		</p>
		
		@return der Wert von Schriftart.
		*/
			public String
			 getSchriftart() {
			return _schriftart;
		}
	
		/**
		Schriftart.
		<p>
		
		</p>
		
		@param _schriftart der neue Wert von Schriftart.
		*/
		public void setSchriftart(String
		 _schriftart) {
			if (_schriftart.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._schriftart = _schriftart;
		}
	
		/**
		Schriftauszeichnung.
		<p>
		
		</p>
		
		@return der Wert von Fettdruck.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 getFettdruck() {
			return _fettdruck;
		}
	
		/**
		Schriftauszeichnung.
		<p>
		
		</p>
		
		@param _fettdruck der neue Wert von Fettdruck.
		*/
		public void setFettdruck(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
		 _fettdruck) {
			this._fettdruck = _fettdruck;
		}
	
		/**
		Schriftauszeichnung.
		<p>
		
		</p>
		
		@return der Wert von Kursivdruck.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 getKursivdruck() {
			return _kursivdruck;
		}
	
		/**
		Schriftauszeichnung.
		<p>
		
		</p>
		
		@param _kursivdruck der neue Wert von Kursivdruck.
		*/
		public void setKursivdruck(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
		 _kursivdruck) {
			this._kursivdruck = _kursivdruck;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// GanzzahlAttributTyp
				if (getKlasse() != null) {
	                if (getKlasse().isZustand()) {
	                    datum.getUnscaledValue("Klasse").setText(getKlasse().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Klasse").set(getKlasse().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getVordergrundfarbe() != null) {
	                if (getVordergrundfarbe().isZustand()) {
	                    datum.getUnscaledValue("Vordergrundfarbe").setText(getVordergrundfarbe().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Vordergrundfarbe").set(getVordergrundfarbe().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getHintergrundfarbe() != null) {
	                if (getHintergrundfarbe().isZustand()) {
	                    datum.getUnscaledValue("Hintergrundfarbe").setText(getHintergrundfarbe().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Hintergrundfarbe").set(getHintergrundfarbe().getValue());
	                }
				}
				// ZeichenkettenAttributTyp
				if (getSchriftart() != null) {
					datum.getTextValue("Schriftart").setText(getSchriftart());
				}
				// GanzzahlAttributTyp
				if (getFettdruck() != null) {
	                if (getFettdruck().isZustand()) {
	                    datum.getUnscaledValue("Fettdruck").setText(getFettdruck().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Fettdruck").set(getFettdruck().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getKursivdruck() != null) {
	                if (getKursivdruck().isZustand()) {
	                    datum.getUnscaledValue("Kursivdruck").setText(getKursivdruck().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Kursivdruck").set(getKursivdruck().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Klasse").isState()) {
							setKlasse(de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AttMeldungsKlasse
							.getZustand(daten.getScaledValue("Klasse").getText()));
						} else {
						setKlasse(new de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AttMeldungsKlasse
						(daten.
							getUnscaledValue
						("Klasse").
								byteValue
						()));
						}
				// GanzzahlAttributTyp
						setVordergrundfarbe(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
						(daten.
							getUnscaledValue
						("Vordergrundfarbe").
								longValue
						()));
				// GanzzahlAttributTyp
						setHintergrundfarbe(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
						(daten.
							getUnscaledValue
						("Hintergrundfarbe").
								longValue
						()));
				// ZeichenkettenAttributTyp
					setSchriftart(daten.getTextValue("Schriftart").getText());
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Fettdruck").isState()) {
							setFettdruck(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							.getZustand(daten.getScaledValue("Fettdruck").getText()));
						} else {
						setFettdruck(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
						(daten.
							getUnscaledValue
						("Fettdruck").
								byteValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Kursivdruck").isState()) {
							setKursivdruck(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							.getZustand(daten.getScaledValue("Kursivdruck").getText()));
						} else {
						setKursivdruck(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
						(daten.
							getUnscaledValue
						("Kursivdruck").
								byteValue
						()));
						}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlBcBetriebsmeldungDarstellung clone() {
		AtlBcBetriebsmeldungDarstellung klon = new AtlBcBetriebsmeldungDarstellung();
		
						klon.setKlasse(getKlasse());
						klon.setVordergrundfarbe(getVordergrundfarbe());
						klon.setHintergrundfarbe(getHintergrundfarbe());
						klon.setSchriftart(getSchriftart());
						klon.setFettdruck(getFettdruck());
						klon.setKursivdruck(getKursivdruck());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
