/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.bitctrlbmv.parameter;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Definition der externen Versendung von Meldungen.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class PdBcBetriebsmeldungDarstellung extends AbstractParameterDatensatz<PdBcBetriebsmeldungDarstellung.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.ParameterDefault,
					Aspekte.ParameterSoll,
					Aspekte.ParameterVorgabe,
					Aspekte.ParameterIst,
				};
			}
	
			/**
			 * Aspekt der zur Versorgung von Defaultwerten für Parameter verwendet werden kann.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterDefault = new Aspekte("Default-Parameter-Aspekt", "asp.parameterDefault");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterSoll = new Aspekte("Soll-Parameter-Aspekt", "asp.parameterSoll");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterVorgabe = new Aspekte("Vorgabe-Parameter-Aspekt", "asp.parameterVorgabe");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterIst = new Aspekte("Ist-Parameter-Aspekt", "asp.parameterIst");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 _urlasser
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				()
				;
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.bitctrlbmv.attribute.AtlBcBetriebsmeldungDarstellung
				> _darstellung = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.bitctrlbmv.attribute.AtlBcBetriebsmeldungDarstellung
				>(0, true);
				private de.bsvrz.sys.funclib.bitctrl.modell.bitctrlallgemein.attribute.AttAnzahlTage
				 _maxHistory
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.bitctrlallgemein.attribute.AttPositiveZahl32Bit
				 _maxAnzahl
				;
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.bitctrlbmv.attribute.AttBcBetriebsmeldungSpalte
				> _anzuzeigendeSpalten = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.bitctrlbmv.attribute.AttBcBetriebsmeldungSpalte
				>(0, true);
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@return der Wert von Urlasser.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 getUrlasser() {
				return _urlasser;
			}
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@param _urlasser der neue Wert von Urlasser.
			*/
			public void setUrlasser(de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
			 _urlasser) {
				this._urlasser = _urlasser;
			}
		
			/**
			Definition für die Attribute der Anzeige eines Meldungstyps.
			<p>
			
			</p>
			
			@return der Wert von Darstellung.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.bitctrlbmv.attribute.AtlBcBetriebsmeldungDarstellung
				> getDarstellung() {
				return _darstellung;
			}
		
		
			/**
			Minimal geforderte Anzahl.
			<p>
			
			</p>
			
			@return der Wert von MaxHistory.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.bitctrlallgemein.attribute.AttAnzahlTage
				 getMaxHistory() {
				return _maxHistory;
			}
		
			/**
			Minimal geforderte Anzahl.
			<p>
			
			</p>
			
			@param _maxHistory der neue Wert von MaxHistory.
			*/
			public void setMaxHistory(de.bsvrz.sys.funclib.bitctrl.modell.bitctrlallgemein.attribute.AttAnzahlTage
			 _maxHistory) {
				this._maxHistory = _maxHistory;
			}
		
			/**
			Minimal geforderte Anzahl.
			<p>
			
			</p>
			
			@return der Wert von MaxAnzahl.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.bitctrlallgemein.attribute.AttPositiveZahl32Bit
				 getMaxAnzahl() {
				return _maxAnzahl;
			}
		
			/**
			Minimal geforderte Anzahl.
			<p>
			
			</p>
			
			@param _maxAnzahl der neue Wert von MaxAnzahl.
			*/
			public void setMaxAnzahl(de.bsvrz.sys.funclib.bitctrl.modell.bitctrlallgemein.attribute.AttPositiveZahl32Bit
			 _maxAnzahl) {
				this._maxAnzahl = _maxAnzahl;
			}
		
			/**
			Aktionstyp für Meldungen.
			<p>
			
			</p>
			
			@return der Wert von AnzuzeigendeSpalten.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.bitctrlbmv.attribute.AttBcBetriebsmeldungSpalte
				> getAnzuzeigendeSpalten() {
				return _anzuzeigendeSpalten;
			}
		
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().bean2Atl(datum.getItem("Urlasser"), factory);
					// AttributListenDefinition
						final Data.Array arrayDarstellung = datum.getArray("Darstellung");
						arrayDarstellung.setLength(getDarstellung().size());
						for (int i = 0; i < arrayDarstellung.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.bitctrlbmv.attribute.AtlBcBetriebsmeldungDarstellung
							 atl = getDarstellung().get(i);
							atl.bean2Atl(arrayDarstellung.getItem(i), factory);
		
						}
					// GanzzahlAttributTyp
					if (getMaxHistory() != null) {
		                if (getMaxHistory().isZustand()) {
		                    datum.getUnscaledValue("MaxHistory").setText(getMaxHistory().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("MaxHistory").set(getMaxHistory().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getMaxAnzahl() != null) {
		                if (getMaxAnzahl().isZustand()) {
		                    datum.getUnscaledValue("MaxAnzahl").setText(getMaxAnzahl().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("MaxAnzahl").set(getMaxAnzahl().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getAnzuzeigendeSpalten() != null) {
						final Data.NumberArray arrayAnzuzeigendeSpalten = datum.
							getUnscaledArray
							("AnzuzeigendeSpalten");
						arrayAnzuzeigendeSpalten.setLength(getAnzuzeigendeSpalten().size());
						for (int i = 0; i < arrayAnzuzeigendeSpalten.getLength(); ++i) {
							arrayAnzuzeigendeSpalten.getValue(i).set(getAnzuzeigendeSpalten().get(i).getValue());
						}
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().atl2Bean(daten.getItem("Urlasser"), factory);
					// AttributListenDefinition
						final Data.Array arrayDarstellung = daten.getArray("Darstellung");
						for (int i = 0; i < arrayDarstellung.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.bitctrlbmv.attribute.AtlBcBetriebsmeldungDarstellung
							 atl = new de.bsvrz.sys.funclib.bitctrl.modell.bitctrlbmv.attribute.AtlBcBetriebsmeldungDarstellung
							 ();
							atl.atl2Bean(arrayDarstellung.getItem(i), factory);
							getDarstellung().add(atl);
						}
					// GanzzahlAttributTyp
							setMaxHistory(new de.bsvrz.sys.funclib.bitctrl.modell.bitctrlallgemein.attribute.AttAnzahlTage
							(daten.
								getUnscaledValue
							("MaxHistory").
									intValue
							()));
					// GanzzahlAttributTyp
							setMaxAnzahl(new de.bsvrz.sys.funclib.bitctrl.modell.bitctrlallgemein.attribute.AttPositiveZahl32Bit
							(daten.
								getUnscaledValue
							("MaxAnzahl").
									intValue
							()));
					// GanzzahlAttributTyp
						final Data.NumberArray arrayAnzuzeigendeSpalten = daten.
							getUnscaledArray
						("AnzuzeigendeSpalten");
		
						for (int i = 0; i < arrayAnzuzeigendeSpalten.getLength(); ++i) {
		                    if (arrayAnzuzeigendeSpalten.getValue(i).isState()) {
		                        getAnzuzeigendeSpalten().add(de.bsvrz.sys.funclib.bitctrl.modell.bitctrlbmv.attribute.AttBcBetriebsmeldungSpalte
		                        .getZustand(arrayAnzuzeigendeSpalten.getValue(i).getState().getName()));
		                    } else {
		                    getAnzuzeigendeSpalten().add(new de.bsvrz.sys.funclib.bitctrl.modell.bitctrlbmv.attribute.AttBcBetriebsmeldungSpalte
		                    (arrayAnzuzeigendeSpalten.
		                    		intValue
		                    (i)));
		                    }
		                }
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon._urlasser = getUrlasser().clone();
						klon._darstellung = getDarstellung().clone();
							klon.setMaxHistory(getMaxHistory());
							klon.setMaxAnzahl(getMaxAnzahl());
						klon._anzuzeigendeSpalten = getAnzuzeigendeSpalten().clone();
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.bcBetriebsmeldungDarstellung";

	/**
	 * Initialisiert den Parameterdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public PdBcBetriebsmeldungDarstellung(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 

}
