/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.bitctrleclipse.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Horizontale und vertikale Ausrichtung im Draw2D.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 3
 */
public class AtlDraw2DAusrichtung implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private de.bsvrz.sys.funclib.bitctrl.modell.bitctrleclipse.attribute.AttDraw2DAusrichtungHorizontal
			 _horizontal
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.bitctrleclipse.attribute.AttDraw2DAusrichtungVertikal
			 _vertikal
			;
	
		/**
		Horizontale Ausrichtung in Draw2D&#47;GEF.
		<p>
		
		</p>
		
		@return der Wert von Horizontal.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.bitctrleclipse.attribute.AttDraw2DAusrichtungHorizontal
			 getHorizontal() {
			return _horizontal;
		}
	
		/**
		Horizontale Ausrichtung in Draw2D&#47;GEF.
		<p>
		
		</p>
		
		@param _horizontal der neue Wert von Horizontal.
		*/
		public void setHorizontal(de.bsvrz.sys.funclib.bitctrl.modell.bitctrleclipse.attribute.AttDraw2DAusrichtungHorizontal
		 _horizontal) {
			this._horizontal = _horizontal;
		}
	
		/**
		Vertikal Ausrichtung in Draw2D&#47;GEF.
		<p>
		
		</p>
		
		@return der Wert von Vertikal.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.bitctrleclipse.attribute.AttDraw2DAusrichtungVertikal
			 getVertikal() {
			return _vertikal;
		}
	
		/**
		Vertikal Ausrichtung in Draw2D&#47;GEF.
		<p>
		
		</p>
		
		@param _vertikal der neue Wert von Vertikal.
		*/
		public void setVertikal(de.bsvrz.sys.funclib.bitctrl.modell.bitctrleclipse.attribute.AttDraw2DAusrichtungVertikal
		 _vertikal) {
			this._vertikal = _vertikal;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// GanzzahlAttributTyp
				if (getHorizontal() != null) {
	                if (getHorizontal().isZustand()) {
	                    datum.getUnscaledValue("Horizontal").setText(getHorizontal().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Horizontal").set(getHorizontal().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getVertikal() != null) {
	                if (getVertikal().isZustand()) {
	                    datum.getUnscaledValue("Vertikal").setText(getVertikal().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Vertikal").set(getVertikal().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Horizontal").isState()) {
							setHorizontal(de.bsvrz.sys.funclib.bitctrl.modell.bitctrleclipse.attribute.AttDraw2DAusrichtungHorizontal
							.getZustand(daten.getScaledValue("Horizontal").getText()));
						} else {
						setHorizontal(new de.bsvrz.sys.funclib.bitctrl.modell.bitctrleclipse.attribute.AttDraw2DAusrichtungHorizontal
						(daten.
							getUnscaledValue
						("Horizontal").
								byteValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Vertikal").isState()) {
							setVertikal(de.bsvrz.sys.funclib.bitctrl.modell.bitctrleclipse.attribute.AttDraw2DAusrichtungVertikal
							.getZustand(daten.getScaledValue("Vertikal").getText()));
						} else {
						setVertikal(new de.bsvrz.sys.funclib.bitctrl.modell.bitctrleclipse.attribute.AttDraw2DAusrichtungVertikal
						(daten.
							getUnscaledValue
						("Vertikal").
								byteValue
						()));
						}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlDraw2DAusrichtung clone() {
		AtlDraw2DAusrichtung klon = new AtlDraw2DAusrichtung();
		
						klon.setHorizontal(getHorizontal());
						klon.setVertikal(getVertikal());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
