/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.bitctrleclipse.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Beschreibt die Eigenschaften einer Linie wie ihre Stärke und den Stil.
<p>
Entspricht org.eclipse.swt.graphics.LineAttributes
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 2
 */
public class AtlLinienEigenschaften implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private de.bsvrz.sys.funclib.bitctrl.modell.bitctrleclipse.attribute.AttLinienStaerke
			 _linienStaerke
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.bitctrleclipse.attribute.AttLinienStil
			 _linienStil
			;
	
		/**
		Beschreibt die Stärke einer Linie.
		<p>
		Die Liniendicke lässt sich in Eclipse als float beschreiben.
		</p>
		
		@return der Wert von LinienStaerke.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.bitctrleclipse.attribute.AttLinienStaerke
			 getLinienStaerke() {
			return _linienStaerke;
		}
	
		/**
		Beschreibt die Stärke einer Linie.
		<p>
		Die Liniendicke lässt sich in Eclipse als float beschreiben.
		</p>
		
		@param _linienStaerke der neue Wert von LinienStaerke.
		*/
		public void setLinienStaerke(de.bsvrz.sys.funclib.bitctrl.modell.bitctrleclipse.attribute.AttLinienStaerke
		 _linienStaerke) {
			this._linienStaerke = _linienStaerke;
		}
	
		/**
		Beschreibt einen Linienstil.
		<p>
		Die Zahlenwerte der Linienstile sind so gewählt, dass sie den SWT-Konstanten in Eclipse 3.5
							entsprechen.
		</p>
		
		@return der Wert von LinienStil.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.bitctrleclipse.attribute.AttLinienStil
			 getLinienStil() {
			return _linienStil;
		}
	
		/**
		Beschreibt einen Linienstil.
		<p>
		Die Zahlenwerte der Linienstile sind so gewählt, dass sie den SWT-Konstanten in Eclipse 3.5
							entsprechen.
		</p>
		
		@param _linienStil der neue Wert von LinienStil.
		*/
		public void setLinienStil(de.bsvrz.sys.funclib.bitctrl.modell.bitctrleclipse.attribute.AttLinienStil
		 _linienStil) {
			this._linienStil = _linienStil;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// GanzzahlAttributTyp
				if (getLinienStaerke() != null) {
	                if (getLinienStaerke().isZustand()) {
	                    datum.getUnscaledValue("LinienStärke").setText(getLinienStaerke().toString());
	                } else {
						datum.
						getScaledValue
	                	("LinienStärke").set(getLinienStaerke().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getLinienStil() != null) {
	                if (getLinienStil().isZustand()) {
	                    datum.getUnscaledValue("LinienStil").setText(getLinienStil().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("LinienStil").set(getLinienStil().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// GanzzahlAttributTyp
						setLinienStaerke(new de.bsvrz.sys.funclib.bitctrl.modell.bitctrleclipse.attribute.AttLinienStaerke
						(daten.
							getScaledValue
						("LinienStärke").
							doubleValue
						()));
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("LinienStil").isState()) {
							setLinienStil(de.bsvrz.sys.funclib.bitctrl.modell.bitctrleclipse.attribute.AttLinienStil
							.getZustand(daten.getScaledValue("LinienStil").getText()));
						} else {
						setLinienStil(new de.bsvrz.sys.funclib.bitctrl.modell.bitctrleclipse.attribute.AttLinienStil
						(daten.
							getUnscaledValue
						("LinienStil").
								intValue
						()));
						}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlLinienEigenschaften clone() {
		AtlLinienEigenschaften klon = new AtlLinienEigenschaften();
		
						klon.setLinienStaerke(getLinienStaerke());
						klon.setLinienStil(getLinienStil());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
