/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.bitctrleclipse.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Beschreibt eine Schrift mit Art, Größe und Stil.
<p>
Entspricht org.eclipse.swt.graphics.FontData
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlSchrift implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private String
			 _schriftArt
			= new String
			()
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
			 _schriftGroesse
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.bitctrleclipse.attribute.AttSchriftStil
			 _schriftStil
			;
	
		/**
		Attribut zur Speicherung eines Textes.
		<p>
		
		</p>
		
		@return der Wert von SchriftArt.
		*/
			public String
			 getSchriftArt() {
			return _schriftArt;
		}
	
		/**
		Attribut zur Speicherung eines Textes.
		<p>
		
		</p>
		
		@param _schriftArt der neue Wert von SchriftArt.
		*/
		public void setSchriftArt(String
		 _schriftArt) {
			if (_schriftArt.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._schriftArt = _schriftArt;
		}
	
		/**
		Positive ganze Zahl.
		<p>
		
		</p>
		
		@return der Wert von SchriftGroesse.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
			 getSchriftGroesse() {
			return _schriftGroesse;
		}
	
		/**
		Positive ganze Zahl.
		<p>
		
		</p>
		
		@param _schriftGroesse der neue Wert von SchriftGroesse.
		*/
		public void setSchriftGroesse(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
		 _schriftGroesse) {
			this._schriftGroesse = _schriftGroesse;
		}
	
		/**
		Beschreibt einen Schriftstil.
		<p>
		Die Zahlenwerte der Schriftstile sind so gewählt, dass sie den SWT-Konstanten in Eclipse 3.5
							entsprechen.
		</p>
		
		@return der Wert von SchriftStil.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.bitctrleclipse.attribute.AttSchriftStil
			 getSchriftStil() {
			return _schriftStil;
		}
	
		/**
		Beschreibt einen Schriftstil.
		<p>
		Die Zahlenwerte der Schriftstile sind so gewählt, dass sie den SWT-Konstanten in Eclipse 3.5
							entsprechen.
		</p>
		
		@param _schriftStil der neue Wert von SchriftStil.
		*/
		public void setSchriftStil(de.bsvrz.sys.funclib.bitctrl.modell.bitctrleclipse.attribute.AttSchriftStil
		 _schriftStil) {
			this._schriftStil = _schriftStil;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
				if (getSchriftArt() != null) {
					datum.getTextValue("SchriftArt").setText(getSchriftArt());
				}
				// GanzzahlAttributTyp
				if (getSchriftGroesse() != null) {
	                if (getSchriftGroesse().isZustand()) {
	                    datum.getUnscaledValue("SchriftGröße").setText(getSchriftGroesse().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("SchriftGröße").set(getSchriftGroesse().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getSchriftStil() != null) {
	                if (getSchriftStil().isZustand()) {
	                    datum.getUnscaledValue("SchriftStil").setText(getSchriftStil().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("SchriftStil").set(getSchriftStil().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
					setSchriftArt(daten.getTextValue("SchriftArt").getText());
				// GanzzahlAttributTyp
						setSchriftGroesse(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttZahlPositiv
						(daten.
							getUnscaledValue
						("SchriftGröße").
								longValue
						()));
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("SchriftStil").isState()) {
							setSchriftStil(de.bsvrz.sys.funclib.bitctrl.modell.bitctrleclipse.attribute.AttSchriftStil
							.getZustand(daten.getScaledValue("SchriftStil").getText()));
						} else {
						setSchriftStil(new de.bsvrz.sys.funclib.bitctrl.modell.bitctrleclipse.attribute.AttSchriftStil
						(daten.
							getUnscaledValue
						("SchriftStil").
								intValue
						()));
						}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlSchrift clone() {
		AtlSchrift klon = new AtlSchrift();
		
						klon.setSchriftArt(getSchriftArt());
						klon.setSchriftGroesse(getSchriftGroesse());
						klon.setSchriftStil(getSchriftStil());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
