/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.bitctrleclipse.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Vertikal Ausrichtung in Draw2D&#47;GEF.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 3
 */
@Defaultwert(wert = "Oben")
public class AttDraw2DAusrichtungVertikal extends Zahl<		Byte
> {
	
	private static final long serialVersionUID = 1L;
	
	
	/**
	
	<p>
	
	</p>
	*/
	public static final AttDraw2DAusrichtungVertikal ZUSTAND_8_OBEN = new AttDraw2DAusrichtungVertikal("Oben", 		Byte
	.valueOf("8"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttDraw2DAusrichtungVertikal ZUSTAND_16_MITTE = new AttDraw2DAusrichtungVertikal("Mitte", 		Byte
	.valueOf("16"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttDraw2DAusrichtungVertikal ZUSTAND_32_UNTEN = new AttDraw2DAusrichtungVertikal("Unten", 		Byte
	.valueOf("32"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttDraw2DAusrichtungVertikal getZustand(final 		Byte
	 value) {
		for (AttDraw2DAusrichtungVertikal e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttDraw2DAusrichtungVertikal getZustand(final String value) {
		for (AttDraw2DAusrichtungVertikal e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttDraw2DAusrichtungVertikal> getZustaende() {
		List<AttDraw2DAusrichtungVertikal> list = new ArrayList<AttDraw2DAusrichtungVertikal>();
		list.add(ZUSTAND_8_OBEN);
		list.add(ZUSTAND_16_MITTE);
		list.add(ZUSTAND_32_UNTEN);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut Draw2DAusrichtungVertikal.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttDraw2DAusrichtungVertikal(final 		Byte
	 value) {
		super(value);
	}
	
	private AttDraw2DAusrichtungVertikal(final String zustand, final 		Byte
	 value) {
		super(zustand, value);
	}
	
}
