/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.bitctrlhelligkeitextern.objekte;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Definiert eine Applikation, die die aktuelle Umfeldhelligkeit (in Lx) von einer Quelle außerhalb des Systems bezieht.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public interface HelligkeitExternProvider extends de.bsvrz.sys.funclib.bitctrl.modell.KonfigurationsObjekt
	,de.bsvrz.sys.funclib.bitctrl.modell.bitctrlappmanagement.objekte.BcManagedApplication,de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.objekte.PunktXY
	
	
	
	{

	/** Die PID des Systemobjekttyps im Datenverteiler. */
	public static final String PID = "typ.helligkeitExternProvider"; 
	
	/*
	 * Beginn Abschnitt Mengen
	 */
	

	/*
	 * Ende Abschnitt Mengen
	 */

	/*
	 * Beginn Abschnitt Attributgruppen
	 */

	/**
	Beschreibt den Zustand der Applikation, welche die externen Helligkeitswerte bereitstellt.
	<p>
	
	</p>
	@return der Datensatz ZustandExterneHelligkeit.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.bitctrlhelligkeitextern.onlinedaten.OdZustandExterneHelligkeit getOdZustandExterneHelligkeit();
	
	/**
	Attributgruppe zur Speicherung von Default-Parameterdatensätzen für alle Parameter-Attributgruppen eines Typs.
	<p>
	
	</p>
	@return der Datensatz DefaultParameterdatensaetze.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdDefaultParameterdatensaetze getKdDefaultParameterdatensaetze();
	
	/**
	Attributgruppe zur Speicherung von beschreibenden Informationen zu einem Objekt.
	<p>
	
	</p>
	@return der Datensatz Info.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdInfo getKdInfo();
	
	/**
	Verwaltet bis zu zehn alternative Bezeichnungen.
	<p>
	
	</p>
	@return der Datensatz AlternativeObjektbezeichnung.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdAlternativeObjektbezeichnung getKdAlternativeObjektbezeichnung();
	
	/**
	Koordinaten eines Punktes in Grad entsprechend WGS84.
	<p>
	
	</p>
	@return der Datensatz PunktKoordinaten.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.konfigurationsdaten.KdPunktKoordinaten getKdPunktKoordinaten();
	
	/**
	Enthält die Parameter für die Applikation, welche die externen Helligkeitswerte bereitstellt.
	<p>
	
	</p>
	@return der Datensatz ParameterExterneHelligkeit.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.bitctrlhelligkeitextern.parameter.PdParameterExterneHelligkeit getPdParameterExterneHelligkeit();
	
	/**
	Datensatz zur Beschreibung einer Anfrage an eine
						Managed Application.
	<p>
	
	</p>
	@return der Datensatz BcManagedApplicationKommando.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.bitctrlappmanagement.onlinedaten.OdBcManagedApplicationKommando getOdBcManagedApplicationKommando();
	
	/**
	Datensatz zur Beschreibung einer
						Antwort von einer
						Managed Application.
	<p>
	
	</p>
	@return der Datensatz BcManagedApplicationAntwort.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.bitctrlappmanagement.onlinedaten.OdBcManagedApplicationAntwort getOdBcManagedApplicationAntwort();
	
	
	/*
	 * Ende Abschnitt Attributgruppen
	 */
	 
}
