/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.bitctrlhelligkeitextern.onlinedaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Beschreibt den Zustand der Applikation, welche die externen Helligkeitswerte bereitstellt.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 2
 */
public class OdZustandExterneHelligkeit extends AbstractOnlineDatensatz<OdZustandExterneHelligkeit.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.Zustand,
				};
			}
	
			/**
			 * Zustand.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt Zustand = new Aspekte("Zustand", "asp.zustand");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.bitctrlhelligkeitextern.attribute.AttArtDerExternenHelligkeitsQuelle
				 _artDerExternenHelligkeitsQuelle
				;
				private 	RelativerZeitstempel
				 _t
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AtlUfdsHelligkeit
				 _helligkeit
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AtlUfdsHelligkeit
				()
				;
		
			/**
			Definiert die Art der externen Helligkeitsquelle.
			<p>
			
			</p>
			
			@return der Wert von ArtDerExternenHelligkeitsQuelle.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.bitctrlhelligkeitextern.attribute.AttArtDerExternenHelligkeitsQuelle
				 getArtDerExternenHelligkeitsQuelle() {
				return _artDerExternenHelligkeitsQuelle;
			}
		
			/**
			Definiert die Art der externen Helligkeitsquelle.
			<p>
			
			</p>
			
			@param _artDerExternenHelligkeitsQuelle der neue Wert von ArtDerExternenHelligkeitsQuelle.
			*/
			public void setArtDerExternenHelligkeitsQuelle(de.bsvrz.sys.funclib.bitctrl.modell.bitctrlhelligkeitextern.attribute.AttArtDerExternenHelligkeitsQuelle
			 _artDerExternenHelligkeitsQuelle) {
				this._artDerExternenHelligkeitsQuelle = _artDerExternenHelligkeitsQuelle;
			}
		
			/**
			Inervalldauer, mit dem der Wert erfasst wurde.
			<p>
			
			</p>
			
			@return der Wert von T.
			*/
				public 	RelativerZeitstempel
				 getT() {
				return _t;
			}
		
			/**
			Inervalldauer, mit dem der Wert erfasst wurde.
			<p>
			
			</p>
			
			@param _t der neue Wert von T.
			*/
			public void setT(	RelativerZeitstempel
			 _t) {
				this._t = _t;
			}
		
			/**
			Sensorwert mit Status- und Güteinformationen.
			<p>
			
			</p>
			
			@return der Wert von Helligkeit.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AtlUfdsHelligkeit
				 getHelligkeit() {
				return _helligkeit;
			}
		
			/**
			Sensorwert mit Status- und Güteinformationen.
			<p>
			
			</p>
			
			@param _helligkeit der neue Wert von Helligkeit.
			*/
			public void setHelligkeit(de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.attribute.AtlUfdsHelligkeit
			 _helligkeit) {
				this._helligkeit = _helligkeit;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// GanzzahlAttributTyp
					if (getArtDerExternenHelligkeitsQuelle() != null) {
		                if (getArtDerExternenHelligkeitsQuelle().isZustand()) {
		                    datum.getUnscaledValue("ArtDerExternenHelligkeitsQuelle").setText(getArtDerExternenHelligkeitsQuelle().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("ArtDerExternenHelligkeitsQuelle").set(getArtDerExternenHelligkeitsQuelle().getValue());
		                }
					}
					// ZeitstempelAttributTyp
						datum.getTimeValue("T").setMillis(getT().getTime());
					// AttributListenDefinition
						getHelligkeit().bean2Atl(datum.getItem("Helligkeit"), factory);
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("ArtDerExternenHelligkeitsQuelle").isState()) {
								setArtDerExternenHelligkeitsQuelle(de.bsvrz.sys.funclib.bitctrl.modell.bitctrlhelligkeitextern.attribute.AttArtDerExternenHelligkeitsQuelle
								.getZustand(daten.getScaledValue("ArtDerExternenHelligkeitsQuelle").getText()));
							} else {
							setArtDerExternenHelligkeitsQuelle(new de.bsvrz.sys.funclib.bitctrl.modell.bitctrlhelligkeitextern.attribute.AttArtDerExternenHelligkeitsQuelle
							(daten.
								getUnscaledValue
							("ArtDerExternenHelligkeitsQuelle").
									byteValue
							()));
							}
					// ZeitstempelAttributTyp
						setT(new
							RelativerZeitstempel
							(daten.getTimeValue("T").getMillis()));
					// AttributListenDefinition
						getHelligkeit().atl2Bean(daten.getItem("Helligkeit"), factory);
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setArtDerExternenHelligkeitsQuelle(getArtDerExternenHelligkeitsQuelle());
							klon.setT(getT());
							klon._helligkeit = getHelligkeit().clone();
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.zustandExterneHelligkeit";

	/**
	 * Initialisiert den Onlinedatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public OdZustandExterneHelligkeit(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
