/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.bitctrlsimulation.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Datenstruktur, die die Reaktion einer DE beschreibt.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlBcSimDeLokal implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private String
			 _pid
			= new String
			()
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.bitctrlsimulation.attribute.AtlBcSimDe
			 _reaktion
			= new de.bsvrz.sys.funclib.bitctrl.modell.bitctrlsimulation.attribute.AtlBcSimDe
			()
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _aktiv
			;
	
		/**
		Attribut zur Speicherung eines Textes.
		<p>
		
		</p>
		
		@return der Wert von Pid.
		*/
			public String
			 getPid() {
			return _pid;
		}
	
		/**
		Attribut zur Speicherung eines Textes.
		<p>
		
		</p>
		
		@param _pid der neue Wert von Pid.
		*/
		public void setPid(String
		 _pid) {
			if (_pid.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._pid = _pid;
		}
	
		/**
		Datenstruktur, die die Reaktion einer DE beschreibt.
		<p>
		
		</p>
		
		@return der Wert von Reaktion.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.bitctrlsimulation.attribute.AtlBcSimDe
			 getReaktion() {
			return _reaktion;
		}
	
		/**
		Datenstruktur, die die Reaktion einer DE beschreibt.
		<p>
		
		</p>
		
		@param _reaktion der neue Wert von Reaktion.
		*/
		public void setReaktion(de.bsvrz.sys.funclib.bitctrl.modell.bitctrlsimulation.attribute.AtlBcSimDe
		 _reaktion) {
			this._reaktion = _reaktion;
		}
	
		/**
		Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
		<p>
		
		</p>
		
		@return der Wert von Aktiv.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 getAktiv() {
			return _aktiv;
		}
	
		/**
		Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
		<p>
		
		</p>
		
		@param _aktiv der neue Wert von Aktiv.
		*/
		public void setAktiv(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
		 _aktiv) {
			this._aktiv = _aktiv;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
				if (getPid() != null) {
					datum.getTextValue("Pid").setText(getPid());
				}
				// AttributListenDefinition
					getReaktion().bean2Atl(datum.getItem("Reaktion"), factory);
				// GanzzahlAttributTyp
				if (getAktiv() != null) {
	                if (getAktiv().isZustand()) {
	                    datum.getUnscaledValue("Aktiv").setText(getAktiv().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Aktiv").set(getAktiv().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
					setPid(daten.getTextValue("Pid").getText());
				// AttributListenDefinition
					getReaktion().atl2Bean(daten.getItem("Reaktion"), factory);
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Aktiv").isState()) {
							setAktiv(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							.getZustand(daten.getScaledValue("Aktiv").getText()));
						} else {
						setAktiv(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
						(daten.
							getUnscaledValue
						("Aktiv").
								byteValue
						()));
						}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlBcSimDeLokal clone() {
		AtlBcSimDeLokal klon = new AtlBcSimDeLokal();
		
						klon.setPid(getPid());
						klon._reaktion = getReaktion().clone();
						klon.setAktiv(getAktiv());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
