/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.bitctrltlshelligkeitssteuerungmarz.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Konfiguriert bzw. parametriert die automatische Sensorenprüfung.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlAutomatischeSensorenPruefung implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private 	Zeitstempel
			 _uhrzeit
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsUfdHelligkeit
			 _grenzwert
			;
	
		/**
		Zeit im aktuellen Kontext (Simulationszeit oder Systemzeit).
		<p>
		
		</p>
		
		@return der Wert von Uhrzeit.
		*/
			public 	Zeitstempel
			 getUhrzeit() {
			return _uhrzeit;
		}
	
		/**
		Zeit im aktuellen Kontext (Simulationszeit oder Systemzeit).
		<p>
		
		</p>
		
		@param _uhrzeit der neue Wert von Uhrzeit.
		*/
		public void setUhrzeit(	Zeitstempel
		 _uhrzeit) {
			this._uhrzeit = _uhrzeit;
		}
	
		/**
		Helligkeit.
		<p>
		Helligkeit ist definiert als Beleuchtungsstärke
							(Anteil des auf eine ebene Messfläche senkrecht
							auftreffenden Komponente des Lichtstroms im
							sichtbaren Spektralbereich) in Lux angegeben. Die
							Ausrichtung des Sensors sollte beachtet werden. Es
							wird der IST-Wert übertragen.
		</p>
		
		@return der Wert von Grenzwert.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsUfdHelligkeit
			 getGrenzwert() {
			return _grenzwert;
		}
	
		/**
		Helligkeit.
		<p>
		Helligkeit ist definiert als Beleuchtungsstärke
							(Anteil des auf eine ebene Messfläche senkrecht
							auftreffenden Komponente des Lichtstroms im
							sichtbaren Spektralbereich) in Lux angegeben. Die
							Ausrichtung des Sensors sollte beachtet werden. Es
							wird der IST-Wert übertragen.
		</p>
		
		@param _grenzwert der neue Wert von Grenzwert.
		*/
		public void setGrenzwert(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsUfdHelligkeit
		 _grenzwert) {
			this._grenzwert = _grenzwert;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ZeitstempelAttributTyp
					datum.getTimeValue("Uhrzeit").setMillis(getUhrzeit().getTime());
				// GanzzahlAttributTyp
				if (getGrenzwert() != null) {
	                if (getGrenzwert().isZustand()) {
	                    datum.getUnscaledValue("Grenzwert").setText(getGrenzwert().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Grenzwert").set(getGrenzwert().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ZeitstempelAttributTyp
					setUhrzeit(new
						Zeitstempel
						(daten.getTimeValue("Uhrzeit").getMillis()));
				// GanzzahlAttributTyp
						setGrenzwert(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsUfdHelligkeit
						(daten.
							getUnscaledValue
						("Grenzwert").
								intValue
						()));
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlAutomatischeSensorenPruefung clone() {
		AtlAutomatischeSensorenPruefung klon = new AtlAutomatischeSensorenPruefung();
		
						klon.setUhrzeit(getUhrzeit());
						klon.setGrenzwert(getGrenzwert());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
