/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.bitctrltlshelligkeitssteuerungmarz.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Parametriert die Clusterkanäle, die nicht implizit über die globalen Vorgaben
				versorgt sind (Überschreiben).
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlClusterKanalVorgaben implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _beruecksichtigen
			;
			private 	de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.objekte.UfdsHelligkeit
			 _sensor
			;
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.bitctrltlshelligkeitssteuerungmarz.attribute.AtlHelligkeitsStufenAttribute
			> _tabelleHelligkeitsStufenAttribute = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.bitctrltlshelligkeitssteuerungmarz.attribute.AtlHelligkeitsStufenAttribute
			>(0, true);
	
		/**
		Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
		<p>
		
		</p>
		
		@return der Wert von Beruecksichtigen.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 getBeruecksichtigen() {
			return _beruecksichtigen;
		}
	
		/**
		Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
		<p>
		
		</p>
		
		@param _beruecksichtigen der neue Wert von Beruecksichtigen.
		*/
		public void setBeruecksichtigen(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
		 _beruecksichtigen) {
			this._beruecksichtigen = _beruecksichtigen;
		}
	
		/**
		Attribut zur Referenzierung des Objekttyps: typ.ufdsHelligkeit.
		<p>
		
		</p>
		
		@return der Wert von Sensor.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.objekte.UfdsHelligkeit
			 getSensor() {
			return _sensor;
		}
	
		/**
		Attribut zur Referenzierung des Objekttyps: typ.ufdsHelligkeit.
		<p>
		
		</p>
		
		@param _sensor der neue Wert von Sensor.
		*/
		public void setSensor(	de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.objekte.UfdsHelligkeit
		 _sensor) {
			this._sensor = _sensor;
		}
	
		/**
		Weist einer nur durch ihren Index definierten Helligkeitsstufe weitere
						Attribute zu, z.B. einen Namen und einen Prozentwert.
		<p>
		
		</p>
		
		@return der Wert von TabelleHelligkeitsStufenAttribute.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.bitctrltlshelligkeitssteuerungmarz.attribute.AtlHelligkeitsStufenAttribute
			> getTabelleHelligkeitsStufenAttribute() {
			return _tabelleHelligkeitsStufenAttribute;
		}
	
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// GanzzahlAttributTyp
				if (getBeruecksichtigen() != null) {
	                if (getBeruecksichtigen().isZustand()) {
	                    datum.getUnscaledValue("Berücksichtigen").setText(getBeruecksichtigen().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Berücksichtigen").set(getBeruecksichtigen().getValue());
	                }
				}
				// ObjektReferenzAttributTyp
					final Object soSensor = getSensor();
					final SystemObject tmpSensor;
						if (soSensor instanceof SystemObject) {
							tmpSensor = (SystemObject)soSensor;
						} else if(soSensor instanceof SystemObjekt){
							tmpSensor = ((SystemObjekt)soSensor).getSystemObject();
						} else{
							tmpSensor = null;
						}
					datum.getReferenceValue("Sensor").setSystemObject(tmpSensor);
				// AttributListenDefinition
					final Data.Array arrayTabelleHelligkeitsStufenAttribute = datum.getArray("TabelleHelligkeitsStufenAttribute");
					arrayTabelleHelligkeitsStufenAttribute.setLength(getTabelleHelligkeitsStufenAttribute().size());
					for (int i = 0; i < arrayTabelleHelligkeitsStufenAttribute.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.bitctrltlshelligkeitssteuerungmarz.attribute.AtlHelligkeitsStufenAttribute
						 atl = getTabelleHelligkeitsStufenAttribute().get(i);
						atl.bean2Atl(arrayTabelleHelligkeitsStufenAttribute.getItem(i), factory);
	
					}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Berücksichtigen").isState()) {
							setBeruecksichtigen(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							.getZustand(daten.getScaledValue("Berücksichtigen").getText()));
						} else {
						setBeruecksichtigen(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
						(daten.
							getUnscaledValue
						("Berücksichtigen").
								byteValue
						()));
						}
				// ObjektReferenzAttributTyp
					final long idSensor = daten.getReferenceValue("Sensor").getId();
					final SystemObjekt tmpSensor;
					if (idSensor == 0) {
						tmpSensor = null;
					} else {
						final SystemObject soSensor = factory.getDav().getDataModel().getObject(idSensor);
						if (soSensor == null) {
								tmpSensor = new de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.objekte.impl.UfdsHelligkeitUngueltig(idSensor);
						} else {
							tmpSensor = factory.getModellobjekt(soSensor);
						}
					}
					setSensor((	de.bsvrz.sys.funclib.bitctrl.modell.tmumfelddatenglobal.objekte.UfdsHelligkeit
					) tmpSensor);
				// AttributListenDefinition
					final Data.Array arrayTabelleHelligkeitsStufenAttribute = daten.getArray("TabelleHelligkeitsStufenAttribute");
					for (int i = 0; i < arrayTabelleHelligkeitsStufenAttribute.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.bitctrltlshelligkeitssteuerungmarz.attribute.AtlHelligkeitsStufenAttribute
						 atl = new de.bsvrz.sys.funclib.bitctrl.modell.bitctrltlshelligkeitssteuerungmarz.attribute.AtlHelligkeitsStufenAttribute
						 ();
						atl.atl2Bean(arrayTabelleHelligkeitsStufenAttribute.getItem(i), factory);
						getTabelleHelligkeitsStufenAttribute().add(atl);
					}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlClusterKanalVorgaben clone() {
		AtlClusterKanalVorgaben klon = new AtlClusterKanalVorgaben();
		
						klon.setBeruecksichtigen(getBeruecksichtigen());
						klon.setSensor(getSensor());
					klon._tabelleHelligkeitsStufenAttribute = getTabelleHelligkeitsStufenAttribute().clone();
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
