/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.bitctrltlshelligkeitssteuerungmarz.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Weist einer nur durch ihren Index definierten Helligkeitsstufe weitere
				Attribute zu, z.B. einen Namen und einen Prozentwert.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlHelligkeitsStufenAttribute implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private String
			 _stufenbezeichnung
			= new String
			()
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttProzent
			 _prozentwert
			;
	
		/**
		Attribut zur Speicherung eines Textes.
		<p>
		
		</p>
		
		@return der Wert von Stufenbezeichnung.
		*/
			public String
			 getStufenbezeichnung() {
			return _stufenbezeichnung;
		}
	
		/**
		Attribut zur Speicherung eines Textes.
		<p>
		
		</p>
		
		@param _stufenbezeichnung der neue Wert von Stufenbezeichnung.
		*/
		public void setStufenbezeichnung(String
		 _stufenbezeichnung) {
			if (_stufenbezeichnung.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._stufenbezeichnung = _stufenbezeichnung;
		}
	
		/**
		Prozentwert.
		<p>
		
		</p>
		
		@return der Wert von Prozentwert.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttProzent
			 getProzentwert() {
			return _prozentwert;
		}
	
		/**
		Prozentwert.
		<p>
		
		</p>
		
		@param _prozentwert der neue Wert von Prozentwert.
		*/
		public void setProzentwert(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttProzent
		 _prozentwert) {
			this._prozentwert = _prozentwert;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
				if (getStufenbezeichnung() != null) {
					datum.getTextValue("Stufenbezeichnung").setText(getStufenbezeichnung());
				}
				// GanzzahlAttributTyp
				if (getProzentwert() != null) {
	                if (getProzentwert().isZustand()) {
	                    datum.getUnscaledValue("Prozentwert").setText(getProzentwert().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Prozentwert").set(getProzentwert().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
					setStufenbezeichnung(daten.getTextValue("Stufenbezeichnung").getText());
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Prozentwert").isState()) {
							setProzentwert(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttProzent
							.getZustand(daten.getScaledValue("Prozentwert").getText()));
						} else {
						setProzentwert(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttProzent
						(daten.
							getUnscaledValue
						("Prozentwert").
								byteValue
						()));
						}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlHelligkeitsStufenAttribute clone() {
		AtlHelligkeitsStufenAttribute klon = new AtlHelligkeitsStufenAttribute();
		
						klon.setStufenbezeichnung(getStufenbezeichnung());
						klon.setProzentwert(getProzentwert());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
