/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.bitctrltlshelligkeitssteuerungmarz.objekte;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Realisiert die Helligkeitssteuerung von WZG der FG4 nach MARZ Kapitel 2.3.2.2.3.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public interface TlsHelligkeitsSteuerungMARZ extends de.bsvrz.sys.funclib.bitctrl.modell.KonfigurationsObjekt
	,de.bsvrz.sys.funclib.bitctrl.modell.bitctrlappmanagement.objekte.BcManagedApplication
	
	
	
	{

	/** Die PID des Systemobjekttyps im Datenverteiler. */
	public static final String PID = "typ.tlsHelligkeitsSteuerungMARZ"; 
	
	/*
	 * Beginn Abschnitt Mengen
	 */
	

	/*
	 * Ende Abschnitt Mengen
	 */

	/*
	 * Beginn Abschnitt Attributgruppen
	 */

	/**
	Attributgruppe zur Speicherung von Default-Parameterdatensätzen für alle Parameter-Attributgruppen eines Typs.
	<p>
	
	</p>
	@return der Datensatz DefaultParameterdatensaetze.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdDefaultParameterdatensaetze getKdDefaultParameterdatensaetze();
	
	/**
	Enthält die parametrierten globalen Vorgaben der Helligkeitssteuerung, diese können pro Sensor
					überschrieben werden.
	<p>
	
	</p>
	@return der Datensatz TlsHelligkeitsSteuerungMARZglobal.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.bitctrltlshelligkeitssteuerungmarz.parameter.PdTlsHelligkeitsSteuerungMARZglobal getPdTlsHelligkeitsSteuerungMARZglobal();
	
	/**
	Attributgruppe zur Speicherung von beschreibenden Informationen zu einem Objekt.
	<p>
	
	</p>
	@return der Datensatz Info.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdInfo getKdInfo();
	
	/**
	Verwaltet bis zu zehn alternative Bezeichnungen.
	<p>
	
	</p>
	@return der Datensatz AlternativeObjektbezeichnung.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdAlternativeObjektbezeichnung getKdAlternativeObjektbezeichnung();
	
	/**
	Enthält die parametrierten Vorgaben für einzelne DE WZG (Clusterkanäle).
	<p>
	
	</p>
	@return der Datensatz TlsHelligkeitsSteuerungMARZDeWzgSpezifikation.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.bitctrltlshelligkeitssteuerungmarz.parameter.PdTlsHelligkeitsSteuerungMARZDeWzgSpezifikation getPdTlsHelligkeitsSteuerungMARZDeWzgSpezifikation();
	
	/**
	Datensatz zur Beschreibung einer Anfrage an eine
						Managed Application.
	<p>
	
	</p>
	@return der Datensatz BcManagedApplicationKommando.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.bitctrlappmanagement.onlinedaten.OdBcManagedApplicationKommando getOdBcManagedApplicationKommando();
	
	/**
	Datensatz zur Beschreibung einer
						Antwort von einer
						Managed Application.
	<p>
	
	</p>
	@return der Datensatz BcManagedApplicationAntwort.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.bitctrlappmanagement.onlinedaten.OdBcManagedApplicationAntwort getOdBcManagedApplicationAntwort();
	
	
	/*
	 * Ende Abschnitt Attributgruppen
	 */
	 
}
