/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.bitctrlumfelddatenmodell.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Ein Eintrag in einer Tabelle, der einem
					Umfelddatensensor-Typ
					eine (gewichtete) Liste von Sensoren zuweist.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 2
 */
public class AtlEintragTabelleUfdsTypListe implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private 	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Typ
			 _umfelddatenSensorTyp
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.bitctrlumfelddatenmodell.attribute.AttUfdsEvalType
			 _bewertungstyp
			;
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.bitctrlumfelddatenmodell.attribute.AtlEintragTabelleUfdsGewicht
			> _gewichteteSensorListe = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.bitctrlumfelddatenmodell.attribute.AtlEintragTabelleUfdsGewicht
			>(0, true);
	
		/**
		Attribut zur Referenzierung von Objekttypen.
		<p>
		
		</p>
		
		@return der Wert von UmfelddatenSensorTyp.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Typ
			 getUmfelddatenSensorTyp() {
			return _umfelddatenSensorTyp;
		}
	
		/**
		Attribut zur Referenzierung von Objekttypen.
		<p>
		
		</p>
		
		@param _umfelddatenSensorTyp der neue Wert von UmfelddatenSensorTyp.
		*/
		public void setUmfelddatenSensorTyp(	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Typ
		 _umfelddatenSensorTyp) {
			this._umfelddatenSensorTyp = _umfelddatenSensorTyp;
		}
	
		/**
		definiert die Typen für die Artt der Bewertung einer Liste
							von Umfelddatensensoren im UfdsWichter der UFDEventGenerators.
		<p>
		
		</p>
		
		@return der Wert von Bewertungstyp.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.bitctrlumfelddatenmodell.attribute.AttUfdsEvalType
			 getBewertungstyp() {
			return _bewertungstyp;
		}
	
		/**
		definiert die Typen für die Artt der Bewertung einer Liste
							von Umfelddatensensoren im UfdsWichter der UFDEventGenerators.
		<p>
		
		</p>
		
		@param _bewertungstyp der neue Wert von Bewertungstyp.
		*/
		public void setBewertungstyp(de.bsvrz.sys.funclib.bitctrl.modell.bitctrlumfelddatenmodell.attribute.AttUfdsEvalType
		 _bewertungstyp) {
			this._bewertungstyp = _bewertungstyp;
		}
	
		/**
		Ein Eintrag in einer Tabelle, der einem Umfelddatensensor
							ein Gewicht zuweist.
		<p>
		
		</p>
		
		@return der Wert von GewichteteSensorListe.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.bitctrlumfelddatenmodell.attribute.AtlEintragTabelleUfdsGewicht
			> getGewichteteSensorListe() {
			return _gewichteteSensorListe;
		}
	
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Object soUmfelddatenSensorTyp = getUmfelddatenSensorTyp();
					final SystemObject tmpUmfelddatenSensorTyp;
						if (soUmfelddatenSensorTyp instanceof SystemObject) {
							tmpUmfelddatenSensorTyp = (SystemObject)soUmfelddatenSensorTyp;
						} else if(soUmfelddatenSensorTyp instanceof SystemObjekt){
							tmpUmfelddatenSensorTyp = ((SystemObjekt)soUmfelddatenSensorTyp).getSystemObject();
						} else{
							tmpUmfelddatenSensorTyp = null;
						}
					datum.getReferenceValue("UmfelddatenSensorTyp").setSystemObject(tmpUmfelddatenSensorTyp);
				// GanzzahlAttributTyp
				if (getBewertungstyp() != null) {
	                if (getBewertungstyp().isZustand()) {
	                    datum.getUnscaledValue("Bewertungstyp").setText(getBewertungstyp().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Bewertungstyp").set(getBewertungstyp().getValue());
	                }
				}
				// AttributListenDefinition
					final Data.Array arrayGewichteteSensorListe = datum.getArray("GewichteteSensorListe");
					arrayGewichteteSensorListe.setLength(getGewichteteSensorListe().size());
					for (int i = 0; i < arrayGewichteteSensorListe.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.bitctrlumfelddatenmodell.attribute.AtlEintragTabelleUfdsGewicht
						 atl = getGewichteteSensorListe().get(i);
						atl.bean2Atl(arrayGewichteteSensorListe.getItem(i), factory);
	
					}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final long idUmfelddatenSensorTyp = daten.getReferenceValue("UmfelddatenSensorTyp").getId();
					final SystemObjekt tmpUmfelddatenSensorTyp;
					if (idUmfelddatenSensorTyp == 0) {
						tmpUmfelddatenSensorTyp = null;
					} else {
						final SystemObject soUmfelddatenSensorTyp = factory.getDav().getDataModel().getObject(idUmfelddatenSensorTyp);
						if (soUmfelddatenSensorTyp == null) {
								tmpUmfelddatenSensorTyp = new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.TypUngueltig(idUmfelddatenSensorTyp);
						} else {
							tmpUmfelddatenSensorTyp = factory.getModellobjekt(soUmfelddatenSensorTyp);
						}
					}
					setUmfelddatenSensorTyp((	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Typ
					) tmpUmfelddatenSensorTyp);
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Bewertungstyp").isState()) {
							setBewertungstyp(de.bsvrz.sys.funclib.bitctrl.modell.bitctrlumfelddatenmodell.attribute.AttUfdsEvalType
							.getZustand(daten.getScaledValue("Bewertungstyp").getText()));
						} else {
						setBewertungstyp(new de.bsvrz.sys.funclib.bitctrl.modell.bitctrlumfelddatenmodell.attribute.AttUfdsEvalType
						(daten.
							getUnscaledValue
						("Bewertungstyp").
								shortValue
						()));
						}
				// AttributListenDefinition
					final Data.Array arrayGewichteteSensorListe = daten.getArray("GewichteteSensorListe");
					for (int i = 0; i < arrayGewichteteSensorListe.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.bitctrlumfelddatenmodell.attribute.AtlEintragTabelleUfdsGewicht
						 atl = new de.bsvrz.sys.funclib.bitctrl.modell.bitctrlumfelddatenmodell.attribute.AtlEintragTabelleUfdsGewicht
						 ();
						atl.atl2Bean(arrayGewichteteSensorListe.getItem(i), factory);
						getGewichteteSensorListe().add(atl);
					}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlEintragTabelleUfdsTypListe clone() {
		AtlEintragTabelleUfdsTypListe klon = new AtlEintragTabelleUfdsTypListe();
		
						klon.setUmfelddatenSensorTyp(getUmfelddatenSensorTyp());
						klon.setBewertungstyp(getBewertungstyp());
					klon._gewichteteSensorListe = getGewichteteSensorListe().clone();
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
