/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.dauerzaehlstelle.onlinedaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Kennungen fuer Status AbfrageZustand.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class OdAbfrageZustand extends AbstractOnlineDatensatz<OdAbfrageZustand.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.TlsAntwort,
				};
			}
	
			/**
			 * Aspekt für Antworten von TLS-Daten eines DE-Blocks
						nach Abruf, nach Pufferabfrage oder spontan.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt TlsAntwort = new Aspekte("TlsAntwort", "asp.tlsAntwort");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.dauerzaehlstelle.attribute.AttAbfrageZustand
				 _abfrageZustand
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
				 _abfrageApplikation
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
				 _abfrageAuftrag
				;
		
			/**
			Kennungen fuer Status KommunikationsZustand.
			<p>
			
			</p>
			
			@return der Wert von AbfrageZustand.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.dauerzaehlstelle.attribute.AttAbfrageZustand
				 getAbfrageZustand() {
				return _abfrageZustand;
			}
		
			/**
			Kennungen fuer Status KommunikationsZustand.
			<p>
			
			</p>
			
			@param _abfrageZustand der neue Wert von AbfrageZustand.
			*/
			public void setAbfrageZustand(de.bsvrz.sys.funclib.bitctrl.modell.dauerzaehlstelle.attribute.AttAbfrageZustand
			 _abfrageZustand) {
				this._abfrageZustand = _abfrageZustand;
			}
		
			/**
			Beliebige ganze Zahl im Bereich -2^63 bis (2^63)-1.
			<p>
			
			</p>
			
			@return der Wert von AbfrageApplikation.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
				 getAbfrageApplikation() {
				return _abfrageApplikation;
			}
		
			/**
			Beliebige ganze Zahl im Bereich -2^63 bis (2^63)-1.
			<p>
			
			</p>
			
			@param _abfrageApplikation der neue Wert von AbfrageApplikation.
			*/
			public void setAbfrageApplikation(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			 _abfrageApplikation) {
				this._abfrageApplikation = _abfrageApplikation;
			}
		
			/**
			Beliebige ganze Zahl im Bereich -2^63 bis (2^63)-1.
			<p>
			
			</p>
			
			@return der Wert von AbfrageAuftrag.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
				 getAbfrageAuftrag() {
				return _abfrageAuftrag;
			}
		
			/**
			Beliebige ganze Zahl im Bereich -2^63 bis (2^63)-1.
			<p>
			
			</p>
			
			@param _abfrageAuftrag der neue Wert von AbfrageAuftrag.
			*/
			public void setAbfrageAuftrag(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			 _abfrageAuftrag) {
				this._abfrageAuftrag = _abfrageAuftrag;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// GanzzahlAttributTyp
					if (getAbfrageZustand() != null) {
		                if (getAbfrageZustand().isZustand()) {
		                    datum.getUnscaledValue("AbfrageZustand").setText(getAbfrageZustand().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("AbfrageZustand").set(getAbfrageZustand().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getAbfrageApplikation() != null) {
		                if (getAbfrageApplikation().isZustand()) {
		                    datum.getUnscaledValue("AbfrageApplikation").setText(getAbfrageApplikation().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("AbfrageApplikation").set(getAbfrageApplikation().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getAbfrageAuftrag() != null) {
		                if (getAbfrageAuftrag().isZustand()) {
		                    datum.getUnscaledValue("AbfrageAuftrag").setText(getAbfrageAuftrag().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("AbfrageAuftrag").set(getAbfrageAuftrag().getValue());
		                }
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("AbfrageZustand").isState()) {
								setAbfrageZustand(de.bsvrz.sys.funclib.bitctrl.modell.dauerzaehlstelle.attribute.AttAbfrageZustand
								.getZustand(daten.getScaledValue("AbfrageZustand").getText()));
							} else {
							setAbfrageZustand(new de.bsvrz.sys.funclib.bitctrl.modell.dauerzaehlstelle.attribute.AttAbfrageZustand
							(daten.
								getUnscaledValue
							("AbfrageZustand").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							setAbfrageApplikation(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
							(daten.
								getUnscaledValue
							("AbfrageApplikation").
									longValue
							()));
					// GanzzahlAttributTyp
							setAbfrageAuftrag(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
							(daten.
								getUnscaledValue
							("AbfrageAuftrag").
									longValue
							()));
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setAbfrageZustand(getAbfrageZustand());
							klon.setAbfrageApplikation(getAbfrageApplikation());
							klon.setAbfrageAuftrag(getAbfrageAuftrag());
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.abfrageZustand";

	/**
	 * Initialisiert den Onlinedatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public OdAbfrageZustand(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
