/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.dauerzaehlstelle.onlinedaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Baustellenstatus.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 13
 */
public class OdBaustellenStatus extends AbstractOnlineDatensatz<OdBaustellenStatus.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.Zustand,
				};
			}
	
			/**
			 * Zustand.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt Zustand = new Aspekte("Zustand", "asp.zustand");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private String
				 _name
				= new String
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.dauerzaehlstelle.attribute.AttBaustellenStatus
				 _status
				;
				private 	Zeitstempel
				 _start
				;
				private 	Zeitstempel
				 _ende
				;
				@Defaultwert(wert = "")
				private String
				 _bemerkung
				= new String
				()
				;
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@return der Wert von Name.
			*/
				public String
				 getName() {
				return _name;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@param _name der neue Wert von Name.
			*/
			public void setName(String
			 _name) {
				if (_name.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._name = _name;
			}
		
			/**
			Kennungen fuer den Baustellenstatus einer Dauerzählstelle.
			<p>
			
			</p>
			
			@return der Wert von Status.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.dauerzaehlstelle.attribute.AttBaustellenStatus
				 getStatus() {
				return _status;
			}
		
			/**
			Kennungen fuer den Baustellenstatus einer Dauerzählstelle.
			<p>
			
			</p>
			
			@param _status der neue Wert von Status.
			*/
			public void setStatus(de.bsvrz.sys.funclib.bitctrl.modell.dauerzaehlstelle.attribute.AttBaustellenStatus
			 _status) {
				this._status = _status;
			}
		
			/**
			Zeitstempel.
			<p>
			Der Zeitstempel wird z.B.im Zusammenhang von"gültigAb" und"nichtMehrGültigAb" in der Tabelle für die dynamischen Objekte (z.B.
			                    Staus) benutzt.
			</p>
			
			@return der Wert von Start.
			*/
				public 	Zeitstempel
				 getStart() {
				return _start;
			}
		
			/**
			Zeitstempel.
			<p>
			Der Zeitstempel wird z.B.im Zusammenhang von"gültigAb" und"nichtMehrGültigAb" in der Tabelle für die dynamischen Objekte (z.B.
			                    Staus) benutzt.
			</p>
			
			@param _start der neue Wert von Start.
			*/
			public void setStart(	Zeitstempel
			 _start) {
				this._start = _start;
			}
		
			/**
			Zeitstempel.
			<p>
			Der Zeitstempel wird z.B.im Zusammenhang von"gültigAb" und"nichtMehrGültigAb" in der Tabelle für die dynamischen Objekte (z.B.
			                    Staus) benutzt.
			</p>
			
			@return der Wert von Ende.
			*/
				public 	Zeitstempel
				 getEnde() {
				return _ende;
			}
		
			/**
			Zeitstempel.
			<p>
			Der Zeitstempel wird z.B.im Zusammenhang von"gültigAb" und"nichtMehrGültigAb" in der Tabelle für die dynamischen Objekte (z.B.
			                    Staus) benutzt.
			</p>
			
			@param _ende der neue Wert von Ende.
			*/
			public void setEnde(	Zeitstempel
			 _ende) {
				this._ende = _ende;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@return der Wert von Bemerkung.
			*/
				public String
				 getBemerkung() {
				return _bemerkung;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@param _bemerkung der neue Wert von Bemerkung.
			*/
			public void setBemerkung(String
			 _bemerkung) {
				if (_bemerkung.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._bemerkung = _bemerkung;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// ZeichenkettenAttributTyp
					if (getName() != null) {
						datum.getTextValue("Name").setText(getName());
					}
					// GanzzahlAttributTyp
					if (getStatus() != null) {
		                if (getStatus().isZustand()) {
		                    datum.getUnscaledValue("Status").setText(getStatus().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Status").set(getStatus().getValue());
		                }
					}
					// ZeitstempelAttributTyp
						datum.getTimeValue("Start").setMillis(getStart().getTime());
					// ZeitstempelAttributTyp
						datum.getTimeValue("Ende").setMillis(getEnde().getTime());
					// ZeichenkettenAttributTyp
					if (getBemerkung() != null) {
						datum.getTextValue("Bemerkung").setText(getBemerkung());
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// ZeichenkettenAttributTyp
						setName(daten.getTextValue("Name").getText());
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("Status").isState()) {
								setStatus(de.bsvrz.sys.funclib.bitctrl.modell.dauerzaehlstelle.attribute.AttBaustellenStatus
								.getZustand(daten.getScaledValue("Status").getText()));
							} else {
							setStatus(new de.bsvrz.sys.funclib.bitctrl.modell.dauerzaehlstelle.attribute.AttBaustellenStatus
							(daten.
								getUnscaledValue
							("Status").
									byteValue
							()));
							}
					// ZeitstempelAttributTyp
						setStart(new
							Zeitstempel
							(daten.getTimeValue("Start").getMillis()));
					// ZeitstempelAttributTyp
						setEnde(new
							Zeitstempel
							(daten.getTimeValue("Ende").getMillis()));
					// ZeichenkettenAttributTyp
						setBemerkung(daten.getTextValue("Bemerkung").getText());
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setName(getName());
							klon.setStatus(getStatus());
							klon.setStart(getStart());
							klon.setEnde(getEnde());
							klon.setBemerkung(getBemerkung());
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.baustellenStatus";

	/**
	 * Initialisiert den Onlinedatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public OdBaustellenStatus(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
