/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Dummy-Attributliste als Platzhalter (muss noch ausgetauscht werden).
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlDummy implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttDummy
			 _dummy
			;
	
		/**
		Dummy-Attribut als Platzhalter (muss noch ausgetauscht werden).
		<p>
		
		</p>
		
		@return der Wert von Dummy.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttDummy
			 getDummy() {
			return _dummy;
		}
	
		/**
		Dummy-Attribut als Platzhalter (muss noch ausgetauscht werden).
		<p>
		
		</p>
		
		@param _dummy der neue Wert von Dummy.
		*/
		public void setDummy(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttDummy
		 _dummy) {
			this._dummy = _dummy;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// GanzzahlAttributTyp
				if (getDummy() != null) {
	                if (getDummy().isZustand()) {
	                    datum.getUnscaledValue("dummy").setText(getDummy().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("dummy").set(getDummy().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("dummy").isState()) {
							setDummy(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttDummy
							.getZustand(daten.getScaledValue("dummy").getText()));
						} else {
						setDummy(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttDummy
						(daten.
							getUnscaledValue
						("dummy").
								byteValue
						()));
						}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlDummy clone() {
		AtlDummy klon = new AtlDummy();
		
						klon.setDummy(getDummy());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
