/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Linguistischer Term.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlLinguistischerTerm implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private String
			 _name
			= new String
			()
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttFuzzyZugehoerigkeit
			 _zugehoerigkeit
			;
	
		/**
		Name des Zustandes.
		<p>
		
		</p>
		
		@return der Wert von Name.
		*/
			public String
			 getName() {
			return _name;
		}
	
		/**
		Name des Zustandes.
		<p>
		
		</p>
		
		@param _name der neue Wert von Name.
		*/
		public void setName(String
		 _name) {
			if (_name.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._name = _name;
		}
	
		/**
		Zugehörigkeit des Zustandes.
		<p>
		
		</p>
		
		@return der Wert von Zugehoerigkeit.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttFuzzyZugehoerigkeit
			 getZugehoerigkeit() {
			return _zugehoerigkeit;
		}
	
		/**
		Zugehörigkeit des Zustandes.
		<p>
		
		</p>
		
		@param _zugehoerigkeit der neue Wert von Zugehoerigkeit.
		*/
		public void setZugehoerigkeit(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttFuzzyZugehoerigkeit
		 _zugehoerigkeit) {
			this._zugehoerigkeit = _zugehoerigkeit;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
				if (getName() != null) {
					datum.getTextValue("Name").setText(getName());
				}
				// GanzzahlAttributTyp
				if (getZugehoerigkeit() != null) {
	                if (getZugehoerigkeit().isZustand()) {
	                    datum.getUnscaledValue("Zugehörigkeit").setText(getZugehoerigkeit().toString());
	                } else {
						datum.
						getScaledValue
	                	("Zugehörigkeit").set(getZugehoerigkeit().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
					setName(daten.getTextValue("Name").getText());
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Zugehörigkeit").isState()) {
							setZugehoerigkeit(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttFuzzyZugehoerigkeit
							.getZustand(daten.getScaledValue("Zugehörigkeit").getText()));
						} else {
						setZugehoerigkeit(new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AttFuzzyZugehoerigkeit
						(daten.
							getScaledValue
						("Zugehörigkeit").
							doubleValue
						()));
						}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlLinguistischerTerm clone() {
		AtlLinguistischerTerm klon = new AtlLinguistischerTerm();
		
						klon.setName(getName());
						klon.setZugehoerigkeit(getZugehoerigkeit());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
