/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Zeitauswahl im 1-Stunden Raster bis zu 12 Stunden, aber nur ganzzahlige Teiler von 24h.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AttStundenIntervallAnteile12h extends Zahl<		Byte
> {
	
	private static final long serialVersionUID = 1L;
	
	
	/**
	
	<p>
	
	</p>
	*/
	public static final AttStundenIntervallAnteile12h ZUSTAND_1__1_STUNDE = new AttStundenIntervallAnteile12h("1 Stunde", 		Byte
	.valueOf("1"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttStundenIntervallAnteile12h ZUSTAND_2__2_STUNDEN = new AttStundenIntervallAnteile12h("2 Stunden", 		Byte
	.valueOf("2"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttStundenIntervallAnteile12h ZUSTAND_3__3_STUNDEN = new AttStundenIntervallAnteile12h("3 Stunden", 		Byte
	.valueOf("3"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttStundenIntervallAnteile12h ZUSTAND_4__4_STUNDEN = new AttStundenIntervallAnteile12h("4 Stunden", 		Byte
	.valueOf("4"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttStundenIntervallAnteile12h ZUSTAND_6__6_STUNDEN = new AttStundenIntervallAnteile12h("6 Stunden", 		Byte
	.valueOf("6"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttStundenIntervallAnteile12h ZUSTAND_8__8_STUNDEN = new AttStundenIntervallAnteile12h("8 Stunden", 		Byte
	.valueOf("8"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttStundenIntervallAnteile12h ZUSTAND_12__12_STUNDEN = new AttStundenIntervallAnteile12h("12 Stunden", 		Byte
	.valueOf("12"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttStundenIntervallAnteile12h getZustand(final 		Byte
	 value) {
		for (AttStundenIntervallAnteile12h e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttStundenIntervallAnteile12h getZustand(final String value) {
		for (AttStundenIntervallAnteile12h e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttStundenIntervallAnteile12h> getZustaende() {
		List<AttStundenIntervallAnteile12h> list = new ArrayList<AttStundenIntervallAnteile12h>();
		list.add(ZUSTAND_1__1_STUNDE);
		list.add(ZUSTAND_2__2_STUNDEN);
		list.add(ZUSTAND_3__3_STUNDEN);
		list.add(ZUSTAND_4__4_STUNDEN);
		list.add(ZUSTAND_6__6_STUNDEN);
		list.add(ZUSTAND_8__8_STUNDEN);
		list.add(ZUSTAND_12__12_STUNDEN);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut StundenIntervallAnteil12h.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttStundenIntervallAnteile12h(final 		Byte
	 value) {
		super(value);
	}
	
	private AttStundenIntervallAnteile12h(final String zustand, final 		Byte
	 value) {
		super(zustand, value);
	}
	
}
