/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.ilse.objekte;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Typ, welcher einen Konfigurationsverantwortlichen für ILSE darstellt.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public interface Ilse extends de.bsvrz.sys.funclib.bitctrl.modell.KonfigurationsObjekt
	,de.bsvrz.sys.funclib.bitctrl.modell.systemmodellaoe.objekte.AutarkeOrganisationsEinheit
	
	
	
	{

	/** Die PID des Systemobjekttyps im Datenverteiler. */
	public static final String PID = "typ.ilse"; 
	
	/*
	 * Beginn Abschnitt Mengen
	 */
	
/**
Dynamische Menge mit Meldungen.
<p>

</p>

@return die Menge Meldungen oder <code>null</code>, wenn eine optionale Menge nicht versorgt ist.
*/
	AenderbareMenge<de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.objekte.Meldung> getMeldungen();

/**
Menge der ResetObjekte.
<p>

</p>

@return die Menge ResetObjekte oder <code>null</code>, wenn eine optionale Menge nicht versorgt ist.
*/
	Collection<de.bsvrz.sys.funclib.bitctrl.modell.ilse.objekte.Reset> getResetObjekte();

/**
Menge aller von PuA verwalteten Skriptobjekte.
<p>

</p>

@return die Menge PuaSkripte oder <code>null</code>, wenn eine optionale Menge nicht versorgt ist.
*/
	AenderbareMenge<de.bsvrz.sys.funclib.bitctrl.modell.tmvewprotokolleglobal.objekte.PuaSkript> getPuaSkripte();

/**
Dynamische Menge mit den definierten Simulationen.
<p>

</p>

@return die Menge Simulationen oder <code>null</code>, wenn eine optionale Menge nicht versorgt ist.
*/
	AenderbareMenge<de.bsvrz.sys.funclib.bitctrl.modell.tmvewsimulationglobal.objekte.Simulation> getSimulationen();

/**
Dynamische Menge mit definierten Ereignistypen.
<p>

</p>

@return die Menge EreignisTypen oder <code>null</code>, wenn eine optionale Menge nicht versorgt ist.
*/
	AenderbareMenge<de.bsvrz.sys.funclib.bitctrl.modell.tmereigniskalenderglobal.objekte.EreignisTyp> getEreignisTypen();

/**
Dynamische Menge mit den definierten Simulationsstrecken.
<p>

</p>

@return die Menge SimulationsStrecken oder <code>null</code>, wenn eine optionale Menge nicht versorgt ist.
*/
	AenderbareMenge<de.bsvrz.sys.funclib.bitctrl.modell.tmvewsimulationglobal.objekte.SimulationsStrecke> getSimulationsStrecken();

/**
Dynamische Menge mit definierten Ereignissen.
<p>

</p>

@return die Menge Ereignisse oder <code>null</code>, wenn eine optionale Menge nicht versorgt ist.
*/
	AenderbareMenge<de.bsvrz.sys.funclib.bitctrl.modell.tmereigniskalenderglobal.objekte.Ereignis> getEreignisse();

/**
Dynamische Menge mit definierten
						Systemkalendereinträgen.
<p>

</p>

@return die Menge SystemKalenderEintraege oder <code>null</code>, wenn eine optionale Menge nicht versorgt ist.
*/
	AenderbareMenge<de.bsvrz.sys.funclib.bitctrl.modell.tmsystemkalenderglobal.objekte.SystemKalenderEintrag> getSystemKalenderEintraege();


	/*
	 * Ende Abschnitt Mengen
	 */

	/*
	 * Beginn Abschnitt Attributgruppen
	 */

	/**
	Attributgruppe zur Übertragung von Nachrichten die zur Abwicklung von Archivanfragen dienen.
	<p>
	&lt;absatz&gt;
							Wird vom streambasierten Archivanfragemechanismus für die Übertragung von Anfragen und entsprechende Antworten zwischen der
							Archivanfragebibliothek (innerhalb von Applikationen) und dem Archivsystem benutzt. Außerdem wird diese Attributgruppe für
							Steuerungsnachrichten insbesondere zur Flußkontrolle bei der streambasierten Übertragung von Archivantworten benutzt.
						&lt;&#47;absatz&gt;
	</p>
	@return der Datensatz ArchivAnfrageSchnittstelle.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.onlinedaten.OdArchivAnfrageSchnittstelle getOdArchivAnfrageSchnittstelle();
	
	/**
	Attributgruppe zum Auslösen von einmaligen Parameteraustauschen.
	<p>
	
	</p>
	@return der Datensatz TriggerKExDaV.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellkexdav.onlinedaten.OdTriggerKExDaV getOdTriggerKExDaV();
	
	/**
	Attributgruppe zur Speicherung von Eigenschaften von Konfigurationsbereichen.
	<p>
	
	</p>
	@return der Datensatz KonfigurationsVerantwortlicherEigenschaften.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdKonfigurationsVerantwortlicherEigenschaften getKdKonfigurationsVerantwortlicherEigenschaften();
	
	/**
	Attributgruppe zur Speicherung von beschreibenden Informationen zu einem Objekt.
	<p>
	
	</p>
	@return der Datensatz Info.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdInfo getKdInfo();
	
	/**
	Parametersatz zur Zuordnung von Dynamischen Objekttypen zu Konfigurationsbereichen zur Verwaltung Dynamischer Objekte.
	<p>
	
	</p>
	@return der Datensatz VerwaltungDynamischerObjekte.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.parameter.PdVerwaltungDynamischerObjekte getPdVerwaltungDynamischerObjekte();
	
	/**
	Attributgruppe zur Uebertragung von Nachrichten die zur Abwicklung von PuA Anfragen dienen.
	<p>
	
	</p>
	@return der Datensatz PuaProtokollAnfrageSchnittstelle.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmvewprotokolleglobal.onlinedaten.OdPuaProtokollAnfrageSchnittstelle getOdPuaProtokollAnfrageSchnittstelle();
	
	/**
	Zur Übermittlung von Ereignisanfragen an den Ereigniskalender.
	<p>
	
	</p>
	@return der Datensatz EreignisKalenderAnfrage.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmereigniskalenderglobal.onlinedaten.OdEreignisKalenderAnfrage getOdEreignisKalenderAnfrage();
	
	/**
	Allgemeine Einstellungen zum Persistenzmodul.
	<p>
	&lt;absatz&gt;Dieser Parameter fasst folgende Einstellung des Persistenzmoduls zusammen:&lt;&#47;absatz&gt;
						&lt;liste zeichen="punkt"&gt;
							&lt;listenPunkt&gt;Puffergröße des Containers&lt;&#47;listenPunkt&gt;
							&lt;listenPunkt&gt;Maximale Pufferzeit&lt;&#47;listenPunkt&gt;
						&lt;&#47;liste&gt;
	</p>
	@return der Datensatz ArchivContainerPersistenzEinstellung.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.parameter.PdArchivContainerPersistenzEinstellung getPdArchivContainerPersistenzEinstellung();
	
	/**
	Attributgruppe zur Publikation des freien Festplatten-Speicherplatzes des Archivsystems.
	<p>
	
	</p>
	@return der Datensatz ArchivSpeicherplatz.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.onlinedaten.OdArchivSpeicherplatz getOdArchivSpeicherplatz();
	
	/**
	Repräsentiert die globalen, netzweiten Einstellungen für alle Benutzer.
	<p>
	Erfüllt TBuV-30.
	</p>
	@return der Datensatz GlobaleEinstellungenOberflaecheNetzweit.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmbuvglobal.parameter.PdGlobaleEinstellungenOberflaecheNetzweit getPdGlobaleEinstellungenOberflaecheNetzweit();
	
	/**
	Attributgruppe zum Speichern von Logbucheinträgen.
	<p>
	
	</p>
	@return der Datensatz IlseLogbuch.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.ilse.onlinedaten.OdIlseLogbuch getOdIlseLogbuch();
	
	/**
	Schnittstelle für Anfragen und Antworten an die Parametrierung.
	<p>
	
	</p>
	@return der Datensatz ParametrierungSchnittstelle.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.onlinedaten.OdParametrierungSchnittstelle getOdParametrierungSchnittstelle();
	
	/**
	Schnittstelle für Anfragen an die Parametrierung.
	<p>
	&lt;absatz&gt;
							Über Online-Datensätze dieser Attributgruppe können Anfragen an die Parametrierung gestellt werden, die von dieser über
							Datensätze der Attributgruppe atg.parametrierungsAntwort beantwortet werden.
						&lt;&#47;absatz&gt;
	</p>
	@return der Datensatz ParametrierungsAnfrage.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.onlinedaten.OdParametrierungsAnfrage getOdParametrierungsAnfrage();
	
	/**
	Zur Übermittlung von Archiv-Anfragen an die Datenhaltung.
	<p>
	
	</p>
	@return der Datensatz ArchivAnfrage.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.onlinedaten.OdArchivAnfrage getOdArchivAnfrage();
	
	/**
	Enthält die Parameter zum endgültigen Löschen.
	<p>
	&lt;absatz&gt;
							Ein Parameterdatensatz dieser Attributgruppe enthält globale Einstellungen und spezifische
							Einstellungen für verschiedene Datenspezifikationen (Objekte, ATG, ASP, SimulationsVariante)
							zum endgültigen Löschen.
						&lt;&#47;absatz&gt;
	</p>
	@return der Datensatz ArchivDatenEndgueltigLoeschen.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.parameter.PdArchivDatenEndgueltigLoeschen getPdArchivDatenEndgueltigLoeschen();
	
	/**
	Attributgruppe zur Übertragung von Nachrichten die zur Abwicklung von Konfigurationsanfragen dienen. Die Schnittstelle ermöglicht es, die
						Konfiguration zu beauftragen die Benutzer der Konfiguration zu verwalten.
	<p>
	Wird für die Übertragung von Anfragen und entsprechende Antworten zwischen der Konfigurationsanfragebibliothek (innerhalb von Applikationen)
						und der Konfiguration benutzt. Anfragen an eine Konfiguration werden an den zugeordneten Konfigurationsverantwortlichen adressiert.
						Antworten der Konfiguration werden an die anfragende Applikation adressiert. Die Konfigurations kann über diese Schnittstelle angewiesen
						werden neue Benutzer anzulegen, Einmal-Passwörter zu erzeugen, Rechte festzulegen, Benutzerpasswörter zu ändern, usw.. Die meisten Aufträge,
						die erteilt werden können, bedürfen spezieller Rechte oder dürfen nur durch den jeweiligen Benutzer&#47;Admin (Passwort ändern) durchgeführt
						werden Die Konfiguration wird nach empfang eines Auftrags erst prüfen, ob der Benutzer, der den Auftrag erteilt hat, diese speziellen Rechte
						besitzt.
	</p>
	@return der Datensatz KonfigurationsBenutzerverwaltungsAnfrageSchnittstelle.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.onlinedaten.OdKonfigurationsBenutzerverwaltungsAnfrageSchnittstelle getOdKonfigurationsBenutzerverwaltungsAnfrageSchnittstelle();
	
	/**
	Attributgruppe zur Publikation der Zustände von Hintergrund-Tasks einer Applikation.
	<p>
	
	</p>
	@return der Datensatz HintergrundTaskZustaende.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.onlinedaten.OdHintergrundTaskZustaende getOdHintergrundTaskZustaende();
	
	/**
	Zur Übermittlung von Verwaltungsanfragen für Simulationen.
	<p>
	
	</p>
	@return der Datensatz SimulationVerwaltungAnfrage.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmvewsimulationglobal.onlinedaten.OdSimulationVerwaltungAnfrage getOdSimulationVerwaltungAnfrage();
	
	/**
	Zur Übermittlung von Anfragen an die Konfiguration.
	<p>
	
	</p>
	@return der Datensatz KonfigurationsAnfrage.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.onlinedaten.OdKonfigurationsAnfrage getOdKonfigurationsAnfrage();
	
	/**
	Attributgruppe zur Speicherung von Default-Parameterdatensätzen für alle Parameter-Attributgruppen eines Typs.
	<p>
	
	</p>
	@return der Datensatz DefaultParameterdatensaetze.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdDefaultParameterdatensaetze getKdDefaultParameterdatensaetze();
	
	/**
	Zur Übermittlung von Änderungsanfragen an die Konfiguration.
	<p>
	
	</p>
	@return der Datensatz KonfigurationsSchreibAnfrage.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.onlinedaten.OdKonfigurationsSchreibAnfrage getOdKonfigurationsSchreibAnfrage();
	
	/**
	Allgemeine Einstellungen zum Archivsystem.
	<p>
	&lt;absatz&gt;Dieser Parameter fasst folgende Einstellung des Archivsystems zusammen:&lt;&#47;absatz&gt;
						&lt;liste zeichen="punkt"&gt;
							&lt;listenPunkt&gt;Maximaler Archivzeitsprung vorwärts T
								&lt;tief&gt;max&lt;&#47;tief&gt;
							&lt;&#47;listenPunkt&gt;
							&lt;listenPunkt&gt;Sicherungsintervall&lt;&#47;listenPunkt&gt;
							&lt;listenPunkt&gt;Löschintervall&lt;&#47;listenPunkt&gt;
							&lt;listenPunkt&gt;Nachforderungsintervall&lt;&#47;listenPunkt&gt;
							&lt;listenPunkt&gt;Spontanes Löschen&lt;&#47;listenPunkt&gt;
							&lt;listenPunkt&gt;Löschschutz&lt;&#47;listenPunkt&gt;
							&lt;listenPunkt&gt;Anzahl Bytes, die pro Anfrage zur Pufferung genutzt werden können&lt;&#47;listenPunkt&gt;
							&lt;listenPunkt&gt;Maximale Anzahl der noch nicht quittierten übertragenen Blöcke pro Stream&lt;&#47;listenPunkt&gt;
							&lt;listenPunkt&gt;Anzahl parallel zu beantwortener Archivanfragen hoher Priorität&lt;&#47;listenPunkt&gt;
							&lt;listenPunkt&gt;Anzahl parallel zu beantwortener Archivanfragen mittlerer Priorität&lt;&#47;listenPunkt&gt;
							&lt;listenPunkt&gt;Anzahl parallel zu beantwortener Archivanfragen niedriger Priorität&lt;&#47;listenPunkt&gt;
						&lt;&#47;liste&gt;
	</p>
	@return der Datensatz ArchivEinstellung.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.parameter.PdArchivEinstellung getPdArchivEinstellung();
	
	/**
	Attributgruppe zur Übertragung von Nachrichten die zur Abwicklung von Konfigurationsanfragen dienen. Die Schnittstelle ermöglicht es, die
						Konfiguration zu beauftragen bestimmte Objekt in der Konfigurations zu ändern.
	<p>
	Wird für die Übertragung von Anfragen und entsprechende Antworten zwischen der Konfigurationsanfragebibliothek (innerhalb von Applikationen)
						und der Konfiguration benutzt. Anfragen an eine Konfiguration werden an den zugeordneten Konfigurationsverantwortlichen adressiert.
						Antworten der Konfiguration werden an die anfragende Applikation adressiert. Auf alle Objekte der Konfiguration kann nur schreibend
						zugegriffen werden.
	</p>
	@return der Datensatz KonfigurationsAnfrageSchnittstelleSchreibend.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.onlinedaten.OdKonfigurationsAnfrageSchnittstelleSchreibend getOdKonfigurationsAnfrageSchnittstelleSchreibend();
	
	/**
	Attributgruppe für KExDav-Parameter.
	<p>
	
	</p>
	@return der Datensatz SpezifikationKExDaV.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellkexdav.parameter.PdSpezifikationKExDaV getPdSpezifikationKExDaV();
	
	/**
	Attributgruppe zur Übertragung von Nachrichten die zur Abwicklung von Konfigurationsanfragen dienen. Die Schnittstelle ermöglicht es, die
						Konfiguration zu beauftragen die Konfigurationsbereiche der Konfigurations zu verwalten.
	<p>
	Wird für die Übertragung von Anfragen und entsprechende Antworten zwischen der Konfigurationsanfragebibliothek (innerhalb von Applikationen)
						und der Konfiguration benutzt. Anfragen an eine Konfiguration werden an den zugeordneten Konfigurationsverantwortlichen adressiert.
						Antworten der Konfiguration werden an die anfragende Applikation adressiert. Die Konfiguration kann über diese Schnittstelle angewiesen
						werden Konfigurationsbereiche in einer neuen Version zu aktivieren, Konsistenzprüfungen durchzuführen, Konfigurationsbereiche zur übernahme
						freizugeben, usw..
	</p>
	@return der Datensatz KonfigurationsBereichsverwaltungsAnfrageSchnittstelle.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.onlinedaten.OdKonfigurationsBereichsverwaltungsAnfrageSchnittstelle getOdKonfigurationsBereichsverwaltungsAnfrageSchnittstelle();
	
	/**
	Verwaltet bis zu zehn alternative Bezeichnungen.
	<p>
	
	</p>
	@return der Datensatz AlternativeObjektbezeichnung.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdAlternativeObjektbezeichnung getKdAlternativeObjektbezeichnung();
	
	/**
	Beinhaltet die Parameter für die EngstellenVerwaltung.
	<p>
	&lt;absatz&gt;Beinhaltet die Parameter für die EngstellenVerwaltung.&lt;&#47;absatz&gt;
	</p>
	@return der Datensatz EngstellenVerwaltungParameter.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmvewengstellenglobal.parameter.PdEngstellenVerwaltungParameter getPdEngstellenVerwaltungParameter();
	
	/**
	Repräsentiert die Oberfächenberechtigung, wie sie vom Rahmenwerk gemäß TBuV 103 - TBuV 105 benötigt wird.
	<p>
	
	</p>
	@return der Datensatz OberflaechenBerechtigung.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmbuvglobal.parameter.PdOberflaechenBerechtigung getPdOberflaechenBerechtigung();
	
	/**
	Attributgruppe zur Übertragung von Nachrichten die zur Abwicklung von Konfigurationsanfragen dienen.
	<p>
	Wird für die Übertragung von Anfragen und entsprechende Antworten zwischen der Konfigurationsanfragebibliothek (innerhalb von Applikationen)
						und der Konfiguration benutzt. Anfragen an eine Konfiguration werden an den zugeordneten Konfigurationsverantwortlichen adressiert.
						Antworten der Konfiguration werden an die anfragende Applikation adressiert.
	</p>
	@return der Datensatz KonfigurationsAnfrageSchnittstelle.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.onlinedaten.OdKonfigurationsAnfrageSchnittstelle getOdKonfigurationsAnfrageSchnittstelle();
	
	/**
	Repräsentiert die netzweiten Einstellungen für einen Benutzer.
	<p>
	Erfüllt TBuV-30.
	</p>
	@return der Datensatz BenutzerEinstellungenOberflaecheNetzweit.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmbuvglobal.parameter.PdBenutzerEinstellungenOberflaecheNetzweit getPdBenutzerEinstellungenOberflaecheNetzweit();
	
	/**
	Repräsentiert eine Liste von Rahmenwerkeinstellungen, die an einem Oberflächenobjekt oder einem 
	                    Benutzer definiert werden können.
	<p>
	
	</p>
	@return der Datensatz RahmenwerkEinstellungen.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmbuvglobal.parameter.PdRahmenwerkEinstellungen getPdRahmenwerkEinstellungen();
	
	/**
	Statusinformation Archiv für die Simulation.
	<p>
	
	</p>
	@return der Datensatz SimulationsStatusArchiv.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmvewsimulationglobal.onlinedaten.OdSimulationsStatusArchiv getOdSimulationsStatusArchiv();
	
	/**
	Attributgruppe zur Festlegung der Parameter für die formale Plausibilitätsprüfung.
	<p>
	
	</p>
	@return der Datensatz PlausibilitaetsPruefungFormal.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.parameter.PdPlausibilitaetsPruefungFormal getPdPlausibilitaetsPruefungFormal();
	
	/**
	Attributgruppe zur Übertragung von Nachrichten die zur Abwicklung von Konfigurationsanfragen dienen. Die Schnittstelle ermöglicht nur
						lesenden Zugriff auf die Konfiguration.
	<p>
	Wird für die Übertragung von Anfragen und entsprechende Antworten zwischen der Konfigurationsanfragebibliothek (innerhalb von Applikationen)
						und der Konfiguration benutzt. Anfragen an eine Konfiguration werden an den zugeordneten Konfigurationsverantwortlichen adressiert.
						Antworten der Konfiguration werden an die anfragende Applikation adressiert. Auf alle Objekte der Konfiguration kann nur lesen zugegriffen
						werden, es kann keine Änderung in der Konfigurations angestoßen werden.
	</p>
	@return der Datensatz KonfigurationsAnfrageSchnittstelleLesend.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.onlinedaten.OdKonfigurationsAnfrageSchnittstelleLesend getOdKonfigurationsAnfrageSchnittstelleLesend();
	
	/**
	Beinhaltet alle Merkmale, die eine Betriebsmeldung ausmachen.
	<p>
	&lt;absatz&gt;Fast alle Funktionen des Systems setzen in bestimmten Situationen (i.d.R. beim Auftreten von Fehlern und sonstigen Ausnahmefällen), die ein Eingreifen durch den Operator nötig machen, zusätzlich zur normalen Protokollierung des entsprechenden Ereignisses eine (quittierungspflichtige) Meldung an das Bedienpersonal ab. Diese Meldungen werden zusätzlich in einem einheitlichen Format generiert und zentral verwaltet. Die Quittierung und Manipulation (Ergänzung um Kommentare etc.) dieser (Fehler-)Meldungen erfolgt ausschließlich auf Basis dieser zusätzlich erzeugten Meldungen.&lt;&#47;absatz&gt;
	</p>
	@return der Datensatz BetriebsMeldung.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.onlinedaten.OdBetriebsMeldung getOdBetriebsMeldung();
	
	/**
	Globale Modellparameter für das automatische Lernen von Ganglinien.
	<p>
	
	</p>
	@return der Datensatz GanglinienModellAutomatischesLernen.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.parameter.PdGanglinienModellAutomatischesLernen getPdGanglinienModellAutomatischesLernen();
	
	/**
	Attributgruppe zur Spezifikation von Anfragen an die Ganglinineprognose.
	<p>
	
	</p>
	@return der Datensatz PrognoseGanglinienAnfrage.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.onlinedaten.OdPrognoseGanglinienAnfrage getOdPrognoseGanglinienAnfrage();
	
	/**
	Parametrierbare Eigenschaften einer Melddung.
	<p>
	
	</p>
	@return der Datensatz MeldungsBearbeitung.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.onlinedaten.OdMeldungsBearbeitung getOdMeldungsBearbeitung();
	
	/**
	Enthält die Parameter für die Datenspezifikationen (Objekte, ATG, ASP, SimulationsVariante) und Einstellungen, mit der die
						Archivierung parametriert wird.
	<p>
	&lt;absatz&gt;Potentiell können durch das Archivsystem alle im System durch die Applikationen bereitgestellten Daten archiviert werden. Welche
							Daten tatsächlich archiviert werden sollen, ist online parametrierbar. Zur Spezifikation, welche Daten archiviert werden sollen, müssen
							folgende Angaben gemacht werden:
						&lt;&#47;absatz&gt;
						&lt;liste zeichen="punkt"&gt;
							&lt;listenPunkt&gt;Angabe der Konfigurationsobjekte, zu denen Datensätze archiviert werden sollen&lt;&#47;listenPunkt&gt;
							&lt;listenPunkt&gt;Angabe der Attributgruppen&#47;Aspektkombinationen und Simulationsvariante&lt;&#47;listenPunkt&gt;
							&lt;listenPunkt&gt;Angabe der Archivierungseinstellungen&lt;&#47;listenPunkt&gt;
						&lt;&#47;liste&gt;
						&lt;absatz&gt;Der hierfür notwendige Parametersatz weist eine flexible Struktur auf, die es ermöglicht, neben ganz konkreten Spezifikationen, zu
							welchem Konfigurationsobjekt die Datensätze welcher Attributgruppen&#47;Aspektkombination archiviert werden sollen, "flächendeckende"
							Angaben zu tätigen, um den Parametrierungsaufwand zu minimieren.
						&lt;&#47;absatz&gt;
						&lt;liste zeichen="punkt"&gt;
							&lt;listenPunkt&gt;Attributliste "ParameterSatz [..]"&lt;&#47;listenPunkt&gt;
						&lt;&#47;liste&gt;
						&lt;absatz&gt;Diese Attributliste dient zur Zusammenfassung einer (Teil)Spezifikation, zu welchen Konfigurationsobjekten welche Datensätze unter
							welchen Einstellungen archiviert werden sollen. Die Attributgruppe zur Parametrierung des Archivsystems besteht aus einem Feld mit
							beliebig vielen dieser Attributlisten.
						&lt;&#47;absatz&gt;
						&lt;liste zeichen="punkt"&gt;
							&lt;listenPunkt&gt;Attribut "Bereich [..]"&lt;&#47;listenPunkt&gt;
						&lt;&#47;liste&gt;
						&lt;absatz&gt;Die in der folgenden Attributliste "Datenspezifikation" befindlichen Objekte beziehen sich auf einen in diesem Feld angegebenen
							Konfigurationsbereich.
						&lt;&#47;absatz&gt;
						&lt;liste zeichen="punkt"&gt;
							&lt;listenPunkt&gt;Attributliste "DatenSpezifikation [..]"&lt;&#47;listenPunkt&gt;
						&lt;&#47;liste&gt;
						&lt;absatz&gt;Mit dieser Attributliste wird spezifiziert, für welche Tupel bestehend aus Konfigurationsobjekt, Attributgruppe und Aspekt die
							folgenden Einstellungen gelten. Diese Attributliste kann innerhalb der Attributliste "Archivsystem Parameter" beliebig oft enthalten
							sein.
						&lt;&#47;absatz&gt;
						&lt;liste zeichen="punkt"&gt;
							&lt;listenPunkt&gt;Attribut "Objekte [..]"&lt;&#47;listenPunkt&gt;
						&lt;&#47;liste&gt;
						&lt;absatz&gt;Mit diesem Attribut können beliebig viele Konfigurationsobjekte angegeben werden, für die Datensätze archiviert werden sollen. Die
							Spezifikation der gewünschten Konfigurationsobjekte erfolgt über die direkte Angabe von einzelnen Konfigurationsobjekten (z.B. über die
							PID), über die Angabe einer Menge (z.B. Menge der MQ) oder durch die Angabe von Typen (z.B. Typ MQ). Bei der Angabe von Objekttypen
							werden alle Konfigurationsobjekte dieses Typs aus den Konfigurationsbereichen ausgewählt, die über das Attribut "Bereich" spezifiziert
							wurden.
						&lt;&#47;absatz&gt;
						&lt;liste zeichen="punkt"&gt;
							&lt;listenPunkt&gt;Attribut "AttributGruppe [..]"&lt;&#47;listenPunkt&gt;
						&lt;&#47;liste&gt;
						&lt;absatz&gt;Mit diesem Attribut werden die Attributgruppen spezifiziert, die für die ausgewählten Konfigurationsobjekte archiviert werden
							sollen.
						&lt;&#47;absatz&gt;
						&lt;liste zeichen="punkt"&gt;
							&lt;listenPunkt&gt;Attribut "Aspekt [..]"&lt;&#47;listenPunkt&gt;
						&lt;&#47;liste&gt;
						&lt;absatz&gt;Mit diesem Attribut werden die Aspekte spezifiziert, unter denen die angegebenen Attributgruppen für die ausgewählten
							Konfigurationsobjekte archiviert werden sollen.
						&lt;&#47;absatz&gt;
						&lt;liste zeichen="punkt"&gt;
							&lt;listenPunkt&gt;Attribut "SimulationsVariante [..]"&lt;&#47;listenPunkt&gt;
						&lt;&#47;liste&gt;
						&lt;absatz&gt;Mit diesem Attribut werden die Simulationsvarianten spezifiziert, unter denen die angegebenen Attributgruppen unter den angegebenen
							Aspekten für die ausgewählten Konfigurationsobjekte archiviert werden sollen.
						&lt;&#47;absatz&gt;
						&lt;liste zeichen="punkt"&gt;
							&lt;listenPunkt&gt;Attributliste "Einstellungen [..]"&lt;&#47;listenPunkt&gt;
						&lt;&#47;liste&gt;
						&lt;absatz&gt;Diese Attributliste fasst die "eigentlichen" Parameter, wie die gemäß Datenspezifikation zu archivierenden Datensätze zu behandeln
							sind, zusammen.
						&lt;&#47;absatz&gt;
						&lt;liste zeichen="punkt"&gt;
							&lt;listenPunkt&gt;Attribut "Archivieren"&lt;&#47;listenPunkt&gt;
						&lt;&#47;liste&gt;
						&lt;absatz&gt;Mit diesem Attribut wird angegeben, ob die entsprechenden Daten zu archivieren sind ("Ja" oder "Nein"). Wird an dieser Stelle "Nein"
							angegeben, sind die weiteren Attribute der Attributliste "Einstellungen" obsolet.
						&lt;&#47;absatz&gt;
						&lt;liste zeichen="punkt"&gt;
							&lt;listenPunkt&gt;Attribut "Nachfordern [..]"&lt;&#47;listenPunkt&gt;
						&lt;&#47;liste&gt;
						&lt;absatz&gt;Mit diesem Attribut wird angegeben, ob Daten bei potentiell erkannter Datenlücken von anderen Archivsystemen nachgefordert werden
							sollen. Das Attribut stellt ein Array dar, in dem die Archivsysteme aufgeführt sind, bei denen nachgefragt werden soll.
						&lt;&#47;absatz&gt;
						&lt;liste zeichen="punkt"&gt;
							&lt;listenPunkt&gt;Attribut "Sichern"&lt;&#47;listenPunkt&gt;
						&lt;&#47;liste&gt;
						&lt;absatz&gt;Mit diesem Attribut wird angegeben, ob die entsprechenden Daten zu sichern sind ("Ja" oder "Nein").&lt;&#47;absatz&gt;
						&lt;liste zeichen="punkt"&gt;
							&lt;listenPunkt&gt;Attribut "Quittieren"&lt;&#47;listenPunkt&gt;
						&lt;&#47;liste&gt;
						&lt;absatz&gt;Mit diesem Attribut wird angegeben, ob die entsprechenden Daten zu quittieren sind. In diesem Fall wird an dieser Stelle der Aspekt
							spezifiziert, unter dem die entsprechenden Attributgruppen nach erfolgreicher Archivierung publiziert werden.
						&lt;&#47;absatz&gt;
						&lt;liste zeichen="punkt"&gt;
							&lt;listenPunkt&gt;Attribut "Vorhalten"&lt;&#47;listenPunkt&gt;
						&lt;&#47;liste&gt;
						&lt;absatz&gt;Mit diesem Attribut wird spezifiziert, wie lange sich die zu archivierenden Datensätze im direkten Zugriff des Archivsystems
							befinden sollen. Bei der Datenspezifikation mit der Attributliste werden die Objekte, Attributgruppen und Aspekte in voneinander
							unabhängigen Feldern spezifiziert. Für jede Kombination der Angabe in den drei Feldern gelten die in der Attributliste Einstellungen
							vorgegebenen Parameter. Dabei ist zu beachten, dass nur sinnvolle Kombinationen betrachtet werden; d.h. es werden natürlich nur die
							Attributgruppen&#47;Aspektkombinationen für ein Konfigurationsobjekt angemeldet, die laut Konfiguration bei einem Konfigurationsobjekt des
							entsprechenden Typs möglich sind. Weiter ist zu beachten, dass durch die Auslegung der Attributliste "Archivsystem Parameter" als Feld
							eine Überlagerung von gleichen Tupeln möglich ist. In diesem Fall setzt sich die Spezifikation im Datensatz mit dem höchsten Feldindex
							durch.
						&lt;&#47;absatz&gt;
	</p>
	@return der Datensatz Archiv.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.parameter.PdArchiv getPdArchiv();
	
	/**
	Speichert die Laufende Nummer des KonfigurationsVerantwortlichen.
	<p>
	
	</p>
	@return der Datensatz KonfigurationsVerantwortlicherLaufendeNummer.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdKonfigurationsVerantwortlicherLaufendeNummer getKdKonfigurationsVerantwortlicherLaufendeNummer();
	
	/**
	Enthält die Parameter für die Datenspezifikationen (Objekte, ATG, ASP, SimulationsVariante) und Einstellungen, mit der die
						Parametrierung parametriert wird.
	<p>
	&lt;absatz&gt;Potentiell kann die Parametrierapplikation alle im System vorhandenen Paramterdaten Daten verwalten. .Für welche Daten eine
							Parametrierapplikation aber tatsächlich zuständig ist, ist online parametrierbar. Zur Spezifikation, welche Daten archiviert werden
							sollen, müssen folgende Angaben gemacht werden:
						&lt;&#47;absatz&gt;
						&lt;liste zeichen="punkt"&gt;
							&lt;listenPunkt&gt;Angabe der Konfigurationsobjekte, zu denen Parameterdatensätze verwaltet werden sollen&lt;&#47;listenPunkt&gt;
							&lt;listenPunkt&gt;Angabe der Attributgruppen&#47;Aspektkombinationen und Simulationsvariante&lt;&#47;listenPunkt&gt;
							&lt;listenPunkt&gt;Angabe der Parametrierungseinstellungen&lt;&#47;listenPunkt&gt;
						&lt;&#47;liste&gt;
						&lt;absatz&gt;Der hierfür notwendige Parametersatz weist eine flexible Struktur auf, die es ermöglicht, neben ganz konkreten Spezifikationen, zu
							welchem Konfigurationsobjekt die Datensätze welcher Attributgruppen&#47;Aspektkombination Parametersätze verwaltet werden sollen,
							"flächendeckende" Angaben zu tätigen, um den Parametrierungsaufwand zu minimieren.
						&lt;&#47;absatz&gt;
						&lt;liste zeichen="punkt"&gt;
							&lt;listenPunkt&gt;Attributliste "ParameterSatz [..]"&lt;&#47;listenPunkt&gt;
						&lt;&#47;liste&gt;
						&lt;absatz&gt;Diese Attributliste dient zur Zusammenfassung einer (Teil)Spezifikation, zu welchen Konfigurationsobjekten welche Datensätze unter
							welchen Einstellungen durch die Parametrierung verwaltet werden sollen. Die Attributgruppe zur Parametrierung der Parametrirung besteht
							aus einem Feld mit beliebig vielen dieser Attributlisten.
						&lt;&#47;absatz&gt;
						&lt;liste zeichen="punkt"&gt;
							&lt;listenPunkt&gt;Attribut "Bereich [..]"&lt;&#47;listenPunkt&gt;
						&lt;&#47;liste&gt;
						&lt;absatz&gt;Die in der folgenden Attributliste "Datenspezifikation" befindlichen Objekte beziehen sich auf einen in diesem Feld angegebenen
							Konfigurationsbereich.
						&lt;&#47;absatz&gt;
						&lt;liste zeichen="punkt"&gt;
							&lt;listenPunkt&gt;Attributliste "DatenSpezifikation [..]"&lt;&#47;listenPunkt&gt;
						&lt;&#47;liste&gt;
						&lt;absatz&gt;Mit dieser Attributliste wird spezifiziert, für welche Tupel bestehend aus Konfigurationsobjekt, Attributgruppe und Aspekt die
							folgenden Einstellungen gelten. Diese Attributliste kann innerhalb der Attributliste "ParameterSatz" beliebig oft enthalten
							sein.
						&lt;&#47;absatz&gt;
						&lt;liste zeichen="punkt"&gt;
							&lt;listenPunkt&gt;Attribut "Objekte [..]"&lt;&#47;listenPunkt&gt;
						&lt;&#47;liste&gt;
						&lt;absatz&gt;Mit diesem Attribut können beliebig viele Konfigurationsobjekte angegeben werden, für die Datensätze von der Parametrierung
							verwaltet werden sollen. Die Spezifikation der gewünschten Konfigurationsobjekte erfolgt über die direkte Angabe von einzelnen
							Konfigurationsobjekten (z.B. über die PID), über die Angabe einer Menge (z.B. Menge der MQ) oder durch die Angabe von Typen (z.B. Typ
							MQ). Bei der Angabe von Objekttypen werden alle Konfigurationsobjekte dieses Typs aus den Konfigurationsbereichen ausgewählt, die über
							das Attribut "Bereich" spezifiziert wurden.
						&lt;&#47;absatz&gt;
						&lt;liste zeichen="punkt"&gt;
							&lt;listenPunkt&gt;Attribut "AttributGruppe [..]"&lt;&#47;listenPunkt&gt;
						&lt;&#47;liste&gt;
						&lt;absatz&gt;Mit diesem Attribut werden die Attributgruppen spezifiziert, die für die ausgewählten Konfigurationsobjekte durch die Parametrierung
							verwaltet werden sollen.
						&lt;&#47;absatz&gt;
						&lt;liste zeichen="punkt"&gt;
							&lt;listenPunkt&gt;Attribut "SimulationsVariante [..]"&lt;&#47;listenPunkt&gt;
						&lt;&#47;liste&gt;
						&lt;absatz&gt;Mit diesem Attribut werden die Simulationsvarianten spezifiziert, unter denen die angegebenen Attributgruppen unter den angegebenen
							Aspekten für die ausgewählten Konfigurationsobjekte durch die Parametrierung verwaltet werden sollen.
						&lt;&#47;absatz&gt;
						&lt;liste zeichen="punkt"&gt;
							&lt;listenPunkt&gt;Attributliste "Einstellungen [..]"&lt;&#47;listenPunkt&gt;
						&lt;&#47;liste&gt;
						&lt;absatz&gt;Diese Attributliste fasst die "eigentlichen" Parameter, wie die gemäß Datenspezifikation festgelegten Datensätze von der
							Parametrierung zu behandeln sind, zusammen.
						&lt;&#47;absatz&gt;
						&lt;liste zeichen="punkt"&gt;
							&lt;listenPunkt&gt;Attribut "Parametrieren"&lt;&#47;listenPunkt&gt;
						&lt;&#47;liste&gt;
						&lt;absatz&gt;Mit diesem Attribut wird angegeben, ob die entsprechenden Daten zu von der Parameterierung zu verwalten sind ("Ja" oder "Nein").
							Wird an dieser Stelle "Nein" angegeben, sind die weiteren Attribute der Attributliste "Einstellungen" obsolet. Die Angabe von "nein"
							kann aber insbesondere dazu verwendet werden, einzelne Datenspezifikationen gezielt nicht zu verwalten, die ansonsten wegen einer
							"globaleren" Spezifikation mit verwaltet worden wären.
						&lt;&#47;absatz&gt;
	</p>
	@return der Datensatz Parametrierung.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.parameter.PdParametrierung getPdParametrierung();
	
	/**
	Parameter zum endgültigen Löschen von historischen dynamischen Objekten und historischen Mengenreferenzen.
	<p>
	&lt;absatz&gt;
	                        Mit diesem Datensatz werden die Parameter festgelegt, die definieren, wie lange gelöschte dynamische Objekte
	                        und gelöschte Mengenelemente behalten werden. Hiermit lässt sich für verschiedene Typen von dynamischen Objekten
	                        und für verschiedene Mengentypen ein Vorhaltezeitraum vorgeben, der angibt, wie lange diese Objekte bzw. Referenzen
	                        auf jeden Fall behalten werden und für historische Anfragen weiterhin gültig bleiben.
	                    &lt;&#47;absatz&gt;
	                    &lt;absatz&gt;
	                        Objekte und Mengen, für die keine Angaben gemacht werden, bleiben unendlich lange bestehen. Spezifische Angaben
	                        haben Vorrang, sodass man beispielsweise mit "typ.dynamischesObjekt" für alle dynamischen Objekte eine Vorgabe
	                        machen kann und diese ggf. für beliebige Subtypen überschreiben kann.
	                    &lt;&#47;absatz&gt;
	                    &lt;absatz&gt;
	                        Im Fall der Mehrfachvererbung wird der Supertyp berücksichtigt, der den längsten Vorhaltezeitraum
	                        besitzt. Wenn Typ C also von Typ A und Typ B erbt und für Typ C keine Vorgabe gemacht ist, dann müssen sowohl
	                        Typ A und Typ B direkt oder indirekt einen Vorhaltezeitraum besitzen, damit das Objekt endgültig gelöscht werden kann.
	                        In dem Fall wird der längere der beiden Vorhaltezeiträume verwendet.
	                    &lt;&#47;absatz&gt;
	                    &lt;absatz&gt;
	                        Außerdem bleiben historische dynamische Objekte auf jeden Fall mindestens so lange bestehen, wie noch
	                        gültige Objekte oder Mengen auf diese referenzieren. (Das betrifft Konfigurationsdaten oder Mengenreferenzen.
	                        Online-Daten oder Parameter werden dabei nicht berücksichtigt.)
	                    &lt;&#47;absatz&gt;
	</p>
	@return der Datensatz ParameterEndgueltigesLoeschen.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellaoe.parameter.PdParameterEndgueltigesLoeschen getPdParameterEndgueltigesLoeschen();
	
	/**
	Spezifikation einer Betriebsmeldung.
	<p>
	
	</p>
	@return der Datensatz BetriebsMeldungsVerwaltungRegel.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.parameter.PdBetriebsMeldungsVerwaltungRegel getPdBetriebsMeldungsVerwaltungRegel();
	
	/**
	Parametersatz zur Festlegung der Zustände einer Baustelle, bei der zusätzlich ein Ereignis angelegt werden soll. Wird benötigt, wenn z. B. ein externes BIS-System Baustelle anlegt und dafür auch entsprechende Ereignisse verwalten soll.
	<p>
	
	</p>
	@return der Datensatz StatusBaustelleAlsEreignis.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmsystemkalenderglobal.parameter.PdStatusBaustelleAlsEreignis getPdStatusBaustelleAlsEreignis();
	
	/**
	Ein Array von ILSE-AnschlussPunkten.
	<p>
	
	</p>
	@return der Datensatz ListeAnschlussPunkte.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.ilse.parameter.PdListeAnschlussPunkte getPdListeAnschlussPunkte();
	
	/**
	Enthält die Parameter (Anzahl der Archivdatensätze, Containergröße in Byte und den Zeitbereich), die angeben, wann ein Container des
						Archivsystems abzuschließen ist.
	<p>
	
	</p>
	@return der Datensatz ArchivContainer.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.parameter.PdArchivContainer getPdArchivContainer();
	
	/**
	Die Meldungen der Meldungsgruppe.
	<p>
	
	</p>
	@return der Datensatz MeldungsGruppeZuordnung.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.onlinedaten.OdMeldungsGruppeZuordnung getOdMeldungsGruppeZuordnung();
	
	
	/*
	 * Ende Abschnitt Attributgruppen
	 */
	 
}
