/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.ilse.objekte.impl;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Typ, welcher einen Konfigurationsverantwortlichen für ILSE darstellt.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class IlseImpl extends AbstractSystemObjekt
	implements de.bsvrz.sys.funclib.bitctrl.modell.ilse.objekte.Ilse { 

	/**
	 * Der Defaultkonstruktor wird für das Erzeugen des Systemobjekts über per
	 * Reflection-API benötigt.
	 */
	public IlseImpl() {
		// tut nix
	}
	
	/**
	 * Initialisierung.
	 * 
	 * @param objekt
	 *            ein beliebiges Systemobjekt.
	 * @param factory
	 *            die Fabrik, die das Systemobjekt angelegt hat.
	 */
	public IlseImpl(final SystemObject objekt, final ObjektFactory factory) {
		super(objekt, factory);
		
		if (!objekt.isOfType(getTyp().getPid())) {
			throw new IllegalArgumentException(
					"Systemobjekt ist kein ILSE.");
		}
	}
	
	@Override
	protected String doGetTypPid() {
		return PID;
	}
	
	/*
	 * Beginn Abschnitt Mengen
	 */
	
	private AenderbareMenge<de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.objekte.Meldung> meldungen;
	
	public AenderbareMenge<de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.objekte.Meldung> getMeldungen() {
		if (meldungen == null) {
			ConfigurationObject ko = (ConfigurationObject) getSystemObject();
			if (ko.getObjectSet("Meldungen") == null) {
				// Die Menge ist nicht konfiguriert
				return null;
			}
			meldungen = new AenderbareMenge<de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.objekte.Meldung>(getObjektFactory(), (MutableSet)ko.getObjectSet("Meldungen"), 0, 0, this);
		}
		return meldungen;
	}
	private Collection<de.bsvrz.sys.funclib.bitctrl.modell.ilse.objekte.Reset> resetObjekte;
	
	public Collection<de.bsvrz.sys.funclib.bitctrl.modell.ilse.objekte.Reset> getResetObjekte() {
		if (resetObjekte == null) {
			final Collection<de.bsvrz.sys.funclib.bitctrl.modell.ilse.objekte.Reset> menge = new ArrayList<de.bsvrz.sys.funclib.bitctrl.modell.ilse.objekte.Reset>();
			ConfigurationObject ko = (ConfigurationObject) getSystemObject();
			if (ko.getObjectSet("ResetObjekte") == null) {
				// Die Menge ist nicht konfiguriert
				return null;
			}
			for (SystemObject so : ko.getObjectSet("ResetObjekte").getElements()) {
				menge.add((de.bsvrz.sys.funclib.bitctrl.modell.ilse.objekte.Reset) getObjektFactory().getModellobjekt(so));
			}
			resetObjekte = Collections.unmodifiableCollection(menge);
		}
		return resetObjekte;
	}
	private AenderbareMenge<de.bsvrz.sys.funclib.bitctrl.modell.tmvewprotokolleglobal.objekte.PuaSkript> puaSkripte;
	
	public AenderbareMenge<de.bsvrz.sys.funclib.bitctrl.modell.tmvewprotokolleglobal.objekte.PuaSkript> getPuaSkripte() {
		if (puaSkripte == null) {
			ConfigurationObject ko = (ConfigurationObject) getSystemObject();
			if (ko.getObjectSet("PuaSkripte") == null) {
				// Die Menge ist nicht konfiguriert
				return null;
			}
			puaSkripte = new AenderbareMenge<de.bsvrz.sys.funclib.bitctrl.modell.tmvewprotokolleglobal.objekte.PuaSkript>(getObjektFactory(), (MutableSet)ko.getObjectSet("PuaSkripte"), 0, 0, this);
		}
		return puaSkripte;
	}
	private AenderbareMenge<de.bsvrz.sys.funclib.bitctrl.modell.tmvewsimulationglobal.objekte.Simulation> simulationen;
	
	public AenderbareMenge<de.bsvrz.sys.funclib.bitctrl.modell.tmvewsimulationglobal.objekte.Simulation> getSimulationen() {
		if (simulationen == null) {
			ConfigurationObject ko = (ConfigurationObject) getSystemObject();
			if (ko.getObjectSet("Simulationen") == null) {
				// Die Menge ist nicht konfiguriert
				return null;
			}
			simulationen = new AenderbareMenge<de.bsvrz.sys.funclib.bitctrl.modell.tmvewsimulationglobal.objekte.Simulation>(getObjektFactory(), (MutableSet)ko.getObjectSet("Simulationen"), 0, 0, this);
		}
		return simulationen;
	}
	private AenderbareMenge<de.bsvrz.sys.funclib.bitctrl.modell.tmereigniskalenderglobal.objekte.EreignisTyp> ereignisTypen;
	
	public AenderbareMenge<de.bsvrz.sys.funclib.bitctrl.modell.tmereigniskalenderglobal.objekte.EreignisTyp> getEreignisTypen() {
		if (ereignisTypen == null) {
			ConfigurationObject ko = (ConfigurationObject) getSystemObject();
			if (ko.getObjectSet("EreignisTypen") == null) {
				// Die Menge ist nicht konfiguriert
				return null;
			}
			ereignisTypen = new AenderbareMenge<de.bsvrz.sys.funclib.bitctrl.modell.tmereigniskalenderglobal.objekte.EreignisTyp>(getObjektFactory(), (MutableSet)ko.getObjectSet("EreignisTypen"), 0, 0, this);
		}
		return ereignisTypen;
	}
	private AenderbareMenge<de.bsvrz.sys.funclib.bitctrl.modell.tmvewsimulationglobal.objekte.SimulationsStrecke> simulationsStrecken;
	
	public AenderbareMenge<de.bsvrz.sys.funclib.bitctrl.modell.tmvewsimulationglobal.objekte.SimulationsStrecke> getSimulationsStrecken() {
		if (simulationsStrecken == null) {
			ConfigurationObject ko = (ConfigurationObject) getSystemObject();
			if (ko.getObjectSet("SimulationsStrecken") == null) {
				// Die Menge ist nicht konfiguriert
				return null;
			}
			simulationsStrecken = new AenderbareMenge<de.bsvrz.sys.funclib.bitctrl.modell.tmvewsimulationglobal.objekte.SimulationsStrecke>(getObjektFactory(), (MutableSet)ko.getObjectSet("SimulationsStrecken"), 0, 0, this);
		}
		return simulationsStrecken;
	}
	private AenderbareMenge<de.bsvrz.sys.funclib.bitctrl.modell.tmereigniskalenderglobal.objekte.Ereignis> ereignisse;
	
	public AenderbareMenge<de.bsvrz.sys.funclib.bitctrl.modell.tmereigniskalenderglobal.objekte.Ereignis> getEreignisse() {
		if (ereignisse == null) {
			ConfigurationObject ko = (ConfigurationObject) getSystemObject();
			if (ko.getObjectSet("Ereignisse") == null) {
				// Die Menge ist nicht konfiguriert
				return null;
			}
			ereignisse = new AenderbareMenge<de.bsvrz.sys.funclib.bitctrl.modell.tmereigniskalenderglobal.objekte.Ereignis>(getObjektFactory(), (MutableSet)ko.getObjectSet("Ereignisse"), 0, 0, this);
		}
		return ereignisse;
	}
	private AenderbareMenge<de.bsvrz.sys.funclib.bitctrl.modell.tmsystemkalenderglobal.objekte.SystemKalenderEintrag> systemKalenderEintraege;
	
	public AenderbareMenge<de.bsvrz.sys.funclib.bitctrl.modell.tmsystemkalenderglobal.objekte.SystemKalenderEintrag> getSystemKalenderEintraege() {
		if (systemKalenderEintraege == null) {
			ConfigurationObject ko = (ConfigurationObject) getSystemObject();
			if (ko.getObjectSet("SystemKalenderEinträge") == null) {
				// Die Menge ist nicht konfiguriert
				return null;
			}
			systemKalenderEintraege = new AenderbareMenge<de.bsvrz.sys.funclib.bitctrl.modell.tmsystemkalenderglobal.objekte.SystemKalenderEintrag>(getObjektFactory(), (MutableSet)ko.getObjectSet("SystemKalenderEinträge"), 0, 0, this);
		}
		return systemKalenderEintraege;
	}

	/*
	 * Ende Abschnitt Mengen
	 */

	/*
	 * Beginn Abschnitt Attributgruppen
	 */

	public de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.onlinedaten.OdArchivAnfrageSchnittstelle getOdArchivAnfrageSchnittstelle() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.onlinedaten.OdArchivAnfrageSchnittstelle.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.systemmodellkexdav.onlinedaten.OdTriggerKExDaV getOdTriggerKExDaV() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.systemmodellkexdav.onlinedaten.OdTriggerKExDaV.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdKonfigurationsVerantwortlicherEigenschaften getKdKonfigurationsVerantwortlicherEigenschaften() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdKonfigurationsVerantwortlicherEigenschaften.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdInfo getKdInfo() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdInfo.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.parameter.PdVerwaltungDynamischerObjekte getPdVerwaltungDynamischerObjekte() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.parameter.PdVerwaltungDynamischerObjekte.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmvewprotokolleglobal.onlinedaten.OdPuaProtokollAnfrageSchnittstelle getOdPuaProtokollAnfrageSchnittstelle() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmvewprotokolleglobal.onlinedaten.OdPuaProtokollAnfrageSchnittstelle.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmereigniskalenderglobal.onlinedaten.OdEreignisKalenderAnfrage getOdEreignisKalenderAnfrage() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmereigniskalenderglobal.onlinedaten.OdEreignisKalenderAnfrage.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.parameter.PdArchivContainerPersistenzEinstellung getPdArchivContainerPersistenzEinstellung() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.parameter.PdArchivContainerPersistenzEinstellung.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.onlinedaten.OdArchivSpeicherplatz getOdArchivSpeicherplatz() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.onlinedaten.OdArchivSpeicherplatz.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmbuvglobal.parameter.PdGlobaleEinstellungenOberflaecheNetzweit getPdGlobaleEinstellungenOberflaecheNetzweit() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmbuvglobal.parameter.PdGlobaleEinstellungenOberflaecheNetzweit.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.ilse.onlinedaten.OdIlseLogbuch getOdIlseLogbuch() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.ilse.onlinedaten.OdIlseLogbuch.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.onlinedaten.OdParametrierungSchnittstelle getOdParametrierungSchnittstelle() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.onlinedaten.OdParametrierungSchnittstelle.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.onlinedaten.OdParametrierungsAnfrage getOdParametrierungsAnfrage() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.onlinedaten.OdParametrierungsAnfrage.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.onlinedaten.OdArchivAnfrage getOdArchivAnfrage() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.onlinedaten.OdArchivAnfrage.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.parameter.PdArchivDatenEndgueltigLoeschen getPdArchivDatenEndgueltigLoeschen() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.parameter.PdArchivDatenEndgueltigLoeschen.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.onlinedaten.OdKonfigurationsBenutzerverwaltungsAnfrageSchnittstelle getOdKonfigurationsBenutzerverwaltungsAnfrageSchnittstelle() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.onlinedaten.OdKonfigurationsBenutzerverwaltungsAnfrageSchnittstelle.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.onlinedaten.OdHintergrundTaskZustaende getOdHintergrundTaskZustaende() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.onlinedaten.OdHintergrundTaskZustaende.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmvewsimulationglobal.onlinedaten.OdSimulationVerwaltungAnfrage getOdSimulationVerwaltungAnfrage() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmvewsimulationglobal.onlinedaten.OdSimulationVerwaltungAnfrage.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.onlinedaten.OdKonfigurationsAnfrage getOdKonfigurationsAnfrage() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.onlinedaten.OdKonfigurationsAnfrage.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdDefaultParameterdatensaetze getKdDefaultParameterdatensaetze() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdDefaultParameterdatensaetze.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.onlinedaten.OdKonfigurationsSchreibAnfrage getOdKonfigurationsSchreibAnfrage() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.onlinedaten.OdKonfigurationsSchreibAnfrage.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.parameter.PdArchivEinstellung getPdArchivEinstellung() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.parameter.PdArchivEinstellung.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.onlinedaten.OdKonfigurationsAnfrageSchnittstelleSchreibend getOdKonfigurationsAnfrageSchnittstelleSchreibend() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.onlinedaten.OdKonfigurationsAnfrageSchnittstelleSchreibend.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.systemmodellkexdav.parameter.PdSpezifikationKExDaV getPdSpezifikationKExDaV() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.systemmodellkexdav.parameter.PdSpezifikationKExDaV.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.onlinedaten.OdKonfigurationsBereichsverwaltungsAnfrageSchnittstelle getOdKonfigurationsBereichsverwaltungsAnfrageSchnittstelle() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.onlinedaten.OdKonfigurationsBereichsverwaltungsAnfrageSchnittstelle.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdAlternativeObjektbezeichnung getKdAlternativeObjektbezeichnung() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdAlternativeObjektbezeichnung.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmvewengstellenglobal.parameter.PdEngstellenVerwaltungParameter getPdEngstellenVerwaltungParameter() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmvewengstellenglobal.parameter.PdEngstellenVerwaltungParameter.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmbuvglobal.parameter.PdOberflaechenBerechtigung getPdOberflaechenBerechtigung() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmbuvglobal.parameter.PdOberflaechenBerechtigung.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.onlinedaten.OdKonfigurationsAnfrageSchnittstelle getOdKonfigurationsAnfrageSchnittstelle() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.onlinedaten.OdKonfigurationsAnfrageSchnittstelle.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmbuvglobal.parameter.PdBenutzerEinstellungenOberflaecheNetzweit getPdBenutzerEinstellungenOberflaecheNetzweit() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmbuvglobal.parameter.PdBenutzerEinstellungenOberflaecheNetzweit.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmbuvglobal.parameter.PdRahmenwerkEinstellungen getPdRahmenwerkEinstellungen() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmbuvglobal.parameter.PdRahmenwerkEinstellungen.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmvewsimulationglobal.onlinedaten.OdSimulationsStatusArchiv getOdSimulationsStatusArchiv() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmvewsimulationglobal.onlinedaten.OdSimulationsStatusArchiv.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.parameter.PdPlausibilitaetsPruefungFormal getPdPlausibilitaetsPruefungFormal() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.parameter.PdPlausibilitaetsPruefungFormal.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.onlinedaten.OdKonfigurationsAnfrageSchnittstelleLesend getOdKonfigurationsAnfrageSchnittstelleLesend() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.onlinedaten.OdKonfigurationsAnfrageSchnittstelleLesend.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.onlinedaten.OdBetriebsMeldung getOdBetriebsMeldung() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.onlinedaten.OdBetriebsMeldung.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.parameter.PdGanglinienModellAutomatischesLernen getPdGanglinienModellAutomatischesLernen() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.parameter.PdGanglinienModellAutomatischesLernen.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.onlinedaten.OdPrognoseGanglinienAnfrage getOdPrognoseGanglinienAnfrage() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmganglinienglobal.onlinedaten.OdPrognoseGanglinienAnfrage.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.onlinedaten.OdMeldungsBearbeitung getOdMeldungsBearbeitung() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.onlinedaten.OdMeldungsBearbeitung.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.parameter.PdArchiv getPdArchiv() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.parameter.PdArchiv.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdKonfigurationsVerantwortlicherLaufendeNummer getKdKonfigurationsVerantwortlicherLaufendeNummer() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdKonfigurationsVerantwortlicherLaufendeNummer.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.parameter.PdParametrierung getPdParametrierung() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.parameter.PdParametrierung.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.systemmodellaoe.parameter.PdParameterEndgueltigesLoeschen getPdParameterEndgueltigesLoeschen() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.systemmodellaoe.parameter.PdParameterEndgueltigesLoeschen.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.parameter.PdBetriebsMeldungsVerwaltungRegel getPdBetriebsMeldungsVerwaltungRegel() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.parameter.PdBetriebsMeldungsVerwaltungRegel.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmsystemkalenderglobal.parameter.PdStatusBaustelleAlsEreignis getPdStatusBaustelleAlsEreignis() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmsystemkalenderglobal.parameter.PdStatusBaustelleAlsEreignis.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.ilse.parameter.PdListeAnschlussPunkte getPdListeAnschlussPunkte() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.ilse.parameter.PdListeAnschlussPunkte.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.parameter.PdArchivContainer getPdArchivContainer() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.parameter.PdArchivContainer.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.onlinedaten.OdMeldungsGruppeZuordnung getOdMeldungsGruppeZuordnung() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.onlinedaten.OdMeldungsGruppeZuordnung.class); 
	}
	
	
	/*
	 * Ende Abschnitt Attributgruppen
	 */
	
	// Sonderfall Klasse AttributImpl
	 

}
