/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.lveueberwachung.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Enthaelt die Informationen, ob die letzten X
					Stunden
					daraufhin ueberprueft werden soll, ob durchgaengig keine
					Fahrzeuge
					gefahren sind.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlNullDatensaetzeUeberpruefung implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _ueberwachen
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			 _erlaubteStundenOhneVerkehr
			;
	
		/**
		Sollen die Null-Datensaetze ueberwacht werden?.
		<p>
		
		</p>
		
		@return der Wert von Ueberwachen.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 getUeberwachen() {
			return _ueberwachen;
		}
	
		/**
		Sollen die Null-Datensaetze ueberwacht werden?.
		<p>
		
		</p>
		
		@param _ueberwachen der neue Wert von Ueberwachen.
		*/
		public void setUeberwachen(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
		 _ueberwachen) {
			this._ueberwachen = _ueberwachen;
		}
	
		/**
		Anzahl der Stunden, fuer die kein Verkehr gezaehlt werden
								darf, ohne dass gewarnt wird.
		<p>
		
		</p>
		
		@return der Wert von ErlaubteStundenOhneVerkehr.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			 getErlaubteStundenOhneVerkehr() {
			return _erlaubteStundenOhneVerkehr;
		}
	
		/**
		Anzahl der Stunden, fuer die kein Verkehr gezaehlt werden
								darf, ohne dass gewarnt wird.
		<p>
		
		</p>
		
		@param _erlaubteStundenOhneVerkehr der neue Wert von ErlaubteStundenOhneVerkehr.
		*/
		public void setErlaubteStundenOhneVerkehr(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
		 _erlaubteStundenOhneVerkehr) {
			this._erlaubteStundenOhneVerkehr = _erlaubteStundenOhneVerkehr;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// GanzzahlAttributTyp
				if (getUeberwachen() != null) {
	                if (getUeberwachen().isZustand()) {
	                    datum.getUnscaledValue("ueberwachen").setText(getUeberwachen().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("ueberwachen").set(getUeberwachen().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getErlaubteStundenOhneVerkehr() != null) {
	                if (getErlaubteStundenOhneVerkehr().isZustand()) {
	                    datum.getUnscaledValue("erlaubteStundenOhneVerkehr").setText(getErlaubteStundenOhneVerkehr().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("erlaubteStundenOhneVerkehr").set(getErlaubteStundenOhneVerkehr().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("ueberwachen").isState()) {
							setUeberwachen(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							.getZustand(daten.getScaledValue("ueberwachen").getText()));
						} else {
						setUeberwachen(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
						(daten.
							getUnscaledValue
						("ueberwachen").
								byteValue
						()));
						}
				// GanzzahlAttributTyp
						setErlaubteStundenOhneVerkehr(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
						(daten.
							getUnscaledValue
						("erlaubteStundenOhneVerkehr").
								longValue
						()));
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlNullDatensaetzeUeberpruefung clone() {
		AtlNullDatensaetzeUeberpruefung klon = new AtlNullDatensaetzeUeberpruefung();
		
						klon.setUeberwachen(getUeberwachen());
						klon.setErlaubteStundenOhneVerkehr(getErlaubteStundenOhneVerkehr());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
