/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Fasst die Attribute zusammen, die zu einer Konfigurationsabhängigkeit gehören.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 9
 */
public class AtlKonfigurationsAbhaengigkeiten implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttKonfigurationsVersion
			 _abhaengigkeitEntstandenInVersion
			;
			private String
			 _bereichNotwendig
			= new String
			()
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttKonfigurationsVersion
			 _versionNotwendig
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttKennungDerAbhaengigkeit
			 _kennung
			;
	
		/**
		Versionsnummer des Konfigurationsbereichs, in der die Abhängigkeit aufgetreten ist.
		<p>
		Gibt die Version an, ab der eine Abhängigkeit aufgetreten ist. Ab dieser Version wird ein anderer Bereich benötigt oder ist
		                        zumindest optional nötig.
		</p>
		
		@return der Wert von AbhaengigkeitEntstandenInVersion.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttKonfigurationsVersion
			 getAbhaengigkeitEntstandenInVersion() {
			return _abhaengigkeitEntstandenInVersion;
		}
	
		/**
		Versionsnummer des Konfigurationsbereichs, in der die Abhängigkeit aufgetreten ist.
		<p>
		Gibt die Version an, ab der eine Abhängigkeit aufgetreten ist. Ab dieser Version wird ein anderer Bereich benötigt oder ist
		                        zumindest optional nötig.
		</p>
		
		@param _abhaengigkeitEntstandenInVersion der neue Wert von AbhaengigkeitEntstandenInVersion.
		*/
		public void setAbhaengigkeitEntstandenInVersion(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttKonfigurationsVersion
		 _abhaengigkeitEntstandenInVersion) {
			this._abhaengigkeitEntstandenInVersion = _abhaengigkeitEntstandenInVersion;
		}
	
		/**
		Von diesem Bereich ist der Konfigurationsbereich abhängig, der Bereich wird über die Pid identifiziert.
		<p>
		Mit diesem Bereich kann der Konfigurationsbereich Abhängigkeiten auflösen. Es wird die Pid gespeichert, da der abhängige Bereich
		                        nicht verfügbar sein kann (Der Benutzer hat ihn nicht kopiert, als Beispiel). So kann trotzdem der fehlende Bereich identifiziert
		                        werden.
		</p>
		
		@return der Wert von BereichNotwendig.
		*/
			public String
			 getBereichNotwendig() {
			return _bereichNotwendig;
		}
	
		/**
		Von diesem Bereich ist der Konfigurationsbereich abhängig, der Bereich wird über die Pid identifiziert.
		<p>
		Mit diesem Bereich kann der Konfigurationsbereich Abhängigkeiten auflösen. Es wird die Pid gespeichert, da der abhängige Bereich
		                        nicht verfügbar sein kann (Der Benutzer hat ihn nicht kopiert, als Beispiel). So kann trotzdem der fehlende Bereich identifiziert
		                        werden.
		</p>
		
		@param _bereichNotwendig der neue Wert von BereichNotwendig.
		*/
		public void setBereichNotwendig(String
		 _bereichNotwendig) {
			if (_bereichNotwendig.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._bereichNotwendig = _bereichNotwendig;
		}
	
		/**
		Versionsnummer in der der Bereich (Attribut "BereichNotwendig") vorliegen muss, damit die Referenzen aufgelöst werden können.
		<p>
		
		</p>
		
		@return der Wert von VersionNotwendig.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttKonfigurationsVersion
			 getVersionNotwendig() {
			return _versionNotwendig;
		}
	
		/**
		Versionsnummer in der der Bereich (Attribut "BereichNotwendig") vorliegen muss, damit die Referenzen aufgelöst werden können.
		<p>
		
		</p>
		
		@param _versionNotwendig der neue Wert von VersionNotwendig.
		*/
		public void setVersionNotwendig(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttKonfigurationsVersion
		 _versionNotwendig) {
			this._versionNotwendig = _versionNotwendig;
		}
	
		/**
		Gibt an, ob der mit Attribut "BereichNotwendig" definierte Bereich in Version "VersionNotwendig" vorliegen muss (notwenig) oder
		                        nur vorliegen kann (optional, er wird nicht gebraucht).
		<p>
		
		</p>
		
		@return der Wert von Kennung.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttKennungDerAbhaengigkeit
			 getKennung() {
			return _kennung;
		}
	
		/**
		Gibt an, ob der mit Attribut "BereichNotwendig" definierte Bereich in Version "VersionNotwendig" vorliegen muss (notwenig) oder
		                        nur vorliegen kann (optional, er wird nicht gebraucht).
		<p>
		
		</p>
		
		@param _kennung der neue Wert von Kennung.
		*/
		public void setKennung(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttKennungDerAbhaengigkeit
		 _kennung) {
			this._kennung = _kennung;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// GanzzahlAttributTyp
				if (getAbhaengigkeitEntstandenInVersion() != null) {
	                if (getAbhaengigkeitEntstandenInVersion().isZustand()) {
	                    datum.getUnscaledValue("AbhängigkeitEntstandenInVersion").setText(getAbhaengigkeitEntstandenInVersion().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("AbhängigkeitEntstandenInVersion").set(getAbhaengigkeitEntstandenInVersion().getValue());
	                }
				}
				// ZeichenkettenAttributTyp
				if (getBereichNotwendig() != null) {
					datum.getTextValue("BereichNotwendig").setText(getBereichNotwendig());
				}
				// GanzzahlAttributTyp
				if (getVersionNotwendig() != null) {
	                if (getVersionNotwendig().isZustand()) {
	                    datum.getUnscaledValue("VersionNotwendig").setText(getVersionNotwendig().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("VersionNotwendig").set(getVersionNotwendig().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getKennung() != null) {
	                if (getKennung().isZustand()) {
	                    datum.getUnscaledValue("Kennung").setText(getKennung().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Kennung").set(getKennung().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("AbhängigkeitEntstandenInVersion").isState()) {
							setAbhaengigkeitEntstandenInVersion(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttKonfigurationsVersion
							.getZustand(daten.getScaledValue("AbhängigkeitEntstandenInVersion").getText()));
						} else {
						setAbhaengigkeitEntstandenInVersion(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttKonfigurationsVersion
						(daten.
							getUnscaledValue
						("AbhängigkeitEntstandenInVersion").
								shortValue
						()));
						}
				// ZeichenkettenAttributTyp
					setBereichNotwendig(daten.getTextValue("BereichNotwendig").getText());
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("VersionNotwendig").isState()) {
							setVersionNotwendig(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttKonfigurationsVersion
							.getZustand(daten.getScaledValue("VersionNotwendig").getText()));
						} else {
						setVersionNotwendig(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttKonfigurationsVersion
						(daten.
							getUnscaledValue
						("VersionNotwendig").
								shortValue
						()));
						}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Kennung").isState()) {
							setKennung(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttKennungDerAbhaengigkeit
							.getZustand(daten.getScaledValue("Kennung").getText()));
						} else {
						setKennung(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttKennungDerAbhaengigkeit
						(daten.
							getUnscaledValue
						("Kennung").
								byteValue
						()));
						}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlKonfigurationsAbhaengigkeiten clone() {
		AtlKonfigurationsAbhaengigkeiten klon = new AtlKonfigurationsAbhaengigkeiten();
		
						klon.setAbhaengigkeitEntstandenInVersion(getAbhaengigkeitEntstandenInVersion());
						klon.setBereichNotwendig(getBereichNotwendig());
						klon.setVersionNotwendig(getVersionNotwendig());
						klon.setKennung(getKennung());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
