/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Definiert eine Transaktion.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 14
 */
public class AtlTransaktion implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AtlTransaktionsDatensatz
			> _datensatz = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AtlTransaktionsDatensatz
			>(0, true);
	
		/**
		Definiert einen Transaktionsdatensatz.
		<p>
		
		</p>
		
		@return der Wert von Datensatz.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AtlTransaktionsDatensatz
			> getDatensatz() {
			return _datensatz;
		}
	
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// AttributListenDefinition
					final Data.Array arrayDatensatz = datum.getArray("Datensatz");
					arrayDatensatz.setLength(getDatensatz().size());
					for (int i = 0; i < arrayDatensatz.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AtlTransaktionsDatensatz
						 atl = getDatensatz().get(i);
						atl.bean2Atl(arrayDatensatz.getItem(i), factory);
	
					}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// AttributListenDefinition
					final Data.Array arrayDatensatz = daten.getArray("Datensatz");
					for (int i = 0; i < arrayDatensatz.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AtlTransaktionsDatensatz
						 atl = new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AtlTransaktionsDatensatz
						 ();
						atl.atl2Bean(arrayDatensatz.getItem(i), factory);
						getDatensatz().add(atl);
					}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlTransaktion clone() {
		AtlTransaktion klon = new AtlTransaktion();
		
					klon._datensatz = getDatensatz().clone();
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
