/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Definiert eine Transaktionseinschränkung.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 14
 */
public class AtlTransaktionsEinschraenkung implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private 	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Typ
			 _objektTyp
			;
			private 	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Attributgruppe
			 _attributgruppe
			;
			private 	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Aspekt
			 _aspekt
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _nurTransaktionsObjekt
			;
	
		/**
		Attribut zur Referenzierung des Objekttyps: typ.typ (Optionale Referenzierung erlaubt).
		<p>
		
		</p>
		
		@return der Wert von ObjektTyp.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Typ
			 getObjektTyp() {
			return _objektTyp;
		}
	
		/**
		Attribut zur Referenzierung des Objekttyps: typ.typ (Optionale Referenzierung erlaubt).
		<p>
		
		</p>
		
		@param _objektTyp der neue Wert von ObjektTyp.
		*/
		public void setObjektTyp(	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Typ
		 _objektTyp) {
			this._objektTyp = _objektTyp;
		}
	
		/**
		Attribut zur Referenzierung des Objekttyps: typ.attributgruppe (Optionale Referenzierung erlaubt).
		<p>
		
		</p>
		
		@return der Wert von Attributgruppe.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Attributgruppe
			 getAttributgruppe() {
			return _attributgruppe;
		}
	
		/**
		Attribut zur Referenzierung des Objekttyps: typ.attributgruppe (Optionale Referenzierung erlaubt).
		<p>
		
		</p>
		
		@param _attributgruppe der neue Wert von Attributgruppe.
		*/
		public void setAttributgruppe(	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Attributgruppe
		 _attributgruppe) {
			this._attributgruppe = _attributgruppe;
		}
	
		/**
		Attribut zur Referenzierung des Objekttyps: typ.aspekt (Optionale Referenzierung erlaubt).
		<p>
		
		</p>
		
		@return der Wert von Aspekt.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Aspekt
			 getAspekt() {
			return _aspekt;
		}
	
		/**
		Attribut zur Referenzierung des Objekttyps: typ.aspekt (Optionale Referenzierung erlaubt).
		<p>
		
		</p>
		
		@param _aspekt der neue Wert von Aspekt.
		*/
		public void setAspekt(	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Aspekt
		 _aspekt) {
			this._aspekt = _aspekt;
		}
	
		/**
		Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
		<p>
		
		</p>
		
		@return der Wert von NurTransaktionsObjekt.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 getNurTransaktionsObjekt() {
			return _nurTransaktionsObjekt;
		}
	
		/**
		Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
		<p>
		
		</p>
		
		@param _nurTransaktionsObjekt der neue Wert von NurTransaktionsObjekt.
		*/
		public void setNurTransaktionsObjekt(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
		 _nurTransaktionsObjekt) {
			this._nurTransaktionsObjekt = _nurTransaktionsObjekt;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Object soObjektTyp = getObjektTyp();
					final SystemObject tmpObjektTyp;
						if (soObjektTyp instanceof SystemObject) {
							tmpObjektTyp = (SystemObject)soObjektTyp;
						} else if(soObjektTyp instanceof SystemObjekt){
							tmpObjektTyp = ((SystemObjekt)soObjektTyp).getSystemObject();
						} else{
							tmpObjektTyp = null;
						}
					datum.getReferenceValue("ObjektTyp").setSystemObject(tmpObjektTyp);
				// ObjektReferenzAttributTyp
					final Object soAttributgruppe = getAttributgruppe();
					final SystemObject tmpAttributgruppe;
						if (soAttributgruppe instanceof SystemObject) {
							tmpAttributgruppe = (SystemObject)soAttributgruppe;
						} else if(soAttributgruppe instanceof SystemObjekt){
							tmpAttributgruppe = ((SystemObjekt)soAttributgruppe).getSystemObject();
						} else{
							tmpAttributgruppe = null;
						}
					datum.getReferenceValue("Attributgruppe").setSystemObject(tmpAttributgruppe);
				// ObjektReferenzAttributTyp
					final Object soAspekt = getAspekt();
					final SystemObject tmpAspekt;
						if (soAspekt instanceof SystemObject) {
							tmpAspekt = (SystemObject)soAspekt;
						} else if(soAspekt instanceof SystemObjekt){
							tmpAspekt = ((SystemObjekt)soAspekt).getSystemObject();
						} else{
							tmpAspekt = null;
						}
					datum.getReferenceValue("Aspekt").setSystemObject(tmpAspekt);
				// GanzzahlAttributTyp
				if (getNurTransaktionsObjekt() != null) {
	                if (getNurTransaktionsObjekt().isZustand()) {
	                    datum.getUnscaledValue("NurTransaktionsObjekt").setText(getNurTransaktionsObjekt().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("NurTransaktionsObjekt").set(getNurTransaktionsObjekt().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final long idObjektTyp = daten.getReferenceValue("ObjektTyp").getId();
					final SystemObjekt tmpObjektTyp;
					if (idObjektTyp == 0) {
						tmpObjektTyp = null;
					} else {
						final SystemObject soObjektTyp = factory.getDav().getDataModel().getObject(idObjektTyp);
						if (soObjektTyp == null) {
								tmpObjektTyp = new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.TypUngueltig(idObjektTyp);
						} else {
							tmpObjektTyp = factory.getModellobjekt(soObjektTyp);
						}
					}
					setObjektTyp((	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Typ
					) tmpObjektTyp);
				// ObjektReferenzAttributTyp
					final long idAttributgruppe = daten.getReferenceValue("Attributgruppe").getId();
					final SystemObjekt tmpAttributgruppe;
					if (idAttributgruppe == 0) {
						tmpAttributgruppe = null;
					} else {
						final SystemObject soAttributgruppe = factory.getDav().getDataModel().getObject(idAttributgruppe);
						if (soAttributgruppe == null) {
								tmpAttributgruppe = new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AttributgruppeUngueltig(idAttributgruppe);
						} else {
							tmpAttributgruppe = factory.getModellobjekt(soAttributgruppe);
						}
					}
					setAttributgruppe((	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Attributgruppe
					) tmpAttributgruppe);
				// ObjektReferenzAttributTyp
					final long idAspekt = daten.getReferenceValue("Aspekt").getId();
					final SystemObjekt tmpAspekt;
					if (idAspekt == 0) {
						tmpAspekt = null;
					} else {
						final SystemObject soAspekt = factory.getDav().getDataModel().getObject(idAspekt);
						if (soAspekt == null) {
								tmpAspekt = new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektUngueltig(idAspekt);
						} else {
							tmpAspekt = factory.getModellobjekt(soAspekt);
						}
					}
					setAspekt((	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Aspekt
					) tmpAspekt);
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("NurTransaktionsObjekt").isState()) {
							setNurTransaktionsObjekt(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							.getZustand(daten.getScaledValue("NurTransaktionsObjekt").getText()));
						} else {
						setNurTransaktionsObjekt(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
						(daten.
							getUnscaledValue
						("NurTransaktionsObjekt").
								byteValue
						()));
						}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlTransaktionsEinschraenkung clone() {
		AtlTransaktionsEinschraenkung klon = new AtlTransaktionsEinschraenkung();
		
						klon.setObjektTyp(getObjektTyp());
						klon.setAttributgruppe(getAttributgruppe());
						klon.setAspekt(getAspekt());
						klon.setNurTransaktionsObjekt(getNurTransaktionsObjekt());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
