/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Speichert zu einer Version des Konfigurationsbereichs die Attributtypen ab,
                    die in dieser Version durch unversionierte Datenmodelländerungen bearbeitet wurden.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 16
 */
public class AtlUnversionierteAenderungenInVersion implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttKonfigurationsVersion
			 _version
			;
			private Feld<String
			> _attributTypen = new Feld<String
			>(0, true);
	
		/**
		Versionsnummer der Konfiguration.
		<p>
		Die Versionsnummer der Konfiguration wird z.B.im Zusammenhang von 'gültigAb' und 'nichtMehrGültigAb' in der Objekttabelle der
		                    Konfigurationsobjekte benutzt.
		</p>
		
		@return der Wert von Version.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttKonfigurationsVersion
			 getVersion() {
			return _version;
		}
	
		/**
		Versionsnummer der Konfiguration.
		<p>
		Die Versionsnummer der Konfiguration wird z.B.im Zusammenhang von 'gültigAb' und 'nichtMehrGültigAb' in der Objekttabelle der
		                    Konfigurationsobjekte benutzt.
		</p>
		
		@param _version der neue Wert von Version.
		*/
		public void setVersion(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttKonfigurationsVersion
		 _version) {
			this._version = _version;
		}
	
		/**
		Attribut zur Speicherung der permanenten ID eines Objekts.
		<p>
		
		</p>
		
		@return der Wert von AttributTypen.
		*/
			public Feld<String
			> getAttributTypen() {
			return _attributTypen;
		}
	
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// GanzzahlAttributTyp
				if (getVersion() != null) {
	                if (getVersion().isZustand()) {
	                    datum.getUnscaledValue("Version").setText(getVersion().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Version").set(getVersion().getValue());
	                }
				}
				// ZeichenkettenAttributTyp
				if (getAttributTypen() != null) {
					final Data.TextArray arrayAttributTypen = datum.getTextArray("AttributTypen");
					arrayAttributTypen.setLength(getAttributTypen().size());
					for (int i = 0; i < arrayAttributTypen.getLength(); ++i) {
						arrayAttributTypen.getTextValue(i).setText(getAttributTypen().get(i));
					}
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Version").isState()) {
							setVersion(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttKonfigurationsVersion
							.getZustand(daten.getScaledValue("Version").getText()));
						} else {
						setVersion(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttKonfigurationsVersion
						(daten.
							getUnscaledValue
						("Version").
								shortValue
						()));
						}
				// ZeichenkettenAttributTyp
					final Data.TextArray arrayAttributTypen = daten.getTextArray("AttributTypen");
					for (int i = 0; i < arrayAttributTypen.getLength(); ++i) {
						getAttributTypen().add(arrayAttributTypen.getText(i));
					}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlUnversionierteAenderungenInVersion clone() {
		AtlUnversionierteAenderungenInVersion klon = new AtlUnversionierteAenderungenInVersion();
		
						klon.setVersion(getVersion());
					klon._attributTypen = getAttributTypen().clone();
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
