/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Verwendungsparameter in Online- oder in konfigurierenden Datensätzen.
<p>
Hier wird verwaltet, ob ein konfigurierender Datensatz dieser Verwendung notwendigerweise an jedem Objekt des entsprechenden Typs sein muss,
                    oder ob der Datensatz optional vorhanden sein kann und ob die konfigurierenden Datensätze dieser Verwendung änderbar sind, oder
                    nicht.
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AttDatensatzVerwendung extends Zahl<		Byte
> {
	
	private static final long serialVersionUID = 1L;
	
	
	/**
	
	<p>
	
	</p>
	*/
	public static final AttDatensatzVerwendung ZUSTAND_1_KONFIGURIERENDERDATENSATZNOTWENDIG = new AttDatensatzVerwendung("KonfigurierenderDatensatzNotwendig", 		Byte
	.valueOf("1"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttDatensatzVerwendung ZUSTAND_2_KONFIGURIERENDERDATENSATZNOTWENDIGUNDAENDERBAR = new AttDatensatzVerwendung("KonfigurierenderDatensatzNotwendigUndÄnderbar", 		Byte
	.valueOf("2"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttDatensatzVerwendung ZUSTAND_3_KONFIGURIERENDERDATENSATZOPTIONAL = new AttDatensatzVerwendung("KonfigurierenderDatensatzOptional", 		Byte
	.valueOf("3"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttDatensatzVerwendung ZUSTAND_4_KONFIGURIERENDERDATENSATZOPTIONALUNDAENDERBAR = new AttDatensatzVerwendung("KonfigurierenderDatensatzOptionalUndÄnderbar", 		Byte
	.valueOf("4"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttDatensatzVerwendung ZUSTAND_5_ONLINEDATENSATZQUELLE = new AttDatensatzVerwendung("OnlineDatensatzQuelle", 		Byte
	.valueOf("5"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttDatensatzVerwendung ZUSTAND_6_ONLINEDATENSATZSENKE = new AttDatensatzVerwendung("OnlineDatensatzSenke", 		Byte
	.valueOf("6"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttDatensatzVerwendung ZUSTAND_7_ONLINEDATENSATZQUELLEUNDSENKE = new AttDatensatzVerwendung("OnlineDatensatzQuelleUndSenke", 		Byte
	.valueOf("7"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttDatensatzVerwendung getZustand(final 		Byte
	 value) {
		for (AttDatensatzVerwendung e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttDatensatzVerwendung getZustand(final String value) {
		for (AttDatensatzVerwendung e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttDatensatzVerwendung> getZustaende() {
		List<AttDatensatzVerwendung> list = new ArrayList<AttDatensatzVerwendung>();
		list.add(ZUSTAND_1_KONFIGURIERENDERDATENSATZNOTWENDIG);
		list.add(ZUSTAND_2_KONFIGURIERENDERDATENSATZNOTWENDIGUNDAENDERBAR);
		list.add(ZUSTAND_3_KONFIGURIERENDERDATENSATZOPTIONAL);
		list.add(ZUSTAND_4_KONFIGURIERENDERDATENSATZOPTIONALUNDAENDERBAR);
		list.add(ZUSTAND_5_ONLINEDATENSATZQUELLE);
		list.add(ZUSTAND_6_ONLINEDATENSATZSENKE);
		list.add(ZUSTAND_7_ONLINEDATENSATZQUELLEUNDSENKE);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut DatensatzVerwendung.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttDatensatzVerwendung(final 		Byte
	 value) {
		super(value);
	}
	
	private AttDatensatzVerwendung(final String zustand, final 		Byte
	 value) {
		super(zustand, value);
	}
	
}
