/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Attributtyp, der zur Unterscheidung der verschiedenen Abhängigkeiten zwischen Konfigurationsbereichen dient.
<p>
Alle Kennungen, die Abhängigkeiten zwischen Konfigurationsbereichen darstellen.
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 8
 */
public class AttKennungDerAbhaengigkeit extends Zahl<		Byte
> {
	
	private static final long serialVersionUID = 1L;
	
	
	/**
	Kennzeichnet, das ein Bereich notwendig ist um eine Referenz auflösen zu können.
	<p>
	
	</p>
	*/
	public static final AttKennungDerAbhaengigkeit ZUSTAND_1_NOTWENDIG = new AttKennungDerAbhaengigkeit("notwendig", 		Byte
	.valueOf("1"));

	/**
	Kennzeichnet, das ein Bereich nicht notwendig ist um alle Referenzen aufzulösen.
	<p>
	
	</p>
	*/
	public static final AttKennungDerAbhaengigkeit ZUSTAND_2_OPTIONAL = new AttKennungDerAbhaengigkeit("optional", 		Byte
	.valueOf("2"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttKennungDerAbhaengigkeit getZustand(final 		Byte
	 value) {
		for (AttKennungDerAbhaengigkeit e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttKennungDerAbhaengigkeit getZustand(final String value) {
		for (AttKennungDerAbhaengigkeit e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttKennungDerAbhaengigkeit> getZustaende() {
		List<AttKennungDerAbhaengigkeit> list = new ArrayList<AttKennungDerAbhaengigkeit>();
		list.add(ZUSTAND_1_NOTWENDIG);
		list.add(ZUSTAND_2_OPTIONAL);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut ArtDerKennung.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttKennungDerAbhaengigkeit(final 		Byte
	 value) {
		super(value);
	}
	
	private AttKennungDerAbhaengigkeit(final String zustand, final 		Byte
	 value) {
		super(zustand, value);
	}
	
}
