/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Attributgruppenverwendung definiert, welche Kombination von Attributgruppe und Aspekt verwendet werden kann.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class KdAttributgruppenVerwendung extends AbstractKonfigurationsDatensatz<KdAttributgruppenVerwendung.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.Eigenschaften,
				};
			}
	
			/**
			 * Wird für konfigurierende Attributgruppen verwendet. Über die entsprechende Attributgruppe werden die konkreten Eigenschaften eines Objekts festgelegt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt Eigenschaften = new Aspekte("Eigenschaften", "asp.eigenschaften");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractDatum implements KonfigurationsDatum {
		
		/**
		 * Initialisiert das Datum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private 	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Attributgruppe
				 _attributgruppe
				;
				private 	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Aspekt
				 _aspekt
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 _verwendungExplizitVorgegeben
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttDatensatzVerwendung
				 _datensatzVerwendung
				;
		
			/**
			Attributtyp zur Referenzierung von Attributgruppen mit Referenzierungsart Aggregation.
			<p>
			
			</p>
			
			@return der Wert von Attributgruppe.
			*/
				public 	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Attributgruppe
				 getAttributgruppe() {
				return _attributgruppe;
			}
		
			/**
			Attributtyp zur Referenzierung von Attributgruppen mit Referenzierungsart Aggregation.
			<p>
			
			</p>
			
			@param _attributgruppe der neue Wert von Attributgruppe.
			*/
			public void setAttributgruppe(	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Attributgruppe
			 _attributgruppe) {
				this._attributgruppe = _attributgruppe;
			}
		
			/**
			Attributtyp zur Referenzierung von Aspekten mit Referenzierungsart Aggregation.
			<p>
			
			</p>
			
			@return der Wert von Aspekt.
			*/
				public 	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Aspekt
				 getAspekt() {
				return _aspekt;
			}
		
			/**
			Attributtyp zur Referenzierung von Aspekten mit Referenzierungsart Aggregation.
			<p>
			
			</p>
			
			@param _aspekt der neue Wert von Aspekt.
			*/
			public void setAspekt(	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Aspekt
			 _aspekt) {
				this._aspekt = _aspekt;
			}
		
			/**
			Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
			<p>
			
			</p>
			
			@return der Wert von VerwendungExplizitVorgegeben.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 getVerwendungExplizitVorgegeben() {
				return _verwendungExplizitVorgegeben;
			}
		
			/**
			Beantwortung einer Frage, die sich implizit durch den Namen des Attributs stellt mit"Ja" (Wert 1) oder"Nein" (Wert 0).
			<p>
			
			</p>
			
			@param _verwendungExplizitVorgegeben der neue Wert von VerwendungExplizitVorgegeben.
			*/
			public void setVerwendungExplizitVorgegeben(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _verwendungExplizitVorgegeben) {
				this._verwendungExplizitVorgegeben = _verwendungExplizitVorgegeben;
			}
		
			/**
			Verwendungsparameter in Online- oder in konfigurierenden Datensätzen.
			<p>
			Hier wird verwaltet, ob ein konfigurierender Datensatz dieser Verwendung notwendigerweise an jedem Objekt des entsprechenden Typs sein muss,
			                    oder ob der Datensatz optional vorhanden sein kann und ob die konfigurierenden Datensätze dieser Verwendung änderbar sind, oder
			                    nicht.
			</p>
			
			@return der Wert von DatensatzVerwendung.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttDatensatzVerwendung
				 getDatensatzVerwendung() {
				return _datensatzVerwendung;
			}
		
			/**
			Verwendungsparameter in Online- oder in konfigurierenden Datensätzen.
			<p>
			Hier wird verwaltet, ob ein konfigurierender Datensatz dieser Verwendung notwendigerweise an jedem Objekt des entsprechenden Typs sein muss,
			                    oder ob der Datensatz optional vorhanden sein kann und ob die konfigurierenden Datensätze dieser Verwendung änderbar sind, oder
			                    nicht.
			</p>
			
			@param _datensatzVerwendung der neue Wert von DatensatzVerwendung.
			*/
			public void setDatensatzVerwendung(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttDatensatzVerwendung
			 _datensatzVerwendung) {
				this._datensatzVerwendung = _datensatzVerwendung;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// ObjektReferenzAttributTyp
						final Object soAttributgruppe = getAttributgruppe();
						final SystemObject tmpAttributgruppe;
							if (soAttributgruppe instanceof SystemObject) {
								tmpAttributgruppe = (SystemObject)soAttributgruppe;
							} else if(soAttributgruppe instanceof SystemObjekt){
								tmpAttributgruppe = ((SystemObjekt)soAttributgruppe).getSystemObject();
							} else{
								tmpAttributgruppe = null;
							}
						datum.getReferenceValue("Attributgruppe").setSystemObject(tmpAttributgruppe);
					// ObjektReferenzAttributTyp
						final Object soAspekt = getAspekt();
						final SystemObject tmpAspekt;
							if (soAspekt instanceof SystemObject) {
								tmpAspekt = (SystemObject)soAspekt;
							} else if(soAspekt instanceof SystemObjekt){
								tmpAspekt = ((SystemObjekt)soAspekt).getSystemObject();
							} else{
								tmpAspekt = null;
							}
						datum.getReferenceValue("Aspekt").setSystemObject(tmpAspekt);
					// GanzzahlAttributTyp
					if (getVerwendungExplizitVorgegeben() != null) {
		                if (getVerwendungExplizitVorgegeben().isZustand()) {
		                    datum.getUnscaledValue("VerwendungExplizitVorgegeben").setText(getVerwendungExplizitVorgegeben().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("VerwendungExplizitVorgegeben").set(getVerwendungExplizitVorgegeben().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getDatensatzVerwendung() != null) {
		                if (getDatensatzVerwendung().isZustand()) {
		                    datum.getUnscaledValue("DatensatzVerwendung").setText(getDatensatzVerwendung().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("DatensatzVerwendung").set(getDatensatzVerwendung().getValue());
		                }
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// ObjektReferenzAttributTyp
						final long idAttributgruppe = daten.getReferenceValue("Attributgruppe").getId();
						final SystemObjekt tmpAttributgruppe;
						if (idAttributgruppe == 0) {
							tmpAttributgruppe = null;
						} else {
							final SystemObject soAttributgruppe = factory.getDav().getDataModel().getObject(idAttributgruppe);
							if (soAttributgruppe == null) {
									tmpAttributgruppe = new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AttributgruppeUngueltig(idAttributgruppe);
							} else {
								tmpAttributgruppe = factory.getModellobjekt(soAttributgruppe);
							}
						}
						setAttributgruppe((	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Attributgruppe
						) tmpAttributgruppe);
					// ObjektReferenzAttributTyp
						final long idAspekt = daten.getReferenceValue("Aspekt").getId();
						final SystemObjekt tmpAspekt;
						if (idAspekt == 0) {
							tmpAspekt = null;
						} else {
							final SystemObject soAspekt = factory.getDav().getDataModel().getObject(idAspekt);
							if (soAspekt == null) {
									tmpAspekt = new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektUngueltig(idAspekt);
							} else {
								tmpAspekt = factory.getModellobjekt(soAspekt);
							}
						}
						setAspekt((	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Aspekt
						) tmpAspekt);
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("VerwendungExplizitVorgegeben").isState()) {
								setVerwendungExplizitVorgegeben(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
								.getZustand(daten.getScaledValue("VerwendungExplizitVorgegeben").getText()));
							} else {
							setVerwendungExplizitVorgegeben(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							(daten.
								getUnscaledValue
							("VerwendungExplizitVorgegeben").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("DatensatzVerwendung").isState()) {
								setDatensatzVerwendung(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttDatensatzVerwendung
								.getZustand(daten.getScaledValue("DatensatzVerwendung").getText()));
							} else {
							setDatensatzVerwendung(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttDatensatzVerwendung
							(daten.
								getUnscaledValue
							("DatensatzVerwendung").
									byteValue
							()));
							}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setAttributgruppe(getAttributgruppe());
							klon.setAspekt(getAspekt());
							klon.setVerwendungExplizitVorgegeben(getVerwendungExplizitVorgegeben());
							klon.setDatensatzVerwendung(getDatensatzVerwendung());
			
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}
	
		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.attributgruppenVerwendung";

	/**
	 * Initialisiert den Konfigurationsdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public KdAttributgruppenVerwendung(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
