/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Attributgruppe zur Beschreibung der Eigenschaften von Attribut-Typen des Datentyps Ganzzahl.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class KdGanzzahlAttributTypEigenschaften extends AbstractKonfigurationsDatensatz<KdGanzzahlAttributTypEigenschaften.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.Eigenschaften,
				};
			}
	
			/**
			 * Wird für konfigurierende Attributgruppen verwendet. Über die entsprechende Attributgruppe werden die konkreten Eigenschaften eines Objekts festgelegt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt Eigenschaften = new Aspekte("Eigenschaften", "asp.eigenschaften");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractDatum implements KonfigurationsDatum {
		
		/**
		 * Initialisiert das Datum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private 	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.WerteBereich
				 _bereich
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttDatentypGroesse
				 _anzahlBytes
				;
		
			/**
			Referenz auf einen Wertebereich.
			<p>
			
			</p>
			
			@return der Wert von Bereich.
			*/
				public 	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.WerteBereich
				 getBereich() {
				return _bereich;
			}
		
			/**
			Referenz auf einen Wertebereich.
			<p>
			
			</p>
			
			@param _bereich der neue Wert von Bereich.
			*/
			public void setBereich(	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.WerteBereich
			 _bereich) {
				this._bereich = _bereich;
			}
		
			/**
			Anzahl der von einem einfachen Datentyp benötigten Bytes.
			<p>
			
			</p>
			
			@return der Wert von AnzahlBytes.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttDatentypGroesse
				 getAnzahlBytes() {
				return _anzahlBytes;
			}
		
			/**
			Anzahl der von einem einfachen Datentyp benötigten Bytes.
			<p>
			
			</p>
			
			@param _anzahlBytes der neue Wert von AnzahlBytes.
			*/
			public void setAnzahlBytes(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttDatentypGroesse
			 _anzahlBytes) {
				this._anzahlBytes = _anzahlBytes;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// ObjektReferenzAttributTyp
						final Object soBereich = getBereich();
						final SystemObject tmpBereich;
							if (soBereich instanceof SystemObject) {
								tmpBereich = (SystemObject)soBereich;
							} else if(soBereich instanceof SystemObjekt){
								tmpBereich = ((SystemObjekt)soBereich).getSystemObject();
							} else{
								tmpBereich = null;
							}
						datum.getReferenceValue("bereich").setSystemObject(tmpBereich);
					// GanzzahlAttributTyp
					if (getAnzahlBytes() != null) {
		                if (getAnzahlBytes().isZustand()) {
		                    datum.getUnscaledValue("anzahlBytes").setText(getAnzahlBytes().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("anzahlBytes").set(getAnzahlBytes().getValue());
		                }
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// ObjektReferenzAttributTyp
						final long idBereich = daten.getReferenceValue("bereich").getId();
						final SystemObjekt tmpBereich;
						if (idBereich == 0) {
							tmpBereich = null;
						} else {
							final SystemObject soBereich = factory.getDav().getDataModel().getObject(idBereich);
							if (soBereich == null) {
									tmpBereich = new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.WerteBereichUngueltig(idBereich);
							} else {
								tmpBereich = factory.getModellobjekt(soBereich);
							}
						}
						setBereich((	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.WerteBereich
						) tmpBereich);
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("anzahlBytes").isState()) {
								setAnzahlBytes(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttDatentypGroesse
								.getZustand(daten.getScaledValue("anzahlBytes").getText()));
							} else {
							setAnzahlBytes(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttDatentypGroesse
							(daten.
								getUnscaledValue
							("anzahlBytes").
									byteValue
							()));
							}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setBereich(getBereich());
							klon.setAnzahlBytes(getAnzahlBytes());
			
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}
	
		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.ganzzahlAttributTypEigenschaften";

	/**
	 * Initialisiert den Konfigurationsdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public KdGanzzahlAttributTypEigenschaften(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
