/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Attributgruppe zur Speicherung von Eigenschaften von Konfigurationsbereichen.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class KdKonfigurationsVerantwortlicherEigenschaften extends AbstractKonfigurationsDatensatz<KdKonfigurationsVerantwortlicherEigenschaften.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.Eigenschaften,
				};
			}
	
			/**
			 * Wird für konfigurierende Attributgruppen verwendet. Über die entsprechende Attributgruppe werden die konkreten Eigenschaften eines Objekts festgelegt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt Eigenschaften = new Aspekte("Eigenschaften", "asp.eigenschaften");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractDatum implements KonfigurationsDatum {
		
		/**
		 * Initialisiert das Datum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttKodierungKonfigurationsVerantwortlicher
				 _kodierung
				;
				private Feld<String
				> _defaultBereich = new Feld<String
				>(1, true);
		
			/**
			Spezifiziert die eindeutige Kodierung des Konfigurationsverantwortlichen.
			<p>
			Die Kodierung dient bei der Erzeugung von Objekten dazu, eine über alle Konfigurationen hinweg eindeutige Objekt-Id zu
			                        generieren.
			</p>
			
			@return der Wert von Kodierung.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttKodierungKonfigurationsVerantwortlicher
				 getKodierung() {
				return _kodierung;
			}
		
			/**
			Spezifiziert die eindeutige Kodierung des Konfigurationsverantwortlichen.
			<p>
			Die Kodierung dient bei der Erzeugung von Objekten dazu, eine über alle Konfigurationen hinweg eindeutige Objekt-Id zu
			                        generieren.
			</p>
			
			@param _kodierung der neue Wert von Kodierung.
			*/
			public void setKodierung(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttKodierungKonfigurationsVerantwortlicher
			 _kodierung) {
				this._kodierung = _kodierung;
			}
		
			/**
			Spezifiziert einen Konfigurationsbereich in dem neu erzeugte Objekte von der jeweiligen Konfiguration angelegt werden, wenn keine
			                        explizite Vorgabe seitens der Applikation erfolgt.
			<p>
			
			</p>
			
			@return der Wert von DefaultBereich.
			*/
				public Feld<String
				> getDefaultBereich() {
				return _defaultBereich;
			}
		
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// GanzzahlAttributTyp
					if (getKodierung() != null) {
		                if (getKodierung().isZustand()) {
		                    datum.getUnscaledValue("kodierung").setText(getKodierung().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("kodierung").set(getKodierung().getValue());
		                }
					}
					// ZeichenkettenAttributTyp
					if (getDefaultBereich() != null) {
						final Data.TextArray arrayDefaultBereich = datum.getTextArray("defaultBereich");
						arrayDefaultBereich.setLength(getDefaultBereich().size());
						for (int i = 0; i < arrayDefaultBereich.getLength(); ++i) {
							arrayDefaultBereich.getTextValue(i).setText(getDefaultBereich().get(i));
						}
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// GanzzahlAttributTyp
							setKodierung(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttKodierungKonfigurationsVerantwortlicher
							(daten.
								getUnscaledValue
							("kodierung").
									shortValue
							()));
					// ZeichenkettenAttributTyp
						final Data.TextArray arrayDefaultBereich = daten.getTextArray("defaultBereich");
						for (int i = 0; i < arrayDefaultBereich.getLength(); ++i) {
							getDefaultBereich().add(arrayDefaultBereich.getText(i));
						}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setKodierung(getKodierung());
						klon._defaultBereich = getDefaultBereich().clone();
			
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}
	
		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.konfigurationsVerantwortlicherEigenschaften";

	/**
	 * Initialisiert den Konfigurationsdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public KdKonfigurationsVerantwortlicherEigenschaften(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
