/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Attributgruppe zur Beschreibung der Eigenschaften von Attribut-Typen des Datentyps ObjektReferenz.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class KdObjektReferenzAttributTypEigenschaften extends AbstractKonfigurationsDatensatz<KdObjektReferenzAttributTypEigenschaften.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.Eigenschaften,
				};
			}
	
			/**
			 * Wird für konfigurierende Attributgruppen verwendet. Über die entsprechende Attributgruppe werden die konkreten Eigenschaften eines Objekts festgelegt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt Eigenschaften = new Aspekte("Eigenschaften", "asp.eigenschaften");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractDatum implements KonfigurationsDatum {
		
		/**
		 * Initialisiert das Datum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private 	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Typ
				 _typ
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 _undefiniertErlaubt
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttReferenzierungsart
				 _referenzierungsart
				;
		
			/**
			Gibt den Objekttyp der referenzierten Objekte an.
			<p>
			Zu Referenz-Attributtypen muss verwaltet werden, von welchem Objekttyp die durch Attributwerte dieses Attributtyps referenzierten
			                        Objekte sein müssen (TPuK1-73 Objekttyp der referenzierten Objekte).
			</p>
			
			@return der Wert von Typ.
			*/
				public 	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Typ
				 getTyp() {
				return _typ;
			}
		
			/**
			Gibt den Objekttyp der referenzierten Objekte an.
			<p>
			Zu Referenz-Attributtypen muss verwaltet werden, von welchem Objekttyp die durch Attributwerte dieses Attributtyps referenzierten
			                        Objekte sein müssen (TPuK1-73 Objekttyp der referenzierten Objekte).
			</p>
			
			@param _typ der neue Wert von Typ.
			*/
			public void setTyp(	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Typ
			 _typ) {
				this._typ = _typ;
			}
		
			/**
			Gibt an, ob undefinierte Referenzen in Attributwerten dieses Attributtyps zugelassen werden.
			<p>
			Zu Referenz-Attributtypen muss verwaltet werden, ob undefinierte Referenzen in Attributwerten dieses Attributtyps zugelassen werden
			                        (TPuK1-74 Undefinierte Referenzen).
			</p>
			
			@return der Wert von UndefiniertErlaubt.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 getUndefiniertErlaubt() {
				return _undefiniertErlaubt;
			}
		
			/**
			Gibt an, ob undefinierte Referenzen in Attributwerten dieses Attributtyps zugelassen werden.
			<p>
			Zu Referenz-Attributtypen muss verwaltet werden, ob undefinierte Referenzen in Attributwerten dieses Attributtyps zugelassen werden
			                        (TPuK1-74 Undefinierte Referenzen).
			</p>
			
			@param _undefiniertErlaubt der neue Wert von UndefiniertErlaubt.
			*/
			public void setUndefiniertErlaubt(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _undefiniertErlaubt) {
				this._undefiniertErlaubt = _undefiniertErlaubt;
			}
		
			/**
			Referenzierungsart von Referenzen (Gerichtete Assoziation, Aggregation oder Komposition).
			<p>
			Zu Referenz-Attributtypen muss verwaltet werden, ob die in Attributwerten dieses Attributtyps enthaltenen Referenzen als gerichtete
			                        Assoziationen, als Aggregationen oder als Kompositionen realisiert werden sollen (TPuK1-75 Referenzierungsart von
			                        Referenzen).
			</p>
			
			@return der Wert von Referenzierungsart.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttReferenzierungsart
				 getReferenzierungsart() {
				return _referenzierungsart;
			}
		
			/**
			Referenzierungsart von Referenzen (Gerichtete Assoziation, Aggregation oder Komposition).
			<p>
			Zu Referenz-Attributtypen muss verwaltet werden, ob die in Attributwerten dieses Attributtyps enthaltenen Referenzen als gerichtete
			                        Assoziationen, als Aggregationen oder als Kompositionen realisiert werden sollen (TPuK1-75 Referenzierungsart von
			                        Referenzen).
			</p>
			
			@param _referenzierungsart der neue Wert von Referenzierungsart.
			*/
			public void setReferenzierungsart(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttReferenzierungsart
			 _referenzierungsart) {
				this._referenzierungsart = _referenzierungsart;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// ObjektReferenzAttributTyp
						final Object soTyp = getTyp();
						final SystemObject tmpTyp;
							if (soTyp instanceof SystemObject) {
								tmpTyp = (SystemObject)soTyp;
							} else if(soTyp instanceof SystemObjekt){
								tmpTyp = ((SystemObjekt)soTyp).getSystemObject();
							} else{
								tmpTyp = null;
							}
						datum.getReferenceValue("typ").setSystemObject(tmpTyp);
					// GanzzahlAttributTyp
					if (getUndefiniertErlaubt() != null) {
		                if (getUndefiniertErlaubt().isZustand()) {
		                    datum.getUnscaledValue("undefiniertErlaubt").setText(getUndefiniertErlaubt().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("undefiniertErlaubt").set(getUndefiniertErlaubt().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getReferenzierungsart() != null) {
		                if (getReferenzierungsart().isZustand()) {
		                    datum.getUnscaledValue("referenzierungsart").setText(getReferenzierungsart().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("referenzierungsart").set(getReferenzierungsart().getValue());
		                }
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// ObjektReferenzAttributTyp
						final long idTyp = daten.getReferenceValue("typ").getId();
						final SystemObjekt tmpTyp;
						if (idTyp == 0) {
							tmpTyp = null;
						} else {
							final SystemObject soTyp = factory.getDav().getDataModel().getObject(idTyp);
							if (soTyp == null) {
									tmpTyp = new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.TypUngueltig(idTyp);
							} else {
								tmpTyp = factory.getModellobjekt(soTyp);
							}
						}
						setTyp((	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Typ
						) tmpTyp);
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("undefiniertErlaubt").isState()) {
								setUndefiniertErlaubt(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
								.getZustand(daten.getScaledValue("undefiniertErlaubt").getText()));
							} else {
							setUndefiniertErlaubt(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							(daten.
								getUnscaledValue
							("undefiniertErlaubt").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("referenzierungsart").isState()) {
								setReferenzierungsart(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttReferenzierungsart
								.getZustand(daten.getScaledValue("referenzierungsart").getText()));
							} else {
							setReferenzierungsart(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttReferenzierungsart
							(daten.
								getUnscaledValue
							("referenzierungsart").
									byteValue
							()));
							}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setTyp(getTyp());
							klon.setUndefiniertErlaubt(getUndefiniertErlaubt());
							klon.setReferenzierungsart(getReferenzierungsart());
			
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}
	
		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.objektReferenzAttributTypEigenschaften";

	/**
	 * Initialisiert den Konfigurationsdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public KdObjektReferenzAttributTypEigenschaften(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
