/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Der Typ aller dynamischen Typobjekte.
<p>
&lt;absatz&gt;Objekte dieses Typs sind die Typen, die direkt oder indirekt den Typ
                        &lt;verweis pid="typ.dynamischesObjekt" txt="DynamischesObjekt"&gt;&lt;&#47;verweis&gt;

                        erweitern, also die Typen deren Objekte zur Laufzeit erzeugt und gelöscht werden können.
                    &lt;&#47;absatz&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class DynamischerTypImpl extends AbstractSystemObjekt
	implements de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.DynamischerTyp { 

	/**
	 * Der Defaultkonstruktor wird für das Erzeugen des Systemobjekts über per
	 * Reflection-API benötigt.
	 */
	public DynamischerTypImpl() {
		// tut nix
	}
	
	/**
	 * Initialisierung.
	 * 
	 * @param objekt
	 *            ein beliebiges Systemobjekt.
	 * @param factory
	 *            die Fabrik, die das Systemobjekt angelegt hat.
	 */
	public DynamischerTypImpl(final SystemObject objekt, final ObjektFactory factory) {
		super(objekt, factory);
		
		if (!objekt.isOfType(getTyp().getPid())) {
			throw new IllegalArgumentException(
					"Systemobjekt ist kein DynamischerTyp.");
		}
	}
	
	@Override
	protected String doGetTypPid() {
		return PID;
	}
	
	/*
	 * Beginn Abschnitt Mengen
	 */
	
	private Collection<de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.MengenVerwendung> mengen;
	
	public Collection<de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.MengenVerwendung> getMengen() {
		if (mengen == null) {
			final Collection<de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.MengenVerwendung> menge = new ArrayList<de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.MengenVerwendung>();
			ConfigurationObject ko = (ConfigurationObject) getSystemObject();
			if (ko.getObjectSet("Mengen") == null) {
				// Die Menge ist nicht konfiguriert
				return null;
			}
			for (SystemObject so : ko.getObjectSet("Mengen").getElements()) {
				menge.add((de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.MengenVerwendung) getObjektFactory().getModellobjekt(so));
			}
			mengen = Collections.unmodifiableCollection(menge);
		}
		return mengen;
	}
	private Collection<de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Attributgruppe> attributgruppen;
	
	public Collection<de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Attributgruppe> getAttributgruppen() {
		if (attributgruppen == null) {
			final Collection<de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Attributgruppe> menge = new ArrayList<de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Attributgruppe>();
			ConfigurationObject ko = (ConfigurationObject) getSystemObject();
			if (ko.getObjectSet("Attributgruppen") == null) {
				// Die Menge ist nicht konfiguriert
				return null;
			}
			for (SystemObject so : ko.getObjectSet("Attributgruppen").getElements()) {
				menge.add((de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Attributgruppe) getObjektFactory().getModellobjekt(so));
			}
			attributgruppen = Collections.unmodifiableCollection(menge);
		}
		return attributgruppen;
	}
	private Collection<de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Typ> superTypen;
	
	public Collection<de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Typ> getSuperTypen() {
		if (superTypen == null) {
			final Collection<de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Typ> menge = new ArrayList<de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Typ>();
			ConfigurationObject ko = (ConfigurationObject) getSystemObject();
			if (ko.getObjectSet("SuperTypen") == null) {
				// Die Menge ist nicht konfiguriert
				return null;
			}
			for (SystemObject so : ko.getObjectSet("SuperTypen").getElements()) {
				menge.add((de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Typ) getObjektFactory().getModellobjekt(so));
			}
			superTypen = Collections.unmodifiableCollection(menge);
		}
		return superTypen;
	}

	/*
	 * Ende Abschnitt Mengen
	 */

	/*
	 * Beginn Abschnitt Attributgruppen
	 */

	public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdDefaultParameterdatensaetze getKdDefaultParameterdatensaetze() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdDefaultParameterdatensaetze.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdInfo getKdInfo() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdInfo.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdAlternativeObjektbezeichnung getKdAlternativeObjektbezeichnung() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdAlternativeObjektbezeichnung.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdTypEigenschaften getKdTypEigenschaften() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdTypEigenschaften.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdDynamischerTypEigenschaften getKdDynamischerTypEigenschaften() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdDynamischerTypEigenschaften.class);
	}
	
	
	/*
	 * Ende Abschnitt Attributgruppen
	 */
	
	// Sonderfall Klasse AttributImpl
	 

}
