/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Definiert den Typ für Transaktionsobjekte.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 14
 */
public class TransaktionImpl extends AbstractSystemObjekt
	implements de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Transaktion { 

	/**
	 * Der Defaultkonstruktor wird für das Erzeugen des Systemobjekts über per
	 * Reflection-API benötigt.
	 */
	public TransaktionImpl() {
		// tut nix
	}
	
	/**
	 * Initialisierung.
	 * 
	 * @param objekt
	 *            ein beliebiges Systemobjekt.
	 * @param factory
	 *            die Fabrik, die das Systemobjekt angelegt hat.
	 */
	public TransaktionImpl(final SystemObject objekt, final ObjektFactory factory) {
		super(objekt, factory);
		
		if (!objekt.isOfType(getTyp().getPid())) {
			throw new IllegalArgumentException(
					"Systemobjekt ist kein Transaktion.");
		}
	}
	
	@Override
	protected String doGetTypPid() {
		return PID;
	}
	
	/*
	 * Beginn Abschnitt Mengen
	 */
	
	private Collection<de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.AttributgruppenVerwendung> attributgruppenVerwendungen;
	
	public Collection<de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.AttributgruppenVerwendung> getAttributgruppenVerwendungen() {
		if (attributgruppenVerwendungen == null) {
			final Collection<de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.AttributgruppenVerwendung> menge = new ArrayList<de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.AttributgruppenVerwendung>();
			ConfigurationObject ko = (ConfigurationObject) getSystemObject();
			if (ko.getObjectSet("AttributgruppenVerwendungen") == null) {
				// Die Menge ist nicht konfiguriert
				return null;
			}
			for (SystemObject so : ko.getObjectSet("AttributgruppenVerwendungen").getElements()) {
				menge.add((de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.AttributgruppenVerwendung) getObjektFactory().getModellobjekt(so));
			}
			attributgruppenVerwendungen = Collections.unmodifiableCollection(menge);
		}
		return attributgruppenVerwendungen;
	}
	private Collection<de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Aspekt> aspekte;
	
	public Collection<de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Aspekt> getAspekte() {
		if (aspekte == null) {
			final Collection<de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Aspekt> menge = new ArrayList<de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Aspekt>();
			ConfigurationObject ko = (ConfigurationObject) getSystemObject();
			if (ko.getObjectSet("Aspekte") == null) {
				// Die Menge ist nicht konfiguriert
				return null;
			}
			for (SystemObject so : ko.getObjectSet("Aspekte").getElements()) {
				menge.add((de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Aspekt) getObjektFactory().getModellobjekt(so));
			}
			aspekte = Collections.unmodifiableCollection(menge);
		}
		return aspekte;
	}
	private Collection<de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Attribut> attribute;
	
	public Collection<de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Attribut> getAttribute() {
		if (attribute == null) {
			final Collection<de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Attribut> menge = new ArrayList<de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Attribut>();
			ConfigurationObject ko = (ConfigurationObject) getSystemObject();
			if (ko.getObjectSet("Attribute") == null) {
				// Die Menge ist nicht konfiguriert
				return null;
			}
			for (SystemObject so : ko.getObjectSet("Attribute").getElements()) {
				menge.add((de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.Attribut) getObjektFactory().getModellobjekt(so));
			}
			attribute = Collections.unmodifiableCollection(menge);
		}
		return attribute;
	}

	/*
	 * Ende Abschnitt Mengen
	 */

	/*
	 * Beginn Abschnitt Attributgruppen
	 */

	public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdTransaktionsEigenschaften getKdTransaktionsEigenschaften() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdTransaktionsEigenschaften.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdDefaultParameterdatensaetze getKdDefaultParameterdatensaetze() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdDefaultParameterdatensaetze.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdInfo getKdInfo() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdInfo.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdAlternativeObjektbezeichnung getKdAlternativeObjektbezeichnung() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdAlternativeObjektbezeichnung.class);
	}
	
	
	/*
	 * Ende Abschnitt Attributgruppen
	 */
	
	// Sonderfall Klasse AttributImpl
	 

}
