/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.modellkextlslkwparken.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Belegungsinformationen zu den Sensoren der Parktasche.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlSensorenDerParktasche implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private Feld<de.bsvrz.sys.funclib.bitctrl.modell.modellkextlslkwparken.attribute.AtlSensorZustand
			> _sensoren = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.modellkextlslkwparken.attribute.AtlSensorZustand
			>(0, true);
	
		/**
		Belegungsinformationen und (Fehler)Zustand zu den Sensoren der Parktasche.
		<p>
		
		</p>
		
		@return der Wert von Sensoren.
		*/
			public Feld<de.bsvrz.sys.funclib.bitctrl.modell.modellkextlslkwparken.attribute.AtlSensorZustand
			> getSensoren() {
			return _sensoren;
		}
	
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// AttributListenDefinition
					final Data.Array arraySensoren = datum.getArray("Sensoren");
					arraySensoren.setLength(getSensoren().size());
					for (int i = 0; i < arraySensoren.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.modellkextlslkwparken.attribute.AtlSensorZustand
						 atl = getSensoren().get(i);
						atl.bean2Atl(arraySensoren.getItem(i), factory);
	
					}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// AttributListenDefinition
					final Data.Array arraySensoren = daten.getArray("Sensoren");
					for (int i = 0; i < arraySensoren.getLength(); ++i) {
						de.bsvrz.sys.funclib.bitctrl.modell.modellkextlslkwparken.attribute.AtlSensorZustand
						 atl = new de.bsvrz.sys.funclib.bitctrl.modell.modellkextlslkwparken.attribute.AtlSensorZustand
						 ();
						atl.atl2Bean(arraySensoren.getItem(i), factory);
						getSensoren().add(atl);
					}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlSensorenDerParktasche clone() {
		AtlSensorenDerParktasche klon = new AtlSensorenDerParktasche();
		
					klon._sensoren = getSensoren().clone();
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
