/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.modellkextlslkwparken.objekte;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
DE Lkw Park System Parktaschen.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public interface DePpueParktaschen extends de.bsvrz.sys.funclib.bitctrl.modell.KonfigurationsObjekt
	,de.bsvrz.sys.funclib.bitctrl.modell.modellkextlslkwparken.objekte.DePpue
	
	
	
	{

	/** Die PID des Systemobjekttyps im Datenverteiler. */
	public static final String PID = "typ.dePpüParktaschen"; 
	
	/*
	 * Beginn Abschnitt Mengen
	 */
	

	/*
	 * Ende Abschnitt Mengen
	 */

	/*
	 * Beginn Abschnitt Attributgruppen
	 */

	/**
	Ergänzende DE-Fehlermeldung (FG 3 &#47; Typ 14).
	<p>
	&lt;sektion&gt;
						    &lt;titel&gt;
							    FG 3: DE-Block-Struktur im Typ 14"Ergänzende
							    DE-Fehlermeldung"
						    &lt;&#47;titel&gt;
						    &lt;absatz&gt;
							    Wird verwendet mit ID 1 (Fehler) in
							    Antwortrichtung.
						    &lt;&#47;absatz&gt;
						    &lt;absatz&gt;
							    Dieser DE-Block dient zur Meldung von
							    Teilstörungen und näheren Erläuterung von
							    Störungen, die mit dem DEBlock Typ 1
							    gemeldet werden. Bei reinen Teilstörungen
							    wird nur der DE-Block 14 gesendet; bei
							    Erläuterungen von spontanen
							    Störungsmeldungen wird er in einem Telegramm
							    mit dem DE-Block Typ 1 gesendet. Er kann
							    aber mit der ID 17 in Abrufrichtung einzeln
							    abgerufen werden.
						    &lt;&#47;absatz&gt;
						    &lt;absatz&gt;
							    Mit dem DE-Block können unterschiedliche
							    Störungen&#47;Teilstörungen gleichzeitig
							    gemeldet werden. Ändert sich der Status
							    (weitere Störungen&#47;Behebung von bzw.
							    Behebung von Störungen) wird ebenfalls
							    DE-Block-Typ 14 gesendet.
						    &lt;&#47;absatz&gt;
					    &lt;&#47;sektion&gt;
	</p>
	@return der Datensatz TlsPpueErgaenzendeDeFehlerMeldung.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.modellkextlslkwparken.onlinedaten.OdTlsPpueErgaenzendeDeFehlerMeldung getOdTlsPpueErgaenzendeDeFehlerMeldung();
	
	/**
	Attributgruppe zur Speicherung von Default-Parameterdatensätzen für alle Parameter-Attributgruppen eines Typs.
	<p>
	
	</p>
	@return der Datensatz DefaultParameterdatensaetze.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdDefaultParameterdatensaetze getKdDefaultParameterdatensaetze();
	
	/**
	Legt fest, ob entsprechend implementierte Umsetzungsscripte Betriebsmeldungen erzeugen und
						versenden.
	<p>
	
	</p>
	@return der Datensatz TlsBetriebsMeldungErzeugen.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.parameter.PdTlsBetriebsMeldungErzeugen getPdTlsBetriebsMeldungErzeugen();
	
	/**
	Attributgruppe zur Speicherung von beschreibenden Informationen zu einem Objekt.
	<p>
	
	</p>
	@return der Datensatz Info.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdInfo getKdInfo();
	
	/**
	Verwaltet bis zu zehn alternative Bezeichnungen.
	<p>
	
	</p>
	@return der Datensatz AlternativeObjektbezeichnung.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdAlternativeObjektbezeichnung getKdAlternativeObjektbezeichnung();
	
	/**
	Konfigurierende Eigenschaften der Objekte des Typs.
	<p>
	
	</p>
	@return der Datensatz De.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.konfigurationsdaten.KdDe getKdDe();
	
	/**
	Kanalsteuerung (FG alle &#47; Typ 29).
	<p>
	&lt;sektion&gt;
							&lt;titel&gt;
								FG 1: DE-Block-Struktur im Typ
								29"Kanalsteuerung"
							&lt;&#47;titel&gt;
							&lt;absatz&gt;
								Wird verwendet mit ID 2 (Statusnachrichten)
								in Abruf- und Antwortrichtung oder mit ID 34
								(Statusnachricht aus Puffer) in
								Antwortrichtung.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Der DE-Block"Kanalsteuerung" beeinflusst die
								Betriebsweise eines DEs. Bisher sind nur die
								beiden Betriebsweisen"Normalbetrieb"
								und"Passiv" vorgesehen. Über die
								Betriebsweise"Passiv" ist das Passivieren
								eines Kanals möglich.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Die Funktion ist grundsätzlich für alle DEs
								vorgesehen, mit Ausnahme der Systemkanäle
								(FG 254). Sie dient insbesondere zum
								Abschalten von Kanälen, die Flattermeldungen
								produzieren oder aufgrund von Baustellen
								etc. nicht verwendet werden. Der
								Zustand"Passiv" muss spannungsausfallsicher
								abgelegt sein. Reaktionen eines passivierten
								Kanals (
								&lt;verweis pid="KanalsteuerungFG4" txt="Spezielles Verhalten in der FG4"&gt;&lt;&#47;verweis&gt;
	
								):
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								- spontan entstehende DE-Fehlermeldung (Typ
								1): keine Reaktion
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								- DE-Fehlermeldung (Typ 1) im
								Initialisierungsablauf normale Meldung
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								- Abfrage DE-Fehlermeldungen (Typ 1):
								normale Antwort
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								- Fehlermeldung im Initialisierungsablauf
								(außer Typ 1) keine Reaktion
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								- spontan entstehende Fehlermeldung keine
								Reaktion
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								- Abfrage Fehlermeldungen (außer Typ 1)
								keine Reaktion1
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								- spontan entstehende Anwenderdaten keine
								Reaktion
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								- Anwenderdaten im Initialisierungsablauf 2
								keine Reaktion
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								- Abfrage Anwenderdaten keine Reaktion1
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								- Befehle Anwenderdaten2 keine Antwort,
								keine Ausführung3
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								- Statusnachricht Kanalsteuerung normale
								Antwort und Ausführung
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								- Zuweisung und Abfrage Parameterdaten
								normale Antwort und Ausführung
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Die Einstellung des Kanalsteuerbytes erfolgt
								mit einem Kanalsteuerbefehl (ID 2, Typ 29),
								der mit Rückmeldung (ID 2, Typ 29)
								beantwortet wird. Die Meldung kann auch mit
								ID 18, Typ 29 abgefragt werden. Um die
								relevanten Kanalinformationen an einer
								Stelle zur Verfügung zu haben, wird das
								Passivierungsbit zusätzlich in der
								DE-Fehlermeldung übertragen.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								&lt;wichtig&gt;
									&lt;anker pid="KanalsteuerungFG4"&gt;&lt;&#47;anker&gt;
	
									Spezielles Verhalten in der FG4
								&lt;&#47;wichtig&gt;
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Verhalten beim Passivieren von DEs in der FG
								4:
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Der Wzg&#47;WWW wird ausgeschaltet oder das
								Rollo geschlossen. Bei Wzgs&#47;WWWs mit
								Prismentechnik wird, falls vorhanden, die
								Neutralstellung eingestellt. Die
								Stellzustandsänderung wird spontan zur UZ
								gesendet.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Verhalten von passivierten DEs in der FG 4:
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								1. An passivierte DEs wird im Autarkbetrieb
								keine Grundeinstellung ausgegeben, d.h. sie
								bleiben im Zustand"Aus" oder"Rollo
								geschlossen".
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								2. Befehle an passivierte Kanäle werden
								ausgeführt. Dadurch sind passive DEs
								schaltbar.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								3. Passivierte DEs senden immer ihre
								spontanen Meldungen, unabhängig vom
								Identifier und auch während der
								Initialisierung.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Somit ist das Verhalten passiver und aktiver
								Kanäle - außer im Autarkbetrieb - gleich.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Verhalten beim Aktivieren von passivierten
								DEs in der FG 4:
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Beim Aktivieren wird der Stellzustand des
								zugehörigen Wzgs&#47;WWWs vom EAK nicht
								verändert. Im Falle"Kommunikationsstatus
								lebt" werden DE-Fehlermeldung (Typ 1, ID 1)
								und bei"DE ok" abhängig von der Technologie
								der Zeichen nicht darstellbare WVZ (ID 1,
								Typ 2), defekte Lampen (ID 1, Typ 3) oder
								gestörte Textpositionen (ID 1, Typ 4) und
								der Stellzustand (ID 5, Typ 55, bei
								Altanlagen auch 48,50,58) gesendet. Im
								Falle"Kommunikationsstatus tot" wird die
								Grundeinstellung ausgegeben.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Ansonsten gilt entsprechend die Definition
								in Anhang 6, Teil 2, Kapitel 3.2.5.
							&lt;&#47;absatz&gt;
						&lt;&#47;sektion&gt;
	</p>
	@return der Datensatz TlsGloKanalSteuerung.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.parameter.PdTlsGloKanalSteuerung getPdTlsGloKanalSteuerung();
	
	/**
	Enthält die Ermittlung der Fehlerursache in der TLS
						Kommunikation, die aufgrund von Messwertausfällen
						ermittelt wurden.
	<p>
	
	</p>
	@return der Datensatz TlsFehlerAnalyse.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsFehlerAnalyse getOdTlsFehlerAnalyse();
	
	/**
	Betriebsparameter (FG 3 &#47; Typ 32).
	<p>
	&lt;sektion&gt;
						    &lt;titel&gt;
							    FG 3: DE-Block-Struktur im Typ
							    32"Betriebsparameter"
						    &lt;&#47;titel&gt;
						    &lt;absatz&gt;
							    Wird verwendet mit ID 3 (Parameter) in
							    Abruf- und Antwortrichtung.
						    &lt;&#47;absatz&gt;
						    &lt;absatz&gt;
							    Die Nachricht überträgt Parameter, welche
							    für den Betrieb der Umfelddatenerfassung
							    benötigt werden.
						    &lt;&#47;absatz&gt;
					    &lt;&#47;sektion&gt;
	</p>
	@return der Datensatz TlsPpueBetriebsParameter.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.modellkextlslkwparken.parameter.PdTlsPpueBetriebsParameter getPdTlsPpueBetriebsParameter();
	
	/**
	Abfragetelegramm für einen DE-Block.
	<p>
	
	</p>
	@return der Datensatz TlsGloDeBlockAbruf.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsGloDeBlockAbruf getOdTlsGloDeBlockAbruf();
	
	/**
	Typ 48: Parktaschenbelegung.
	<p>
	
	</p>
	@return der Datensatz TlsParktaschenbelegung.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.modellkextlslkwparken.onlinedaten.OdTlsParktaschenbelegung getOdTlsParktaschenbelegung();
	
	/**
	Ermöglich das Senden eines (beliegigen) DE-Blocks.
	<p>
	
	</p>
	@return der Datensatz TlsGloDeBlockSenden.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsGloDeBlockSenden getOdTlsGloDeBlockSenden();
	
	/**
	DE-Fehler (FG alle &#47; Typ 1).
	<p>
	&lt;sektion&gt;
							&lt;titel&gt;
								FG alle (ausser FG 254): DE-Block-Struktur
								im Typ 1"DE-Fehlermeldung"
							&lt;&#47;titel&gt;
							&lt;absatz&gt;
								Wird verwendet mit ID 1 (Fehler) in
								Antwortrichtung.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Die DE-Fehlermeldung informiert die Zentrale
								über den Betriebszustand eines DE. Die
								Nachricht wird vom E&#47;AKonzentrator oder vom
								SM erzeugt. Es sind folgende zwei Fälle
								unterscheidbar:
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								1.) Es sind ein oder mehrere Kanäle des
								E&#47;A-Konzentrators defekt, die Kommunikation
								des E&#47;A-Konzentrators ist jedoch noch
								funktionsfähig.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Folge: Bei Eintritt der Störung sendet der
								E&#47;A-Konzentrator eine Nachricht mit je einem
								DE-Block pro gestörtem Kanal und Fehlercode
								Bit 0 = 1. Auf Abfrage antworten
								betriebsbereite Kanäle mit Fehlercode Bit 0
								= 0, defekte Kanäle antworten mit Fehlercode
								Bit 0 = 1.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								2.) Der E&#47;A-Konzentrator ist so defekt, dass
								die Kommunikation zum SM nicht mehr
								funktioniert.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Folge: Der SM generiert bei Eintritt der
								Störung anhand seiner Konfigurationsliste je
								eine Nachricht pro FG des E&#47;AKonzentrators
								mit je einem DE-Block pro vorhandenem DE und
								Fehlercode Bit 1 = 1. Auf Abfrage antworten
								betriebsbereite Kanäle mit Fehlercode Bit
								0..2 = 0, defekte Kanäle antworten mit
								Fehlercode Bit 1 = 1.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Ist ein Fehler aufgetreten, der weiterhin
								einen eingeschränkten Betrieb der DE
								zulässt, so ist dieser Teilausfall nicht
								durch ein gesetztes Fehlercode-Bit 0 oder 1
								auszudrücken.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Vielmehr ist dieser Ausfall durch die
								ergänzende DE-Fehlermeldung Typ 14 der
								Zentrale mitzuteilen. Abrufe der
								Fehlermeldung reicht der SM an den
								E&#47;A-Konzentrator weiter, wenn dieser mit dem
								SM kommunizieren kann, andernfalls
								beantwortet sie der SM selbst.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Eine Kopie des Passiv-Bits, welches für
								jeden Kanal mit dem Kanalsteuerbefehl
								eingestellt werden kann, wird in der
								DE-Fehlermeldung mit übertragen. Dies
								erspart eine zusätzliche Abfrage bzw.
								Antwortnachricht des Kanalsteuerbytes, um
								den vollständigen Kanalzustand zu erfahren
								(Siehe auch Kapitel 3.2.5 Kanalsteuerung).
								Dieses Bit ist jedoch nur gültig, wenn die
								Fehlernachricht vom E&#47;A-Konzentrator erzeugt
								wird, jedoch nicht, wenn das Stö&#47;SM = 1 ist.
							&lt;&#47;absatz&gt;
						&lt;&#47;sektion&gt;
						&lt;sektion&gt;
							&lt;titel&gt;
								FG 254: DE-Block-Struktur im Typ
								1"DE-Fehlermeldung"
							&lt;&#47;titel&gt;
							&lt;absatz&gt;
								Wird verwendet mit ID 1 (Fehler) in
								Antwortrichtung.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Die DE-Fehlermeldung informiert die Zentrale
								über den Betriebszustand eines DE. Sie wird
								sowohl für die anwendungsbezogenen DEs als
								auch für die hardwarezugeordneten DEs (DE
								entspricht E&#47;A-Konzentrator unter FG 254)
								verwendet. Das Störungsereignis wird der
								Zentrale primär über die anwendungsbezogenen
								DE-Fehlermeldungen (FG 1..253) mitgeteilt.
								Die Nachricht wird vom E&#47;A-Konzentrator oder
								vom SM erzeugt. Es sind folgende zwei Fälle
								unterscheidbar:
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								1.) Es sind Teile des E&#47;A-Konzentrators
								defekt, die Kommunikation zum SM ist jedoch
								noch funktionsfähig. Folge: Die
								Systemsteuerung des E&#47;A-Konzentrators sendet
								eine Nachricht mit ihrer DE-Nummer und
								Fehlercode Bit 0 = 1.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								2.) Der E&#47;A-Konzentrator ist so defekt, dass
								die Kommunikation zum SM nicht mehr
								funktioniert.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Folge: Der SM generiert eine Nachricht mit
								der DE des E&#47;A-Konzentrators und Fehlercode
								Bit 1 = 1. Abrufe der Fehlermeldung reicht
								der SM an den E&#47;A-Konzentrator weiter, wenn
								dieser mit dem SM kommunizieren kann,
								andernfalls beantwortet sie der SM selbst.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Weitergehende Informationen siehe [TLS2002].
							&lt;&#47;absatz&gt;
						&lt;&#47;sektion&gt;
	</p>
	@return der Datensatz TlsGloDeFehler.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsGloDeFehler getOdTlsGloDeFehler();
	
	/**
	Legt fest, ob entsprechend implementierte Umsetzungsscripte der KExTLS ausgeführt werden
						oder nicht. Wird i.d.R. dazu verwendet, dass die Umsetzungscripte auf das logische Modell (FS,
						Umfelddaten) zu Testzwecken ausgeschaltet werden können.
	<p>
	
	</p>
	@return der Datensatz TlsPassivierungUebernahmeLogischesModell.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.parameter.PdTlsPassivierungUebernahmeLogischesModell getPdTlsPassivierungUebernahmeLogischesModell();
	
	/**
	Geographische Kenndaten (FG alle &#47; Typ 36).
	<p>
	&lt;sektion&gt;
							&lt;titel&gt;
								FG 254: DE-Block-Struktur im Typ
								36"Geographische Kenndaten"
							&lt;&#47;titel&gt;
							&lt;absatz&gt;
								Wird verwendet mit ID 3 (Parameter) in
								Abruf- und Antwortrichtung.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Die Meldung der geographischen Kenndaten
								dient dazu, die Lage der Streckenstation
								bzw. von Funktionsgruppen im Straßennetz
								durch Fernabruf überprüfbar zu machen. Dies
								kann insbesondere nach baulicher Änderung
								der Netzstruktur oder bei Inbetriebnahme von
								Zentralen hilfreich sein.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Dieses Datenfeld kann ein- oder mehrfach pro
								Streckenstation vorhanden sein. Es wird
								ausfallsicher gespeichert. Ist es nur einmal
								vorhanden, wird es über FG 254, DE 0 als
								Teil der Systemsteuerung im SM abgefragt.
								Dies ist der Standardfall. Optional kann das
								Datenfeld bei räumlich auseinanderliegenden
								Funktionsgruppen auch im EAK angelegt
								werden. Die Abfrage kann dann über einen
								beliebigen DE erfolgen. Eine weitere Option
								im EAK besteht darin, jedem DE ein
								unterschiedliches Datenfeld zuzuordnen, wenn
								dies für räumlich abgesetzte DEs
								erforderlich sein sollte.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Die geographischen Kenndaten werden i.d.R.
								vor Ort eingegeben und von der Zentrale nur
								gelesen.
							&lt;&#47;absatz&gt;
						&lt;&#47;sektion&gt;
	</p>
	@return der Datensatz TlsGloGeographischeKenndaten.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsGloGeographischeKenndaten getOdTlsGloGeographischeKenndaten();
	
	/**
	Koordinaten eines Punktes in Grad entsprechend WGS84.
	<p>
	
	</p>
	@return der Datensatz PunktKoordinaten.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.konfigurationsdaten.KdPunktKoordinaten getKdPunktKoordinaten();
	
	/**
	Negative Quittung (FG 3 &#47; Typ 16).
	<p>
	&lt;sektion&gt;
						    &lt;titel&gt;
							    FG 3: DE-Block-Struktur im Typ 16"Negative
							    Quittung"
						    &lt;&#47;titel&gt;
						    &lt;absatz&gt;
							    Wird verwendet mit ID 2 (Statusnachrichten)
							    in Antwortrichtung.
						    &lt;&#47;absatz&gt;
						    &lt;absatz&gt;
							    Mit der"Negativen Quittung" antwortet ein DE
							    auf eine Nachricht, die an sie korrekt
							    adressiert ist, aber deren Inhalt von ihr
							    nicht eindeutig ausgewertet werden kann.
						    &lt;&#47;absatz&gt;
						    &lt;absatz&gt;
							    Die Negative Quittung wird mit ID 2 und Typ
							    16 gesendet, enthält also keinen Hinweis auf
							    die ID und den Typ der verursachenden
							    Nachricht. Diese Zuordnung wird über die
							    Jobnummer hergestellt, welche identisch mit
							    der der fehlerhaften Nachricht in
							    Abrufrichtung ist.
						    &lt;&#47;absatz&gt;
					    &lt;&#47;sektion&gt;
	</p>
	@return der Datensatz TlsPpueNegativeQuittung.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.modellkextlslkwparken.onlinedaten.OdTlsPpueNegativeQuittung getOdTlsPpueNegativeQuittung();
	
	
	/*
	 * Ende Abschnitt Attributgruppen
	 */
	 
}
