/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.modellkextlslkwparken.onlinedaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Typ 49: Fahrzeugidentifikation.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 5
 */
public class OdTlsFahrzeugidentifikation extends AbstractOnlineDatensatz<OdTlsFahrzeugidentifikation.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.TlsZustand,
				};
			}
	
			/**
			 * Aspekt für den aktuellen Zustand , die i.d.R.
						ausfallsicher im SM oder EAK abgelegt werden (z.B.
						goegrafische Kenndaten, Knotennummer).	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt TlsZustand = new Aspekte("TlsZustand", "asp.tlsZustand");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.modellkextlslkwparken.attribute.AttTlsPpueFahrzeugId
				 _iDNummer
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.modellkextlslkwparken.attribute.AttTlsPpueDetektionszaehler
				 _detektionszaehler
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsFahrzeugklassencode
				 _fahrzeugklassencode
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
				 _geschwindigkeit
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsZeitdauer3
				 _belegtzeit
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLaenge2
				 _fahrzeuglaenge
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.modellkextlslkwparken.attribute.AttTlsPpueFahrtrichtung
				 _fahrtrichtung
				;
		
			/**
			Die ID-Nummer ist eine laufende Nummer im Bereich von 0 bis 65535 (2 Byte).
			                    Nach Erreichen des Wertes 65535 wird einem neu identifizierten Fahrzeug die nächste
			                    freie ID-Nummer größer 0 zugeordnet.
			                    Fahrzeuge, die nicht eindeutig identifiziert werden konnten, erhalten die spezielle ID-Nummer 0.
			<p>
			
			</p>
			
			@return der Wert von IDNummer.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.modellkextlslkwparken.attribute.AttTlsPpueFahrzeugId
				 getIDNummer() {
				return _iDNummer;
			}
		
			/**
			Die ID-Nummer ist eine laufende Nummer im Bereich von 0 bis 65535 (2 Byte).
			                    Nach Erreichen des Wertes 65535 wird einem neu identifizierten Fahrzeug die nächste
			                    freie ID-Nummer größer 0 zugeordnet.
			                    Fahrzeuge, die nicht eindeutig identifiziert werden konnten, erhalten die spezielle ID-Nummer 0.
			<p>
			
			</p>
			
			@param _iDNummer der neue Wert von IDNummer.
			*/
			public void setIDNummer(de.bsvrz.sys.funclib.bitctrl.modell.modellkextlslkwparken.attribute.AttTlsPpueFahrzeugId
			 _iDNummer) {
				this._iDNummer = _iDNummer;
			}
		
			/**
			Bei der erstmaligen Detektion eines Fahrzeuges und der damit verbundenen Zuweisung einer ID- Nummer,
			                    wird der Detektionszähler auf 1 gesetzt. Durchquert das Fahrzeug anschließend weitere
			                    Detektionspunkte auf dem Parkplatz, wird der Detektionszähler immer um eins erhöht.
			<p>
			
			</p>
			
			@return der Wert von Detektionszaehler.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.modellkextlslkwparken.attribute.AttTlsPpueDetektionszaehler
				 getDetektionszaehler() {
				return _detektionszaehler;
			}
		
			/**
			Bei der erstmaligen Detektion eines Fahrzeuges und der damit verbundenen Zuweisung einer ID- Nummer,
			                    wird der Detektionszähler auf 1 gesetzt. Durchquert das Fahrzeug anschließend weitere
			                    Detektionspunkte auf dem Parkplatz, wird der Detektionszähler immer um eins erhöht.
			<p>
			
			</p>
			
			@param _detektionszaehler der neue Wert von Detektionszaehler.
			*/
			public void setDetektionszaehler(de.bsvrz.sys.funclib.bitctrl.modell.modellkextlslkwparken.attribute.AttTlsPpueDetektionszaehler
			 _detektionszaehler) {
				this._detektionszaehler = _detektionszaehler;
			}
		
			/**
			Fahrzeugklassencodes gemäß TLS.
			<p>
			
			</p>
			
			@return der Wert von Fahrzeugklassencode.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsFahrzeugklassencode
				 getFahrzeugklassencode() {
				return _fahrzeugklassencode;
			}
		
			/**
			Fahrzeugklassencodes gemäß TLS.
			<p>
			
			</p>
			
			@param _fahrzeugklassencode der neue Wert von Fahrzeugklassencode.
			*/
			public void setFahrzeugklassencode(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsFahrzeugklassencode
			 _fahrzeugklassencode) {
				this._fahrzeugklassencode = _fahrzeugklassencode;
			}
		
			/**
			Geschwindigkeit TLS gemessen.
			<p>
			
			</p>
			
			@return der Wert von Geschwindigkeit.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
				 getGeschwindigkeit() {
				return _geschwindigkeit;
			}
		
			/**
			Geschwindigkeit TLS gemessen.
			<p>
			
			</p>
			
			@param _geschwindigkeit der neue Wert von Geschwindigkeit.
			*/
			public void setGeschwindigkeit(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
			 _geschwindigkeit) {
				this._geschwindigkeit = _geschwindigkeit;
			}
		
			/**
			Zeitdauer gemäß TLS (0-65534 ms).
			<p>
			
			</p>
			
			@return der Wert von Belegtzeit.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsZeitdauer3
				 getBelegtzeit() {
				return _belegtzeit;
			}
		
			/**
			Zeitdauer gemäß TLS (0-65534 ms).
			<p>
			
			</p>
			
			@param _belegtzeit der neue Wert von Belegtzeit.
			*/
			public void setBelegtzeit(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsZeitdauer3
			 _belegtzeit) {
				this._belegtzeit = _belegtzeit;
			}
		
			/**
			Längenangaben gemäß TLS 0..254 dm.
			<p>
			
			</p>
			
			@return der Wert von Fahrzeuglaenge.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLaenge2
				 getFahrzeuglaenge() {
				return _fahrzeuglaenge;
			}
		
			/**
			Längenangaben gemäß TLS 0..254 dm.
			<p>
			
			</p>
			
			@param _fahrzeuglaenge der neue Wert von Fahrzeuglaenge.
			*/
			public void setFahrzeuglaenge(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLaenge2
			 _fahrzeuglaenge) {
				this._fahrzeuglaenge = _fahrzeuglaenge;
			}
		
			/**
			Fahrtrichtung, in der der Fahrzeugidentifikator passiert wird.
			<p>
			
			</p>
			
			@return der Wert von Fahrtrichtung.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.modellkextlslkwparken.attribute.AttTlsPpueFahrtrichtung
				 getFahrtrichtung() {
				return _fahrtrichtung;
			}
		
			/**
			Fahrtrichtung, in der der Fahrzeugidentifikator passiert wird.
			<p>
			
			</p>
			
			@param _fahrtrichtung der neue Wert von Fahrtrichtung.
			*/
			public void setFahrtrichtung(de.bsvrz.sys.funclib.bitctrl.modell.modellkextlslkwparken.attribute.AttTlsPpueFahrtrichtung
			 _fahrtrichtung) {
				this._fahrtrichtung = _fahrtrichtung;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// GanzzahlAttributTyp
					if (getIDNummer() != null) {
		                if (getIDNummer().isZustand()) {
		                    datum.getUnscaledValue("ID-Nummer").setText(getIDNummer().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("ID-Nummer").set(getIDNummer().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getDetektionszaehler() != null) {
		                if (getDetektionszaehler().isZustand()) {
		                    datum.getUnscaledValue("Detektionszähler").setText(getDetektionszaehler().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Detektionszähler").set(getDetektionszaehler().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getFahrzeugklassencode() != null) {
		                if (getFahrzeugklassencode().isZustand()) {
		                    datum.getUnscaledValue("Fahrzeugklassencode").setText(getFahrzeugklassencode().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Fahrzeugklassencode").set(getFahrzeugklassencode().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getGeschwindigkeit() != null) {
		                if (getGeschwindigkeit().isZustand()) {
		                    datum.getUnscaledValue("Geschwindigkeit").setText(getGeschwindigkeit().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Geschwindigkeit").set(getGeschwindigkeit().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getBelegtzeit() != null) {
		                if (getBelegtzeit().isZustand()) {
		                    datum.getUnscaledValue("Belegtzeit").setText(getBelegtzeit().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Belegtzeit").set(getBelegtzeit().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getFahrzeuglaenge() != null) {
		                if (getFahrzeuglaenge().isZustand()) {
		                    datum.getUnscaledValue("Fahrzeuglänge").setText(getFahrzeuglaenge().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Fahrzeuglänge").set(getFahrzeuglaenge().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getFahrtrichtung() != null) {
		                if (getFahrtrichtung().isZustand()) {
		                    datum.getUnscaledValue("Fahrtrichtung").setText(getFahrtrichtung().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Fahrtrichtung").set(getFahrtrichtung().getValue());
		                }
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("ID-Nummer").isState()) {
								setIDNummer(de.bsvrz.sys.funclib.bitctrl.modell.modellkextlslkwparken.attribute.AttTlsPpueFahrzeugId
								.getZustand(daten.getScaledValue("ID-Nummer").getText()));
							} else {
							setIDNummer(new de.bsvrz.sys.funclib.bitctrl.modell.modellkextlslkwparken.attribute.AttTlsPpueFahrzeugId
							(daten.
								getUnscaledValue
							("ID-Nummer").
									intValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("Detektionszähler").isState()) {
								setDetektionszaehler(de.bsvrz.sys.funclib.bitctrl.modell.modellkextlslkwparken.attribute.AttTlsPpueDetektionszaehler
								.getZustand(daten.getScaledValue("Detektionszähler").getText()));
							} else {
							setDetektionszaehler(new de.bsvrz.sys.funclib.bitctrl.modell.modellkextlslkwparken.attribute.AttTlsPpueDetektionszaehler
							(daten.
								getUnscaledValue
							("Detektionszähler").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("Fahrzeugklassencode").isState()) {
								setFahrzeugklassencode(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsFahrzeugklassencode
								.getZustand(daten.getScaledValue("Fahrzeugklassencode").getText()));
							} else {
							setFahrzeugklassencode(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsFahrzeugklassencode
							(daten.
								getUnscaledValue
							("Fahrzeugklassencode").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("Geschwindigkeit").isState()) {
								setGeschwindigkeit(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
								.getZustand(daten.getScaledValue("Geschwindigkeit").getText()));
							} else {
							setGeschwindigkeit(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
							(daten.
								getUnscaledValue
							("Geschwindigkeit").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("Belegtzeit").isState()) {
								setBelegtzeit(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsZeitdauer3
								.getZustand(daten.getScaledValue("Belegtzeit").getText()));
							} else {
							setBelegtzeit(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsZeitdauer3
							(daten.
								getUnscaledValue
							("Belegtzeit").
									intValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("Fahrzeuglänge").isState()) {
								setFahrzeuglaenge(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLaenge2
								.getZustand(daten.getScaledValue("Fahrzeuglänge").getText()));
							} else {
							setFahrzeuglaenge(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLaenge2
							(daten.
								getUnscaledValue
							("Fahrzeuglänge").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("Fahrtrichtung").isState()) {
								setFahrtrichtung(de.bsvrz.sys.funclib.bitctrl.modell.modellkextlslkwparken.attribute.AttTlsPpueFahrtrichtung
								.getZustand(daten.getScaledValue("Fahrtrichtung").getText()));
							} else {
							setFahrtrichtung(new de.bsvrz.sys.funclib.bitctrl.modell.modellkextlslkwparken.attribute.AttTlsPpueFahrtrichtung
							(daten.
								getUnscaledValue
							("Fahrtrichtung").
									shortValue
							()));
							}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setIDNummer(getIDNummer());
							klon.setDetektionszaehler(getDetektionszaehler());
							klon.setFahrzeugklassencode(getFahrzeugklassencode());
							klon.setGeschwindigkeit(getGeschwindigkeit());
							klon.setBelegtzeit(getBelegtzeit());
							klon.setFahrzeuglaenge(getFahrzeuglaenge());
							klon.setFahrtrichtung(getFahrtrichtung());
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.tlsFahrzeugidentifikation";

	/**
	 * Initialisiert den Onlinedatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public OdTlsFahrzeugidentifikation(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
