/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.systemmodellaoe.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Ordnet einem Mengentyp einen Vorhaltezeitraum zu.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 7
 */
public class AtlParameterEndgueltigesLoeschenMengen implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private 	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.MengenTyp
			 _mengentyp
			;
			@Defaultwert(wert = "365 Tage")
			private 	RelativerZeitstempel
			 _vorhaltezeitraum
			;
	
		/**
		Dynamischer Mengentyp für den ein Vorhaltezeitraum definiert werden soll.
		<p>
		
		</p>
		
		@return der Wert von Mengentyp.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.MengenTyp
			 getMengentyp() {
			return _mengentyp;
		}
	
		/**
		Dynamischer Mengentyp für den ein Vorhaltezeitraum definiert werden soll.
		<p>
		
		</p>
		
		@param _mengentyp der neue Wert von Mengentyp.
		*/
		public void setMengentyp(	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.MengenTyp
		 _mengentyp) {
			this._mengentyp = _mengentyp;
		}
	
		/**
		Wie lange eine historische Mengenreferenz mindestens erhalten bleiben soll.
		<p>
		
		</p>
		
		@return der Wert von Vorhaltezeitraum.
		*/
			public 	RelativerZeitstempel
			 getVorhaltezeitraum() {
			return _vorhaltezeitraum;
		}
	
		/**
		Wie lange eine historische Mengenreferenz mindestens erhalten bleiben soll.
		<p>
		
		</p>
		
		@param _vorhaltezeitraum der neue Wert von Vorhaltezeitraum.
		*/
		public void setVorhaltezeitraum(	RelativerZeitstempel
		 _vorhaltezeitraum) {
			this._vorhaltezeitraum = _vorhaltezeitraum;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Object soMengentyp = getMengentyp();
					final SystemObject tmpMengentyp;
						if (soMengentyp instanceof SystemObject) {
							tmpMengentyp = (SystemObject)soMengentyp;
						} else if(soMengentyp instanceof SystemObjekt){
							tmpMengentyp = ((SystemObjekt)soMengentyp).getSystemObject();
						} else{
							tmpMengentyp = null;
						}
					datum.getReferenceValue("Mengentyp").setSystemObject(tmpMengentyp);
				// ZeitstempelAttributTyp
					datum.getTimeValue("Vorhaltezeitraum").setMillis(getVorhaltezeitraum().getTime());
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final long idMengentyp = daten.getReferenceValue("Mengentyp").getId();
					final SystemObjekt tmpMengentyp;
					if (idMengentyp == 0) {
						tmpMengentyp = null;
					} else {
						final SystemObject soMengentyp = factory.getDav().getDataModel().getObject(idMengentyp);
						if (soMengentyp == null) {
								tmpMengentyp = new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.MengenTypUngueltig(idMengentyp);
						} else {
							tmpMengentyp = factory.getModellobjekt(soMengentyp);
						}
					}
					setMengentyp((	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.MengenTyp
					) tmpMengentyp);
				// ZeitstempelAttributTyp
					setVorhaltezeitraum(new
						RelativerZeitstempel
						(daten.getTimeValue("Vorhaltezeitraum").getMillis()));
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlParameterEndgueltigesLoeschenMengen clone() {
		AtlParameterEndgueltigesLoeschenMengen klon = new AtlParameterEndgueltigesLoeschenMengen();
		
						klon.setMengentyp(getMengentyp());
						klon.setVorhaltezeitraum(getVorhaltezeitraum());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
