/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Attributliste zur Beschreibung, welche Mengen geändert werden dürfen.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 35
 */
public class AtlAktivitaetMengen implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private Feld<	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.MengenTyp
			> _mengentyp = new Feld<	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.MengenTyp
			>(0, true);
			private Feld<	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.KonfigurationsBereich
			> _konfigurationsbereich = new Feld<	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.KonfigurationsBereich
			>(0, true);
			@Defaultwert(wert = "Ja")
			private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _mengeAendern
			;
	
		/**
		Mengen, die hier betrachtet werden sollen.
		                        Wenn das Array leer ist, sind alle Mengentypen gemeint.
		<p>
		
		</p>
		
		@return der Wert von Mengentyp.
		*/
			public Feld<	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.MengenTyp
			> getMengentyp() {
			return _mengentyp;
		}
	
	
		/**
		Konfigurationsbereiche, in denen Mengen der angegebenen Mengentypen geändert werden dürfen.
		                        Wenn das Array leer ist, dürfen in allen möglichen Konfigurationsbereichen
		                        (grundsätzlich dürfen nur KB geändert werden, für die die entsprechende Konfiguration auch Konfigutationsverantworlicher ist)
		                        Mengen der angegebenen Mengentypen geändert werden.
		<p>
		
		</p>
		
		@return der Wert von Konfigurationsbereich.
		*/
			public Feld<	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.KonfigurationsBereich
			> getKonfigurationsbereich() {
			return _konfigurationsbereich;
		}
	
	
		/**
		Gibt an, ob zu den spezifizierten Mengentypen Mengen geändert werden dürfen.
		<p>
		
		</p>
		
		@return der Wert von MengeAendern.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 getMengeAendern() {
			return _mengeAendern;
		}
	
		/**
		Gibt an, ob zu den spezifizierten Mengentypen Mengen geändert werden dürfen.
		<p>
		
		</p>
		
		@param _mengeAendern der neue Wert von MengeAendern.
		*/
		public void setMengeAendern(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
		 _mengeAendern) {
			this._mengeAendern = _mengeAendern;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Data.ReferenceArray arrayMengentyp = datum.getReferenceArray("Mengentyp");
					arrayMengentyp.setLength(getMengentyp().size());
					for (int i = 0; i < arrayMengentyp.getLength(); ++i) {
						final Object soMengentyp = getMengentyp().get(i);
						final SystemObject tmpMengentyp;
						if (soMengentyp instanceof SystemObject) {
							tmpMengentyp = (SystemObject)soMengentyp;
						} else if(soMengentyp instanceof SystemObjekt){
							tmpMengentyp = ((SystemObjekt)soMengentyp).getSystemObject();
						} else{
							tmpMengentyp = null;
						}
						arrayMengentyp.getReferenceValue(i).setSystemObject(tmpMengentyp);
					}
				// ObjektReferenzAttributTyp
					final Data.ReferenceArray arrayKonfigurationsbereich = datum.getReferenceArray("Konfigurationsbereich");
					arrayKonfigurationsbereich.setLength(getKonfigurationsbereich().size());
					for (int i = 0; i < arrayKonfigurationsbereich.getLength(); ++i) {
						final Object soKonfigurationsbereich = getKonfigurationsbereich().get(i);
						final SystemObject tmpKonfigurationsbereich;
						if (soKonfigurationsbereich instanceof SystemObject) {
							tmpKonfigurationsbereich = (SystemObject)soKonfigurationsbereich;
						} else if(soKonfigurationsbereich instanceof SystemObjekt){
							tmpKonfigurationsbereich = ((SystemObjekt)soKonfigurationsbereich).getSystemObject();
						} else{
							tmpKonfigurationsbereich = null;
						}
						arrayKonfigurationsbereich.getReferenceValue(i).setSystemObject(tmpKonfigurationsbereich);
					}
				// GanzzahlAttributTyp
				if (getMengeAendern() != null) {
	                if (getMengeAendern().isZustand()) {
	                    datum.getUnscaledValue("MengeÄndern").setText(getMengeAendern().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("MengeÄndern").set(getMengeAendern().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Data.ReferenceArray arrayMengentyp = daten.getReferenceArray("Mengentyp");
					for (int i = 0; i < arrayMengentyp.getLength(); ++i) {
						final long idMengentyp = daten.getReferenceArray("Mengentyp").getReferenceValue(i).getId();
						final SystemObjekt tmpMengentyp;
						if (idMengentyp == 0) {
							tmpMengentyp = null;
						} else {
							final SystemObject soMengentyp = factory.getDav().getDataModel().getObject(idMengentyp);
							if (soMengentyp == null) {
									tmpMengentyp = new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.MengenTypUngueltig(idMengentyp);
							} else {
								tmpMengentyp = factory.getModellobjekt(soMengentyp);
							}
						}
							getMengentyp().add((	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.MengenTyp
							) tmpMengentyp);
					}
				// ObjektReferenzAttributTyp
					final Data.ReferenceArray arrayKonfigurationsbereich = daten.getReferenceArray("Konfigurationsbereich");
					for (int i = 0; i < arrayKonfigurationsbereich.getLength(); ++i) {
						final long idKonfigurationsbereich = daten.getReferenceArray("Konfigurationsbereich").getReferenceValue(i).getId();
						final SystemObjekt tmpKonfigurationsbereich;
						if (idKonfigurationsbereich == 0) {
							tmpKonfigurationsbereich = null;
						} else {
							final SystemObject soKonfigurationsbereich = factory.getDav().getDataModel().getObject(idKonfigurationsbereich);
							if (soKonfigurationsbereich == null) {
									tmpKonfigurationsbereich = new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.KonfigurationsBereichUngueltig(idKonfigurationsbereich);
							} else {
								tmpKonfigurationsbereich = factory.getModellobjekt(soKonfigurationsbereich);
							}
						}
							getKonfigurationsbereich().add((	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.KonfigurationsBereich
							) tmpKonfigurationsbereich);
					}
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("MengeÄndern").isState()) {
							setMengeAendern(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							.getZustand(daten.getScaledValue("MengeÄndern").getText()));
						} else {
						setMengeAendern(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
						(daten.
							getUnscaledValue
						("MengeÄndern").
								byteValue
						()));
						}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlAktivitaetMengen clone() {
		AtlAktivitaetMengen klon = new AtlAktivitaetMengen();
		
					klon._mengentyp = getMengentyp().clone();
					klon._konfigurationsbereich = getKonfigurationsbereich().clone();
						klon.setMengeAendern(getMengeAendern());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
