/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Enthält eine Datenidentifikation, die von einer Applikation angemeldet wurde.
<p>
Zu einer Datenidentifikation gehören: Systemobjekt, Attributgruppenverwendung, Simulationsvariante, Rolle(Quelle, Sender, Senke, Empfänger).
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 6
 */
public class AtlAngemeldeteDatenidentifikation implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private 	Object
			 _objekt
			;
			private 	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.AttributgruppenVerwendung
			 _attributgruppenverwendung
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttSimulationsVariante
			 _simulationsvariante
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttRolleAnmeldung
			 _rolle
			;
	
		/**
		Systemobjekt, der Datenidentifikation.
		<p>
		
		</p>
		
		@return der Wert von Objekt.
		*/
			public 	Object
			 getObjekt() {
			return _objekt;
		}
	
		/**
		Systemobjekt, der Datenidentifikation.
		<p>
		
		</p>
		
		@param _objekt der neue Wert von Objekt.
		*/
		public void setObjekt(	Object
		 _objekt) {
			this._objekt = _objekt;
		}
	
		/**
		Referenz auf eine Attributgruppenverwendung (ATG+Aspekt), die zur Datenidentifikation gehört.
		<p>
		
		</p>
		
		@return der Wert von Attributgruppenverwendung.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.AttributgruppenVerwendung
			 getAttributgruppenverwendung() {
			return _attributgruppenverwendung;
		}
	
		/**
		Referenz auf eine Attributgruppenverwendung (ATG+Aspekt), die zur Datenidentifikation gehört.
		<p>
		
		</p>
		
		@param _attributgruppenverwendung der neue Wert von Attributgruppenverwendung.
		*/
		public void setAttributgruppenverwendung(	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.AttributgruppenVerwendung
		 _attributgruppenverwendung) {
			this._attributgruppenverwendung = _attributgruppenverwendung;
		}
	
		/**
		Mit diesem Attribut werden die Simulationsvarianten spezifiziert, unter denen die angegebenen Attributgruppen unter den
								angegebenen Aspekten für die ausgewählten Konfigurationsobjekte verwaltet werden sollen.
		<p>
		
		</p>
		
		@return der Wert von Simulationsvariante.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttSimulationsVariante
			 getSimulationsvariante() {
			return _simulationsvariante;
		}
	
		/**
		Mit diesem Attribut werden die Simulationsvarianten spezifiziert, unter denen die angegebenen Attributgruppen unter den
								angegebenen Aspekten für die ausgewählten Konfigurationsobjekte verwaltet werden sollen.
		<p>
		
		</p>
		
		@param _simulationsvariante der neue Wert von Simulationsvariante.
		*/
		public void setSimulationsvariante(de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttSimulationsVariante
		 _simulationsvariante) {
			this._simulationsvariante = _simulationsvariante;
		}
	
		/**
		Rolle(Sender, Senke, Quelle, Empfänger), in der die Datenidentifikation angemeldet wurde.
		<p>
		
		</p>
		
		@return der Wert von Rolle.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttRolleAnmeldung
			 getRolle() {
			return _rolle;
		}
	
		/**
		Rolle(Sender, Senke, Quelle, Empfänger), in der die Datenidentifikation angemeldet wurde.
		<p>
		
		</p>
		
		@param _rolle der neue Wert von Rolle.
		*/
		public void setRolle(de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttRolleAnmeldung
		 _rolle) {
			this._rolle = _rolle;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final Object soObjekt = getObjekt();
					final SystemObject tmpObjekt;
						if (soObjekt instanceof SystemObject) {
							tmpObjekt = (SystemObject)soObjekt;
						} else if(soObjekt instanceof SystemObjekt){
							tmpObjekt = ((SystemObjekt)soObjekt).getSystemObject();
						} else{
							tmpObjekt = null;
						}
					datum.getReferenceValue("objekt").setSystemObject(tmpObjekt);
				// ObjektReferenzAttributTyp
					final Object soAttributgruppenverwendung = getAttributgruppenverwendung();
					final SystemObject tmpAttributgruppenverwendung;
						if (soAttributgruppenverwendung instanceof SystemObject) {
							tmpAttributgruppenverwendung = (SystemObject)soAttributgruppenverwendung;
						} else if(soAttributgruppenverwendung instanceof SystemObjekt){
							tmpAttributgruppenverwendung = ((SystemObjekt)soAttributgruppenverwendung).getSystemObject();
						} else{
							tmpAttributgruppenverwendung = null;
						}
					datum.getReferenceValue("attributgruppenverwendung").setSystemObject(tmpAttributgruppenverwendung);
				// GanzzahlAttributTyp
				if (getSimulationsvariante() != null) {
	                if (getSimulationsvariante().isZustand()) {
	                    datum.getUnscaledValue("simulationsvariante").setText(getSimulationsvariante().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("simulationsvariante").set(getSimulationsvariante().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getRolle() != null) {
	                if (getRolle().isZustand()) {
	                    datum.getUnscaledValue("rolle").setText(getRolle().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("rolle").set(getRolle().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ObjektReferenzAttributTyp
					final long idObjekt = daten.getReferenceValue("objekt").getId();
					final SystemObjekt tmpObjekt;
					if (idObjekt == 0) {
						tmpObjekt = null;
					} else {
						final SystemObject soObjekt = factory.getDav().getDataModel().getObject(idObjekt);
						if (soObjekt == null) {
								tmpObjekt = new BaseUngueltigesSystemObjekt(idObjekt);
						} else {
							tmpObjekt = factory.getModellobjekt(soObjekt);
						}
					}
					setObjekt((	Object
					) tmpObjekt);
				// ObjektReferenzAttributTyp
					final long idAttributgruppenverwendung = daten.getReferenceValue("attributgruppenverwendung").getId();
					final SystemObjekt tmpAttributgruppenverwendung;
					if (idAttributgruppenverwendung == 0) {
						tmpAttributgruppenverwendung = null;
					} else {
						final SystemObject soAttributgruppenverwendung = factory.getDav().getDataModel().getObject(idAttributgruppenverwendung);
						if (soAttributgruppenverwendung == null) {
								tmpAttributgruppenverwendung = new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AttributgruppenVerwendungUngueltig(idAttributgruppenverwendung);
						} else {
							tmpAttributgruppenverwendung = factory.getModellobjekt(soAttributgruppenverwendung);
						}
					}
					setAttributgruppenverwendung((	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.AttributgruppenVerwendung
					) tmpAttributgruppenverwendung);
				// GanzzahlAttributTyp
						setSimulationsvariante(new de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttSimulationsVariante
						(daten.
							getUnscaledValue
						("simulationsvariante").
								shortValue
						()));
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("rolle").isState()) {
							setRolle(de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttRolleAnmeldung
							.getZustand(daten.getScaledValue("rolle").getText()));
						} else {
						setRolle(new de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttRolleAnmeldung
						(daten.
							getUnscaledValue
						("rolle").
								byteValue
						()));
						}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlAngemeldeteDatenidentifikation clone() {
		AtlAngemeldeteDatenidentifikation klon = new AtlAngemeldeteDatenidentifikation();
		
						klon.setObjekt(getObjekt());
						klon.setAttributgruppenverwendung(getAttributgruppenverwendung());
						klon.setSimulationsvariante(getSimulationsvariante());
						klon.setRolle(getRolle());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
