/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Kompletter Attributpfad, Min-Max-Grenzwerte und Vorgabeflags für die formale PL-Prüfung.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlAttributSpezifikationPlausibilitaetsPruefungFormal implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private String
			 _attributPfad
			= new String
			()
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			 _min
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			 _max
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttOptionenPlausibilitaetsPruefungFormalGlobal
			 _optionen
			;
	
		/**
		Attributgruppe, innerhalb derer ein Attribut für die formale PL-Prüfung festgelegt wird.
		<p>
		Gibt den kompletten Pfad zu einem Attribut innerhalb einer Attributgruppe an. Die einzelnen Pfadbestandteile sind jeweils
								durch einen Punkt '.' separiert. Um z. B. ein Attribut mit dem Namen "maxSichtweite", welches Bestandteil einer variablen Liste (Array)
								mit dem Namen "ListeDerSichtweiten" zu spezifizieren, ist folgendes einzutragen: "ListeDerSichtweiten.2.maxSichtweite", wobei hier das
								dritte Arrayelement der Liste angesprochen wird.
		</p>
		
		@return der Wert von AttributPfad.
		*/
			public String
			 getAttributPfad() {
			return _attributPfad;
		}
	
		/**
		Attributgruppe, innerhalb derer ein Attribut für die formale PL-Prüfung festgelegt wird.
		<p>
		Gibt den kompletten Pfad zu einem Attribut innerhalb einer Attributgruppe an. Die einzelnen Pfadbestandteile sind jeweils
								durch einen Punkt '.' separiert. Um z. B. ein Attribut mit dem Namen "maxSichtweite", welches Bestandteil einer variablen Liste (Array)
								mit dem Namen "ListeDerSichtweiten" zu spezifizieren, ist folgendes einzutragen: "ListeDerSichtweiten.2.maxSichtweite", wobei hier das
								dritte Arrayelement der Liste angesprochen wird.
		</p>
		
		@param _attributPfad der neue Wert von AttributPfad.
		*/
		public void setAttributPfad(String
		 _attributPfad) {
			if (_attributPfad.length() > 32767) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
			}
			this._attributPfad = _attributPfad;
		}
	
		/**
		Unterer Grenzwert bei der formalen Plausibilitätsprüfung. Der Wert ist als 'unscaled' beim Vergleich zu interpretieren.
		<p>
		
		</p>
		
		@return der Wert von Min.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			 getMin() {
			return _min;
		}
	
		/**
		Unterer Grenzwert bei der formalen Plausibilitätsprüfung. Der Wert ist als 'unscaled' beim Vergleich zu interpretieren.
		<p>
		
		</p>
		
		@param _min der neue Wert von Min.
		*/
		public void setMin(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
		 _min) {
			this._min = _min;
		}
	
		/**
		Oberer Grenzwert bei der formalen Plausibilitätsprüfung. Der Wert ist als 'unscaled' beim Vergleich zu interpretieren.
		<p>
		
		</p>
		
		@return der Wert von Max.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			 getMax() {
			return _max;
		}
	
		/**
		Oberer Grenzwert bei der formalen Plausibilitätsprüfung. Der Wert ist als 'unscaled' beim Vergleich zu interpretieren.
		<p>
		
		</p>
		
		@param _max der neue Wert von Max.
		*/
		public void setMax(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
		 _max) {
			this._max = _max;
		}
	
		/**
		Mögliche Optionen für das Verhalten beim Umgang mit geprüften Werten der formalenPlausibilitätsprüfung.
		<p>
		
		</p>
		
		@return der Wert von Optionen.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttOptionenPlausibilitaetsPruefungFormalGlobal
			 getOptionen() {
			return _optionen;
		}
	
		/**
		Mögliche Optionen für das Verhalten beim Umgang mit geprüften Werten der formalenPlausibilitätsprüfung.
		<p>
		
		</p>
		
		@param _optionen der neue Wert von Optionen.
		*/
		public void setOptionen(de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttOptionenPlausibilitaetsPruefungFormalGlobal
		 _optionen) {
			this._optionen = _optionen;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
				if (getAttributPfad() != null) {
					datum.getTextValue("AttributPfad").setText(getAttributPfad());
				}
				// GanzzahlAttributTyp
				if (getMin() != null) {
	                if (getMin().isZustand()) {
	                    datum.getUnscaledValue("Min").setText(getMin().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Min").set(getMin().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getMax() != null) {
	                if (getMax().isZustand()) {
	                    datum.getUnscaledValue("Max").setText(getMax().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Max").set(getMax().getValue());
	                }
				}
				// GanzzahlAttributTyp
				if (getOptionen() != null) {
	                if (getOptionen().isZustand()) {
	                    datum.getUnscaledValue("Optionen").setText(getOptionen().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Optionen").set(getOptionen().getValue());
	                }
				}
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// ZeichenkettenAttributTyp
					setAttributPfad(daten.getTextValue("AttributPfad").getText());
				// GanzzahlAttributTyp
						setMin(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
						(daten.
							getUnscaledValue
						("Min").
								longValue
						()));
				// GanzzahlAttributTyp
						setMax(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
						(daten.
							getUnscaledValue
						("Max").
								longValue
						()));
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Optionen").isState()) {
							setOptionen(de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttOptionenPlausibilitaetsPruefungFormalGlobal
							.getZustand(daten.getScaledValue("Optionen").getText()));
						} else {
						setOptionen(new de.bsvrz.sys.funclib.bitctrl.modell.systemmodellglobal.attribute.AttOptionenPlausibilitaetsPruefungFormalGlobal
						(daten.
							getUnscaledValue
						("Optionen").
								byteValue
						()));
						}
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlAttributSpezifikationPlausibilitaetsPruefungFormal clone() {
		AtlAttributSpezifikationPlausibilitaetsPruefungFormal klon = new AtlAttributSpezifikationPlausibilitaetsPruefungFormal();
		
						klon.setAttributPfad(getAttributPfad());
						klon.setMin(getMin());
						klon.setMax(getMax());
						klon.setOptionen(getOptionen());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
